/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.Matrix;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.Log4Cam;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FacePositions;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.MmcvImageLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerFacePosition;
import com.momo.mcamera.mask.StickerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StickerCutFaceItem
extends StickerItem {
    public List<FacePositions> mFacePositions;
    public List<float[]> mCutFaceList = Collections.synchronizedList(new ArrayList());
    float realWidth = 0.5f;
    float mStickerScale = 1.7777778f;
    int renderWidth = 0;
    int renderHeight = 0;
    float[] texData1 = new float[]{-this.realWidth, -(this.realWidth * this.mStickerScale), 0.0f, 1.0f, this.realWidth, -this.realWidth * this.mStickerScale, 0.0f, 1.0f, -this.realWidth, this.realWidth * this.mStickerScale, 0.0f, 1.0f, this.realWidth, this.realWidth * this.mStickerScale, 0.0f, 1.0f};
    private MMFrameInfo mBitmap = null;

    public StickerCutFaceItem(Sticker inSticker, Context context) {
        super(inSticker, context);
        this.isDraw = true;
        this.mFacePositions = inSticker.getAdditionalInfo().getFacePositions();
    }

    @Override
    public MMFrameInfo getMmcvImage(Context context) {
        return this.mBitmap;
    }

    @Override
    protected MmcvImageLoader getMMcvImageLoader() {
        return new MmcvImageCacheLoader(this.sticker, this.context);
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        super.setDetectParam(param);
        if (this.renderWidth == 0 || this.renderHeight == 0) {
            return;
        }
        this.mBitmap = this.mmcvImageLoader.getMmcvImage(this.context);
        if (this.mvpLists != null && this.mvpLists.size() > 0) {
            this.mCutFaceList.clear();
            int index = this.getImageIndexByPath(this.mmcvImageLoader.imagePath);
            List<StickerFacePosition> stickerFacePositions = this.mFacePositions.get(index).getStickerFacePositions();
            Log4Cam.i((String)"huli", (String)("in " + this.sticker.curIndex));
            if (stickerFacePositions != null && stickerFacePositions.size() > 0) {
                for (StickerFacePosition position : stickerFacePositions) {
                    int centerx = position.getFacex();
                    int centery = position.getFacey();
                    int radius = (int)((double)position.getRadius() * 1.1);
                    int angle = position.getAngle();
                    float normalWidth = (float)this.renderWidth * (float)this.sticker.getImageHeight() / (float)this.renderHeight;
                    float centerxf = ((float)centerx + (normalWidth - (float)this.sticker.getImageWidth()) / 2.0f) / normalWidth;
                    float centeryf = (float)centery / (float)this.sticker.getImageHeight();
                    float fScale = param.scaleW / (float)this.sticker.getImageWidth();
                    float scale = (float)(2 * radius) * fScale;
                    float degree = param.angle + (float)angle;
                    this.calculateCutFaceMatrix(scale, scale / 16.0f * 9.0f, new PointF(centerxf, centeryf), degree, this.texData1);
                }
            }
        }
    }

    public int getImageIndexByPath(String path) {
        String[] results = path.split("_");
        String number = results[results.length - 1];
        number = number.replace(".png", "");
        return Integer.parseInt(number);
    }

    public void calculateCutFaceMatrix(float w, float h, PointF centerPoint, float angle, float[] texData1) {
        if (centerPoint == null) {
            return;
        }
        float sX = w;
        float sY = h;
        float tX = -(centerPoint.x * 2.0f - 1.0f);
        float tY = -centerPoint.y * 2.0f + 1.0f;
        float tAngle = angle;
        float[] mvpMatrix = new float[16];
        float[] newResult = new float[16];
        float[] mViewMatrix = new float[16];
        Matrix.setIdentityM((float[])mViewMatrix, (int)0);
        mViewMatrix[0] = -1.0f;
        Matrix.setIdentityM((float[])newResult, (int)0);
        Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])texData1, (int)0);
        float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
        this.mCutFaceList.add(finalResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCutFacePoints() {
        Object object = this.maskLock;
        synchronized (object) {
            if (this.mCutFaceList != null) {
                this.mCutFaceList.clear();
            }
        }
    }

    public void setRenderSize(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
    }

    @Override
    public void clearPoints() {
        super.clearPoints();
        if (this.mCutFaceList != null) {
            this.mCutFaceList.clear();
        }
    }
}

