/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.text.TextUtils;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.ArtifactframeFilter;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.MultiplyMaskBlendFilter;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.SegmentFilter;
import com.momo.mcamera.mask.SobelFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerMaskFilter;
import com.momo.mcamera.mask.TriggerBlendFilter;
import com.momo.mcamera.mask.XEngineBlendFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class StickerBlendFilter
extends GroupFilter
implements IVideoTrackTime,
FaceDetectInterface {
    public boolean isFixedFilter;
    public long mStickerDuration = -1L;
    public Sticker sticker;
    public StickerMaskFinishListener finishListener;
    public StickerStateChangeListener stickerStateChangeListener;
    TriggerBlendFilter triggerBlendFilter;
    FaceDetectFilter stickerMaskFilter;
    SegmentFilter segmentFilter;
    SobelFilter sobelFilter;
    private boolean hasShowed = false;
    long startTime = -1L;
    private boolean isPlaying;
    private boolean lastShouldShow = true;
    private int hiddenFrameCount;
    private boolean isHiddenFrame;
    private Map<String, List> coll = new HashMap<String, List>();
    private boolean hasShowedThisTrigger;
    private boolean needPlayLoop = true;

    public StickerBlendFilter(BasicFilter maskFilter, Sticker sticker) {
        boolean hasSegmentStroke;
        this.sticker = sticker;
        boolean isSegment = sticker.isClearsBodyArea();
        boolean bl = hasSegmentStroke = sticker.getStrokeColor() != null;
        int numOfInputs = isSegment ? (hasSegmentStroke ? 4 : 3) : 2;
        String stickerType = sticker.getStickerType();
        if (maskFilter instanceof FaceDetectFilter) {
            this.stickerMaskFilter = (FaceDetectFilter)maskFilter;
        }
        NormalFilter normalFilter = new NormalFilter();
        if ("FACE_MASK_TYPE".equals(stickerType)) {
            this.triggerBlendFilter = this.sticker.isComic() ? new TriggerBlendFilter() : new MultiplyMaskBlendFilter();
        } else if (null != sticker.getLayerType() && sticker.getLayerType().equals("3d")) {
            this.triggerBlendFilter = new XEngineBlendFilter(numOfInputs);
            this.triggerBlendFilter.setSegmentBody(isSegment);
        } else if (null != sticker.getLayerType() && sticker.getLayerType().equals("fault")) {
            this.triggerBlendFilter = new ArtifactframeFilter();
            this.ProcessFaultInfo(this.sticker);
        } else {
            this.triggerBlendFilter = new TriggerBlendFilter(numOfInputs);
            this.triggerBlendFilter.setSegmentBody(isSegment);
            if (sticker.getBlendMode() != null) {
                this.triggerBlendFilter.setBlendType(sticker.getBlendMode().name);
            }
        }
        normalFilter.addTarget((GLTextureInputRenderer)this.triggerBlendFilter);
        maskFilter.addTarget((GLTextureInputRenderer)this.triggerBlendFilter);
        if (isSegment) {
            this.segmentFilter = new SegmentFilter();
            this.segmentFilter.addTarget((GLTextureInputRenderer)this.triggerBlendFilter);
            if (hasSegmentStroke) {
                this.sobelFilter = new SobelFilter();
                this.segmentFilter.addTarget((GLTextureInputRenderer)this.sobelFilter);
                this.sobelFilter.addTarget((GLTextureInputRenderer)this.triggerBlendFilter);
            }
        }
        this.triggerBlendFilter.registerFilterLocation((GLTextureOutputRenderer)normalFilter, 0);
        this.triggerBlendFilter.registerFilterLocation((GLTextureOutputRenderer)maskFilter, 1);
        if (isSegment) {
            this.triggerBlendFilter.registerFilterLocation((GLTextureOutputRenderer)this.segmentFilter, 2);
            this.triggerBlendFilter.registerFilterLocation((GLTextureOutputRenderer)this.sobelFilter, 3);
        }
        this.triggerBlendFilter.addTarget((GLTextureInputRenderer)this);
        this.registerInitialFilter(normalFilter);
        this.registerInitialFilter(maskFilter);
        if (isSegment) {
            this.registerInitialFilter(this.segmentFilter);
        }
        this.registerTerminalFilter((BasicFilter)this.triggerBlendFilter);
    }

    private void ProcessFaultInfo(Sticker sticker) {
        File file;
        if (this.coll.size() > 0 && !this.coll.isEmpty()) {
            this.coll.clear();
        }
        if ((file = new File(sticker.getImageFolderPath() + "/fault.txt")).exists() && file.isFile()) {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        if ("".equals(line)) continue;
                        ArrayList<Float> list = new ArrayList<Float>();
                        String[] faultFault = line.split(" ");
                        list.add(Float.valueOf(Float.parseFloat(faultFault[1])));
                        list.add(Float.valueOf(Float.parseFloat(faultFault[2])));
                        this.coll.put(faultFault[0], list);
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setFinishListener(StickerMaskFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void clearPoints() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.clearPoints();
        }
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        if (this.triggerBlendFilter != null) {
            this.triggerBlendFilter.setMMCVInfo(mmcvInfo);
        }
        if (this.segmentFilter != null) {
            this.segmentFilter.setMMCVInfo(mmcvInfo);
        }
        if (this.sobelFilter != null) {
            FaceAttributeInfo info = mmcvInfo.getFaceAttributeInfo(0);
            if (info != null && info.getModelviewMatrix() != null && info.getRotationVector() != null) {
                this.sobelFilter.setSobelEnabled(true);
            } else {
                this.sobelFilter.setSobelEnabled(false);
            }
        }
        if (mmcvInfo.getMaxFaceCnt() == 0) {
            this.stopPlay();
        }
    }

    public void setSegmentBody(boolean segmentBody) {
        if (this.triggerBlendFilter != null) {
            this.triggerBlendFilter.setSegmentBody(segmentBody);
        }
    }

    public void setSegmentStrokeColor(float[] strokeRgbaColor) {
        if (this.triggerBlendFilter != null) {
            this.triggerBlendFilter.setSegmentStrokeColor(strokeRgbaColor);
        }
    }

    public void setSegmentStrokeRadius(int strokeRadius) {
        if (this.triggerBlendFilter != null) {
            this.triggerBlendFilter.setSegmentStrokeRadius(strokeRadius);
        }
    }

    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        boolean isCVTriggered = true;
        if (null != param.filterTrigerManager) {
            isCVTriggered = param.filterTrigerManager.triggerTypeProcess(this.sticker, this.stickerStateChangeListener);
        }
        if (!(!isCVTriggered || TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType()) && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            isCVTriggered = param.filterTrigerManager.objectTriggerTypeProcess(this.sticker, param, false);
        }
        boolean shouldShow = isCVTriggered;
        if (!(this.sticker.getMinHiddenFrameCount() <= 0 || this.sticker.getHiddenTriggerType() <= 0 && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            if (!shouldShow && this.lastShouldShow) {
                this.isHiddenFrame = true;
            }
            if (this.isHiddenFrame) {
                if (this.sticker.getMinHiddenFrameCount() > 0 && this.hiddenFrameCount > this.sticker.getMinHiddenFrameCount() + 2) {
                    this.hiddenFrameCount = 0;
                    this.isHiddenFrame = false;
                }
                if (this.isHiddenFrame) {
                    shouldShow = false;
                    ++this.hiddenFrameCount;
                }
            }
        }
        if (this.hasShowedThisTrigger && (this.sticker.isNotHiddenAfterTrigger() || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
            shouldShow = true;
        }
        if (this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.getLoopStart() == -1) {
            this.needPlayLoop = false;
        }
        if (shouldShow) {
            if (isCVTriggered && this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1) {
                this.sticker.curIndex = 0;
            }
            if (!this.needPlayLoop) {
                return;
            }
            if (null != this.stickerMaskFilter) {
                this.stickerMaskFilter.resumeBitmapCache();
            }
            this.triggerBlendFilter.setBlend(shouldShow);
            this.hasShowed = true;
            this.startPlay();
            this.lastShouldShow = true;
            this.isHiddenFrame = false;
        } else {
            if (this.sticker.isNotHiddenAfterTrigger()) {
                this.lastShouldShow = shouldShow;
            }
            if (this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.curIndex > 0) {
                shouldShow = true;
                this.resumeDisplay();
            } else if (this.sticker.isNoBreakLoop() && this.sticker.curIndex < this.sticker.getFrameNumber() - 1 && this.hasShowed && this.sticker.curIndex > 0 && this.needPlayLoop) {
                shouldShow = true;
                this.resumeDisplay();
            } else {
                this.triggerBlendFilter.setBlend(false);
                if (null != this.stickerMaskFilter) {
                    this.stickerMaskFilter.pauseBitmapCache();
                }
                if (!(this.sticker.curIndex != this.sticker.getFrameNumber() - 1 || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
                    this.sticker.curIndex = 0;
                }
                this.stopPlay();
            }
        }
        if (shouldShow) {
            this.hasShowedThisTrigger = true;
        }
        if (null != this.stickerStateChangeListener && !TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType())) {
            this.stickerStateChangeListener.stickerGestureTypeChanged(this.sticker.getObjectTriggerType(), shouldShow);
        }
        if (this.mStickerDuration > -1L && this.startTime != -1L && System.currentTimeMillis() - this.startTime > this.mStickerDuration) {
            this.stickerMaskFilter.clearPoints();
            if (null != this.finishListener) {
                this.finishListener.stickerRenderFinished();
            }
            this.stopPlay();
            return;
        }
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.setDetectParam(param);
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    private void resumeDisplay() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.resumeBitmapCache();
        }
        this.triggerBlendFilter.setBlend(true);
        this.startPlay();
    }

    public void startPlay() {
        if (!this.isPlaying) {
            if (null != this.stickerStateChangeListener && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), true);
            }
            this.isPlaying = true;
        }
    }

    public void stopPlay() {
        if (this.isPlaying) {
            if (null != this.stickerStateChangeListener && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), false);
            }
            this.isPlaying = false;
        }
    }

    public long getEscapedTime() {
        if (System.currentTimeMillis() - this.startTime >= this.mStickerDuration) {
            return this.mStickerDuration;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public void cancelDraw() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.cancelDraw();
        }
    }

    public void destroy() {
        super.destroy();
        this.cancelDraw();
        this.finishListener = null;
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.cancelDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.clearPoints();
            this.sticker = sticker;
            if (null != this.stickerMaskFilter) {
                this.stickerMaskFilter.resetSticker(sticker);
                this.startTime = -1L;
            }
        }
    }

    public void setTimeStamp(long ms) {
        if (null != this.stickerMaskFilter && this.stickerMaskFilter instanceof IVideoTrackTime) {
            ((IVideoTrackTime)this.stickerMaskFilter).setTimeStamp(ms);
        }
    }

    public void pauseBitmapCache() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.pauseBitmapCache();
        }
    }

    public void resumeBitmapCache() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.resumeBitmapCache();
        }
    }

    public void lockTexture() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.lockTexture();
        }
    }

    public void unlockTexture() {
        if (null != this.stickerMaskFilter) {
            this.stickerMaskFilter.unlockTexture();
        }
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        String[] imagePathName;
        super.newTextureReady(texture, source, newData);
        if (this.triggerBlendFilter instanceof ArtifactframeFilter && ((StickerMaskFilter)this.stickerMaskFilter).getImagePathName() != null && this.coll.containsKey((imagePathName = ((StickerMaskFilter)this.stickerMaskFilter).getImagePathName().split("/"))[imagePathName.length - 1])) {
            ((ArtifactframeFilter)this.triggerBlendFilter).setFaultInfo(((Float)this.coll.get(imagePathName[imagePathName.length - 1]).get(0)).floatValue(), ((Float)this.coll.get(imagePathName[imagePathName.length - 1]).get(1)).floatValue());
        }
    }

    public static interface StickerStateChangeListener {
        public void stickerStateChanged(int var1, int var2);

        public void stickerGestureTypeChanged(String var1, boolean var2);

        public void faceDetected(boolean var1);

        public void playStateChanged(int var1, boolean var2);

        public void distortionStateChanged(boolean var1, float var2, float var3, float var4, float var5);
    }

    public static interface StickerMaskFinishListener {
        public void stickerRenderFinished();
    }
}

