/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.config.Size;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.datadot.DataDotUtils;
import com.core.glcore.datadot.RecoderDotUtil;
import com.core.glcore.util.BodyLandHelper;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.cosmos.mdlog.MDLog;
import com.google.ar.core.Frame;
import com.google.ar.core.Session;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.mask.ARCoreFrameListener;
import com.momo.mcamera.mask.BeautyFace;
import com.momo.mcamera.mask.Capture3DImageListener;
import com.momo.mcamera.mask.EffectGroupFilter;
import com.momo.mcamera.mask.Face3DMaskFilter;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FaceMaskFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.MultiStickerCutFaceMaskFilter;
import com.momo.mcamera.mask.MultiStickerGameMaskFilter;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.SoundInputFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerEtc1MaskFilter;
import com.momo.mcamera.mask.StickerGestureMaskFilter;
import com.momo.mcamera.mask.StickerGestureTrackingFilter;
import com.momo.mcamera.mask.StickerGroupFilter;
import com.momo.mcamera.mask.StickerMaskFilter;
import com.momo.mcamera.mask.WeexStickerMaskFilter;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.bean.ViewPortProportion;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import com.momo.mcamera.mask.express.ExpressDetector;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momo.mcamera.mask.gesture.GestureDetector;
import com.momo.mcamera.mask.gesture.NewHandGestureDetector;
import com.momo.mcamera.util.ArCoreHelper;
import com.momo.mcamera.util.PointHelper;
import com.momo.render.SharedExecutor;
import com.momocv.MMBox;
import com.momocv.MMRect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import project.android.imageprocessing.EffectTimeBean;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.filter.processing.LookUpIntensityInterface;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.ARCoreInterface;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.MStickerActions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class StickerAdjustFilter
extends StickerGroupFilter
implements IVideoTrackTime,
ARCoreInterface,
LookUpIntensityInterface {
    public static final int POINTS_LENGTH = 68;
    public static final long DEFAULT_LONG_DURATION = 99999999999L;
    private static final int SOUND_PULL_SIZE = 5;
    private static final long DEFAULT_DURATION = 30000000L;
    private final String TAG = "StickerAdjustFilter";
    public SoundInputFilter mSoundInput;
    public boolean enableSelfRender = false;
    ConcurrentHashMap<String, StickerBlendFilter> mStickerFilterMap;
    ConcurrentHashMap<String, MaskModel> mGestureTriggerModels;
    int lastFacesCnt = 0;
    PointF lastFacePosition = new PointF(0.0f, 0.0f);
    private List<GLRenderer> filtersToDestroy;
    private NormalFilter mNormalFilter;
    private Context mContext;
    private BasicFilter mTerminalFilter;
    private StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener;
    private FilterTriggerManager filterTriggerManager;
    private float mBigEye;
    private float mThinFace;
    private CVDetector gestureDetector;
    private MMCVBoxes mmcvBoxes;
    private SoundPool soundPool;
    private MediaPlayer soundPlayer;
    private boolean enableSoundPool;
    private ArrayList<Integer> soundIds = new ArrayList();
    private GestureDetectedListener gestureDetectedListener;
    private StickerMaskFinishListener finishListener;
    private MMRect mmcvRect;
    private StickerGestureTrackingFilter mGestureTrackingFilter;
    private List<Face3DMaskFilter> face3DMaskFilters;
    private boolean isCameraFront = false;
    private CVDetector.GestureDetectorListener gestureDetectorListener;
    private MMCVInfo mCurCVInfo;
    private long startTime = 0L;
    private long time = System.currentTimeMillis();
    private MultiStickerMaskFilter mMultiStickerMaskFilter;
    private int scaleWidth = 0;
    private int scaleHeight = 0;
    private float scaleWidthRatio = 1.0f;
    private float scaleHeightRatio = 1.0f;
    private int groupNumber = 0;
    private boolean useBlendFilter = false;
    private boolean hasExpressionModel = false;
    private boolean isplayStatusTriggered = false;
    private MStickerActions.onPlayStatusListener playStatusListener;
    private boolean multiSwitchEnable = false;
    private ExpressDetector expressDetector;
    private ARCoreFrameListener mArCoreFrameListener;
    private List<Sticker> mSwapFacialMaskSticker;
    private FaceMaskFilter mFaceMaskFilter;
    EffectGroupFilter mEffectGroupFilter;
    private int mCount = 0;
    private Mask mDistorationMask = null;
    private BeautyFace mBeautyFace = null;
    private boolean mFaceBeauty = false;
    private boolean mFaceStateChange = false;
    private float mFaceThinValue = 0.0f;
    private float mBigEyeValue = 0.0f;
    private boolean mFaceBeautyHaveFinish = false;
    private int mPollGroupNum = 0;
    private long mLastRenderTime = 0L;
    private SingleLineGroupFilter mLookupFilter = null;
    private Map<Integer, SoundPoolInfo> soundInfoMap = new HashMap<Integer, SoundPoolInfo>();

    public StickerAdjustFilter(Context context) {
        this.mContext = context;
        this.filterTriggerManager = new FilterTriggerManager();
        this.mNormalFilter = new NormalFilter();
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
        this.mStickerFilterMap = new ConcurrentHashMap();
        this.mGestureTriggerModels = new ConcurrentHashMap();
        this.registerInitialFilter(this.mNormalFilter);
        this.registerTerminalFilter(this.mNormalFilter);
        this.mTerminalFilter = this.mNormalFilter;
        this.filtersToDestroy = new ArrayList<GLRenderer>();
        this.soundPool = new SoundPool(5, 3, 5);
    }

    public StickerBlendFilter.StickerStateChangeListener getStickerStateChangeListener() {
        return this.stickerStateChangeListener;
    }

    public void setStickerStateChangeListener(StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        this.stickerStateChangeListener = stickerStateChangeListener;
    }

    public void setEnableSound(boolean enableSound) {
        this.enableSoundPool = enableSound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceBytes(byte[] bytes) {
        Object object = this.listLock;
        synchronized (object) {
            if (null != this.mSoundInput) {
                this.mSoundInput.setSoundBytes(bytes);
            }
        }
    }

    public void startExpressDetect(String modelPath) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter startExpressDetect");
        if (this.expressDetector == null) {
            this.expressDetector = new ExpressDetector();
        }
        this.expressDetector.setModelPath(modelPath);
        this.expressDetector.startDetect();
    }

    public void stopExpressDetect() {
        if (this.expressDetector != null) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopExpressDetect");
            this.expressDetector.stopDetect();
        }
    }

    public void startGestureDetect() {
        this.startGestureDetect(false, 0);
    }

    public void startGestureDetect(boolean useNewVersion, int handGestureType) {
        MDLog.i((String)"FilterProcess", (String)("StickerAdjustFilter startGestureDetect useNewVersion " + useNewVersion + " handGestureType = " + handGestureType));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraUseHandGesture(true);
        if (this.gestureDetectorListener == null) {
            this.gestureDetectorListener = new CVDetector.GestureDetectorListener(){

                @Override
                public void gestureDetect(MMCVBoxes boxes) {
                    if (null != boxes && boxes.getDetectResult() != null && boxes.getDetectResult().length > 0) {
                        StickerAdjustFilter.this.mmcvBoxes = boxes;
                        for (MMBox mmBox : boxes.getDetectResult()) {
                            String gestureType = mmBox.class_name_;
                            if (mmBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)gestureType)) continue;
                            StickerAdjustFilter.this.addGestureMaskModel(gestureType);
                            if (StickerAdjustFilter.this.gestureDetectedListener == null) continue;
                            StickerAdjustFilter.this.gestureDetectedListener.gestureDetected(gestureType);
                        }
                    } else {
                        StickerAdjustFilter.this.mmcvBoxes = null;
                        if (StickerAdjustFilter.this.mGestureTrackingFilter != null) {
                            StickerAdjustFilter.this.mGestureTrackingFilter.gestureMiss();
                        }
                    }
                }
            };
        }
        if (null == this.gestureDetector) {
            if (!useNewVersion) {
                this.gestureDetector = new GestureDetector(this.gestureDetectorListener);
            } else {
                NewHandGestureDetector handGestureDetect = new NewHandGestureDetector();
                handGestureDetect.setGestureDetectorListener(this.gestureDetectorListener);
                this.gestureDetector = handGestureDetect;
            }
        } else if (this.gestureDetector instanceof GestureDetector && useNewVersion) {
            NewHandGestureDetector handGestureDetect = new NewHandGestureDetector();
            handGestureDetect.setGestureDetectorListener(this.gestureDetectorListener);
            this.gestureDetector = handGestureDetect;
        } else if (this.gestureDetector instanceof NewHandGestureDetector && !useNewVersion) {
            this.gestureDetector = new GestureDetector(this.gestureDetectorListener);
        }
        if (this.gestureDetector instanceof NewHandGestureDetector) {
            ((NewHandGestureDetector)this.gestureDetector).setHandGestureType(handGestureType);
        }
        this.gestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
        this.gestureDetector.startDetect();
    }

    public void setGestureDetectInterval(int interval) {
        if (this.gestureDetector != null) {
            this.gestureDetector.setDetectInterval(interval);
        }
    }

    public void switchCamera(boolean isFront) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter switchCamera ");
        this.isCameraFront = isFront;
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                face3DMaskFilter.setCamera(isFront);
            }
        }
    }

    public void setDefaultCameraDirection(boolean cameraFront) {
        this.isCameraFront = cameraFront;
    }

    public void stopGestureDetect() {
        if (null != this.gestureDetector) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopGestureDetect ");
            this.mmcvBoxes = null;
            this.gestureDetector.stopDetect();
        }
    }

    public void removeGestureModel(String gestureTriggerType) {
        this.mGestureTriggerModels.remove(gestureTriggerType);
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter removeGestureModel ");
    }

    public void addGestureModel(String gestureTriggerType, MaskModel maskModel) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureModel ");
        maskModel.setModelType(4);
        this.mGestureTriggerModels.put(gestureTriggerType, maskModel);
        if (null != this.gestureDetector) {
            this.gestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
            this.gestureDetector.startDetect();
        }
    }

    private void addGestureMaskModel(String gestureTriggerType) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureMaskModel ");
        MaskModel model = this.mGestureTriggerModels.get(gestureTriggerType);
        this.addGestureMaskModel(gestureTriggerType, model);
    }

    public void addGestureMaskModel(String gestureTriggerType, MaskModel model) {
        MDLog.i((String)"FilterProcess", (String)("StickerAdjustFilter addGestureMaskModel gestureTriggerType = " + gestureTriggerType));
        if (null == model) {
            return;
        }
        if (!FilterTriggerManager.isTriggerRegionMatches(this.mmcvBoxes, gestureTriggerType, model, this.getWidth(), this.getHeight())) {
            return;
        }
        if (this.gestureDetectedListener != null) {
            this.gestureDetectedListener.onPreGestureAdded(gestureTriggerType);
        }
        if (model.addTime == 0L || System.currentTimeMillis() - model.addTime > model.getDuration() + 1000L) {
            model.addTime = System.currentTimeMillis();
            model.setDuration(model.getDuration());
            if (null != model) {
                this.addMaskModel(model);
                this.startTime = 0L;
            }
        }
    }

    public void addHaniSticker(MaskModel model, int haniId) {
        if (this.mMultiStickerMaskFilter == null) {
            this.mMultiStickerMaskFilter = new MultiStickerMaskFilter(this.mContext);
            this.mMultiStickerMaskFilter.setPollGroupNumber(model.getPollGroupNum());
            this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
        }
        if (model == null) {
            return;
        }
        for (Sticker sticker : model.getStickers()) {
            String triggerType = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
            sticker.setStickerType(model.getModelType() + "_" + triggerType + haniId);
            sticker.setModelType(haniId);
            sticker.setDuration(99999999999L);
            sticker.setFrameRate(model.getFrameRate());
            sticker.isHaniSticker = true;
            this.addSticker(sticker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHaniSticker(int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.removeHaniSticker(haniId);
            }
            this.clearMaskWithModelType(haniId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addMaskModel(MaskModel model) {
        int i;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addMaskModel ");
        if (model == null) {
            RecoderDotUtil.getInstance().setUseSticker(false);
            return;
        }
        RecoderDotUtil.getInstance().setUseSticker(true);
        this.useBlendFilter = false;
        if (model.getModelType() == 0 || model.getModelType() == 7) {
            void var3_8;
            if (model.getModelType() == 0) {
                this.clearMaskWithModelType(0);
            }
            if (model.getAdditionalInfo() != null) {
                BodyLandHelper.setUseBodyLand((boolean)model.getAdditionalInfo().isBodyDetectEnable());
            }
            i = 0;
            boolean bl = false;
            this.mPollGroupNum = model.getPollGroupNum();
            if (model.getModelType() == 0) {
                this.hasExpressionModel = false;
                this.multiSwitchEnable = false;
            } else if (model.getModelType() == 7) {
                if (this.hasExpressionModel) {
                    return;
                }
                this.hasExpressionModel = true;
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isMultiFaceSwitchEnable()) {
                this.multiSwitchEnable = true;
                DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraEnableMultiFaces(this.multiSwitchEnable);
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isAnimojiDetectEnable()) {
                FacerigHelper.setUseAnimojiFaceRig((boolean)true);
            } else {
                FacerigHelper.setUseAnimojiFaceRig((boolean)false);
            }
            int segmentCount = 0;
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                List<Sticker> stickerLists = model.getStickers();
                ArrayList faceMaskSticker = new ArrayList();
                for (int j = 0; j < stickerLists.size(); ++j) {
                    if (!((Sticker)stickerLists.get(j)).getStickerType().equals("FACE_MASK_TYPE")) continue;
                    faceMaskSticker.add(stickerLists.get(j));
                    stickerLists.remove(j);
                }
                for (Sticker faceSticker : faceMaskSticker) {
                    stickerLists.add(faceSticker);
                }
                model.setStickers(stickerLists);
            }
            for (Sticker sticker : model.getStickers()) {
                if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                    sticker.setComic(true);
                }
                if (TextUtils.isEmpty((CharSequence)sticker.getStickerType()) || !sticker.getStickerType().equals("STICKER_TYPE_VOICE") && !sticker.getStickerType().equals("FACE_MASK_TYPE") && !sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    int index = i;
                    if (this.mMultiStickerMaskFilter != null) {
                        index += this.mMultiStickerMaskFilter.getStickerItemListSize();
                    }
                    if (this.mStickerFilterMap != null) {
                        index += this.mStickerFilterMap.size();
                    }
                    sticker.setStickerType(model.getModelType() + "_" + index);
                    sticker.setDuration(99999999999L);
                }
                if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    for (LookUpModel lookupFilter : model.getLookUpFilters()) {
                        lookupFilter.setPresetFilter(MMPresetFilterStore.getPresetFilterByFolder(this.mContext, sticker.getImageFolderPath() + "/" + lookupFilter.getFolder()));
                        sticker.setStickerType("FACE_LOOK_UP_TYPE");
                        sticker.setTriggerType(lookupFilter.getTriggerType());
                        sticker.setLookUpModel(lookupFilter);
                        sticker.setHiddenTriggerType(lookupFilter.getHiddenTriggerType());
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d")) {
                    sticker.setXengineEsPath(model.getXengineEsPath());
                    this.useBlendFilter = true;
                }
                if (sticker.isClearsBodyArea()) {
                    this.useBlendFilter = true;
                    this.enableSelfRender = false;
                    ++segmentCount;
                }
                if (this.isBlendSticker(sticker)) {
                    this.useBlendFilter = true;
                }
                if (sticker.getAdditionalInfo() != null && sticker.getAdditionalInfo().getFacePositions() != null) {
                    sticker.isCutFaceSticker = true;
                }
                sticker.setModelType(model.getModelType());
                if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                    void var3_7;
                    ++var3_7;
                }
                this.addSticker(sticker);
                ++i;
            }
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.addStickerList(this.mSwapFacialMaskSticker);
            }
            if (segmentCount > 0) {
                SegmentHelper.setSegmentCount((int)segmentCount);
            }
            if (!TextUtils.isEmpty((CharSequence)model.getSoundPath())) {
                ++var3_8;
            }
            if (this.enableSoundPool) {
                if (!TextUtils.isEmpty((CharSequence)model.getSound()) && this.soundPlayer == null) {
                    this.soundPlayer = new MediaPlayer();
                    this.soundPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                        public boolean onError(MediaPlayer mp, int what, int extra) {
                            MDLog.e((String)"FilterProcess", (String)("Audio Player Error what = " + what + " extra = " + extra));
                            return false;
                        }
                    });
                    this.soundPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer player) {
                            MDLog.d((String)"FilterProcess", (String)"Audio Player onPrepared");
                            player.setLooping(true);
                            player.start();
                        }
                    });
                    this.soundPlayer.setAudioStreamType(3);
                    try {
                        this.soundPlayer.setDataSource(model.getSoundPath());
                        this.soundPlayer.prepareAsync();
                    }
                    catch (Exception e) {
                        MDLog.e((String)"FilterProcess", (String)"MediaPlayerDataSourceHelper.setMediaPlayerDataSource Error");
                        this.soundPlayer.release();
                        this.soundPlayer = null;
                    }
                }
                this.tryLoadSound(model, (int)var3_8);
            }
        } else if (model.getModelType() == 4) {
            if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.isTrackingInit()) {
                return;
            }
            this.clearMaskWithModelType(model.getModelType());
            this.mPollGroupNum = model.getPollGroupNum();
            i = 0;
            for (Sticker sticker : model.getStickers()) {
                String triggerType = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + triggerType + i);
                sticker.setTriggerRegion(model.getTriggerRegion());
                sticker.setModelType(model.getModelType());
                sticker.setFrameRate(model.getFrameRate());
                if ("object_follower".equals(sticker.getLayerType()) && !sticker.isDonotTrack()) {
                    sticker.setDuration(99999999999L);
                } else {
                    sticker.setDuration(model.getDuration());
                }
                this.addSticker(sticker);
                ++i;
            }
        } else if (model.getModelType() == 6) {
            this.mPollGroupNum = model.getPollGroupNum();
            if (this.mMultiStickerMaskFilter == null) {
                this.mMultiStickerMaskFilter = new MultiStickerGameMaskFilter(this.mContext);
                this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
            }
            for (Sticker sticker : model.getStickers()) {
                sticker.setDuration(99999999999L);
                sticker.setFrameRate(model.getFrameRate());
                String triggerType = sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + triggerType);
                if (triggerType != null && triggerType.equals("game_over")) {
                    sticker.setType(5);
                    sticker.setAlwaysShow(true);
                    AbsolutePosition position = new AbsolutePosition();
                    ObjectRegion center = new ObjectRegion();
                    center.x = 0.5f;
                    center.y = 0.25f;
                    center.w = sticker.getImageWidth();
                    center.h = sticker.getImageHeight();
                    ViewPortProportion portProportion = new ViewPortProportion();
                    portProportion.height = 1920;
                    portProportion.width = 1080;
                    position.setCenter(center);
                    position.setViewport(portProportion);
                    sticker.setAbsolutePos(position);
                } else {
                    sticker.isGameSticker = true;
                    sticker.setLayerType("face");
                    sticker.setGroupNumber(this.groupNumber);
                    sticker.setAlwaysShow(true);
                }
                this.addSticker(sticker);
            }
            ++this.groupNumber;
            boolean soundSize = false;
            if (this.enableSoundPool) {
                if (this.soundPool == null) {
                    this.soundPool = new SoundPool(5, 3, 5);
                }
                if (null != this.soundPool) {
                    if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
                        model.setSoundId(this.soundPool.load(model.getSoundPath(), 999));
                        this.soundPool.play(model.getSoundId(), 1.0f, 1.0f, 1, 1, 1.0f);
                        this.soundIds.add(model.getSoundId());
                    }
                    this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                            StickerAdjustFilter.this.updateSoundPoolLoadedStatus(soundPool, sampleId, status);
                        }
                    });
                    for (Sticker sticker : model.getStickers()) {
                        if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                        sticker.setSoundId(this.soundPool.load(sticker.getSoundPath(), 999));
                        this.soundIds.add(sticker.getSoundId());
                    }
                }
            }
        } else {
            this.addCommonModel(model);
        }
        if (model.getEffectList() != null) {
            this.addEffectProcessFilter(model);
        }
        if (model.getDistortionList() != null) {
            for (Mask mask : model.getDistortionList()) {
                if (mask.getHidingObjectTriggerType() == null) continue;
                this.mDistorationMask = mask;
                this.mFaceThinValue = this.mDistorationMask.getStrength();
                this.mBigEyeValue = this.mDistorationMask.getStrengthB();
                break;
            }
        }
        if (model.getBeautyFace() != null && this.mDistorationMask != null) {
            this.mBeautyFace = model.getBeautyFace();
        }
        if (model.getAdditionalInfo() != null) {
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                    if (model.getStickers() == null || face3DMaskFilter.getSticker() == null || !model.getStickers().contains(face3DMaskFilter.getSticker())) continue;
                    face3DMaskFilter.setAdditionalInfo(model.getAdditionalInfo());
                }
            }
            if (model.getAdditionalInfo().isObjectDetectEnable()) {
                this.startGestureDetect();
            }
        }
        this.useBlendFilter = false;
    }

    private void addEffectProcessFilter(MaskModel model) {
        if (this.mEffectGroupFilter == null) {
            this.mEffectGroupFilter = new EffectGroupFilter();
            this.mEffectGroupFilter.setRenderFinishListener(new EffectGroupFilter.EffectRenderFinishListener(){

                @Override
                public void onRenderFinish() {
                    StickerAdjustFilter.this.removeEffectFilter((BasicFilter)StickerAdjustFilter.this.mEffectGroupFilter);
                    StickerAdjustFilter.this.filtersToDestroy.add(StickerAdjustFilter.this.mEffectGroupFilter);
                    StickerAdjustFilter.this.mEffectGroupFilter = null;
                }
            });
            this.addTerminalFilter((BasicFilter)this.mEffectGroupFilter);
        }
        for (EffectFilterItem effectItem : model.getEffectList()) {
            effectItem.setModelType(model.getModelType());
            if (effectItem.getDuration() == 0L) {
                effectItem.setDuration(model.getDuration());
            }
            this.mEffectGroupFilter.addEffectFilterItem(effectItem);
        }
    }

    private void addCommonModel(MaskModel model) {
        if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
            List<Sticker> stickerLists = model.getStickers();
            ArrayList<Sticker> faceMaskSticker = new ArrayList<Sticker>();
            Iterator<Sticker> iterator = stickerLists.iterator();
            while (iterator.hasNext()) {
                Sticker next = iterator.next();
                if (!"FACE_MASK_TYPE".equals(next.getStickerType())) continue;
                faceMaskSticker.add(next);
                iterator.remove();
            }
            stickerLists.addAll(faceMaskSticker);
            model.setStickers(stickerLists);
        }
        this.mPollGroupNum = model.getPollGroupNum();
        int i = 0;
        int segmentCount = 0;
        int soundSize = 0;
        for (Sticker sticker : model.getStickers()) {
            if ("audio_visualizer".equals(sticker.getResourceType())) continue;
            if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                sticker.setStickerType("FACE_MASK_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                sticker.setStickerType("FACE_LOOK_UP_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                sticker.setStickerType("STICKER_TYPE_VOICE");
            } else if (TextUtils.isEmpty((CharSequence)sticker.getStickerType())) {
                sticker.setStickerType(model.getModelType() + "_" + i);
            }
            sticker.setModelType(model.getModelType());
            sticker.setFrameRate(model.getFrameRate());
            if (sticker.getDuration() == 0L) {
                sticker.setDuration(model.getDuration() > 0L ? model.getDuration() : 99999999999L);
            }
            if ("3d".equals(sticker.getLayerType())) {
                this.useBlendFilter = true;
                sticker.setXengineEsPath(model.getXengineEsPath());
            }
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
                ++segmentCount;
            }
            if (this.isBlendSticker(sticker)) {
                this.useBlendFilter = true;
            }
            if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                ++soundSize;
            }
            this.addSticker(sticker);
            ++i;
        }
        if (segmentCount > 0) {
            SegmentHelper.setSegmentCount((int)segmentCount);
        }
        if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
            ++soundSize;
        }
        if (this.enableSoundPool) {
            this.tryLoadSound(model, soundSize);
        }
    }

    private synchronized void updateSoundPoolLoadedStatus(SoundPool pool, int sampleId, int status) {
        MDLog.d((String)"media", (String)("update loadedStatus cur id=" + sampleId));
        if (pool != null && sampleId > 0 && status == 0) {
            SoundPoolInfo info = this.soundInfoMap.get(sampleId);
            if (info == null) {
                info = new SoundPoolInfo();
                info.soundId = sampleId;
                info.isLoaded = true;
                this.soundInfoMap.put(sampleId, info);
                MDLog.d((String)"media", (String)("[SoundPool]sticker is not playing, so put info to map id=" + sampleId));
            } else {
                MDLog.d((String)"media", (String)("[SoundPool]sticker is playing now , so execute runable id=" + sampleId));
                info.isLoaded = true;
                if (info.runnable != null) {
                    info.runnable.run();
                    info.runnable = null;
                }
            }
        }
    }

    private synchronized void clearAllSoundPoolInfo() {
        MDLog.d((String)"media", (String)"[SoundPool]clear all soundInfo ");
        this.soundInfoMap.clear();
    }

    private synchronized void setRunableCalledWhenLoaded(int sampleId, Runnable runable) {
        MDLog.d((String)"media", (String)("[SoundPool] set runable info id = " + sampleId));
        if (sampleId > 0 && runable != null) {
            SoundPoolInfo info = this.soundInfoMap.get(sampleId);
            if (info != null && info.isLoaded) {
                MDLog.d((String)"media", (String)"[SoundPool] sample is is loaded , execute runable   + sampleid=", (Object[])new Object[]{sampleId});
                runable.run();
            } else {
                MDLog.d((String)"media", (String)"[SoundPool] sample is not loaded, just update it ");
                if (info == null) {
                    info = new SoundPoolInfo();
                }
                info.soundId = sampleId;
                info.runnable = runable;
                this.soundInfoMap.put(sampleId, info);
            }
        }
    }

    private void tryLoadSound(MaskModel model, int soundSize) {
        this.clearAllSoundPoolInfo();
        if (this.soundPool != null) {
            for (Integer soundId : this.soundIds) {
                this.soundPool.unload(soundId.intValue());
            }
            this.soundPool.release();
            this.soundPool = new SoundPool(soundSize, 3, 5);
            this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                    StickerAdjustFilter.this.updateSoundPoolLoadedStatus(soundPool, sampleId, status);
                }
            });
            for (Sticker sticker : model.getStickers()) {
                if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                int sampleId = this.soundPool.load(sticker.getSoundPath(), 999);
                MDLog.e((String)"media", (String)("[SoundPool]load tag is " + sampleId));
                sticker.setSoundId(sampleId);
                this.soundIds.add(sticker.getSoundId());
            }
        }
    }

    private boolean isBlendSticker(Sticker sticker) {
        return sticker.getBlendMode() != null && !TextUtils.isEmpty((CharSequence)sticker.getBlendMode().name);
    }

    public float getThinFace() {
        return this.mThinFace;
    }

    public void setThinFace(float thinFace) {
        this.mThinFace = thinFace;
    }

    public float getBigEye() {
        return this.mBigEye;
    }

    public void setBigEye(float bigEye) {
        this.mBigEye = bigEye;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFaceDetectFilter(FaceDetectFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
        }
    }

    public void setFinishListener(StickerMaskFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addSticker(final Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            StickerBlendFilter filter;
            sticker.curIndex = 0;
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
            }
            if (sticker.getTriggerType() > 0) {
                this.filterTriggerManager.setTriggerType(sticker.getTriggerType());
            }
            if (sticker.getHiddenTriggerType() > 0) {
                this.filterTriggerManager.setHiddenTriggerType(sticker.getHiddenTriggerType());
            }
            if ((filter = this.mStickerFilterMap.get(sticker.getStickerType())) == null) {
                BasicFilter maskFilter;
                if (sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                    maskFilter = new SoundInputFilter();
                    this.mSoundInput = maskFilter;
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type STICKER_TYPE_VOICE SoundInputFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("object_follower") && !sticker.isHaniSticker) {
                    maskFilter = new StickerGestureMaskFilter(this.mContext, sticker);
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type LAYER_TYPE_GESTURE StickerGestureMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                    if (this.mSwapFacialMaskSticker == null) {
                        this.mSwapFacialMaskSticker = new ArrayList<Sticker>();
                    }
                    this.mFaceMaskFilter = new FaceMaskFilter(sticker);
                    maskFilter = this.mFaceMaskFilter;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_MASK_TYPE FaceMaskFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d") && MediaModuleGlobalConfig.hasXE()) {
                    if (this.face3DMaskFilters == null) {
                        this.face3DMaskFilters = new ArrayList<Face3DMaskFilter>();
                    }
                    Face3DMaskFilter face3DMaskFilter = new Face3DMaskFilter(sticker, this.isCameraFront, this.mContext);
                    this.face3DMaskFilters.add(face3DMaskFilter);
                    maskFilter = face3DMaskFilter;
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_3D_MASK_TYPE Face3DMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    if (null != sticker.getLookUpModel() && null != sticker.getLookUpModel().getPresetFilter()) {
                        maskFilter = sticker.getLookUpModel().getPresetFilter().getFilterGroup();
                        this.mLookupFilter = (SingleLineGroupFilter)maskFilter;
                    } else {
                        maskFilter = new NormalFilter();
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_LOOK_UP_TYPE !!!");
                } else if (this.useBlendFilter && (sticker.getStickerType() == null || !sticker.getStickerType().startsWith("weex")) || sticker.isComic()) {
                    maskFilter = sticker.getEtcTextureBatch() != null ? new StickerEtc1MaskFilter(this.mContext, sticker) : new StickerMaskFilter(this.mContext, sticker, sticker.getImageProvider());
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                } else {
                    if (this.mMultiStickerMaskFilter == null) {
                        MDLog.e((String)"FilterProcess", (String)"optimization");
                        this.mMultiStickerMaskFilter = sticker.isCutFaceSticker ? new MultiStickerCutFaceMaskFilter(this.mContext) : new MultiStickerMaskFilter(this.mContext);
                        this.mMultiStickerMaskFilter.setPollGroupNumber(this.mPollGroupNum);
                        this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
                    }
                    if (this.mMultiStickerMaskFilter != null) {
                        if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("native")) {
                            return;
                        }
                        if (this.mMultiStickerMaskFilter.isHaveSameSticker(sticker)) {
                            return;
                        }
                        this.mMultiStickerMaskFilter.addSticker(sticker, new StickerBlendFilter.StickerStateChangeListener(){

                            @Override
                            public void stickerStateChanged(int trigerType, int state) {
                                StickerAdjustFilter.this.updateplayStatus(sticker, trigerType, state);
                                if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                    StickerAdjustFilter.this.stickerStateChangeListener.stickerStateChanged(trigerType, state);
                                }
                            }

                            @Override
                            public void stickerGestureTypeChanged(String trigerType, boolean isDraw) {
                                if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                    StickerAdjustFilter.this.stickerStateChangeListener.stickerGestureTypeChanged(trigerType, isDraw);
                                }
                            }

                            @Override
                            public void faceDetected(boolean hasFace) {
                                if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                    StickerAdjustFilter.this.stickerStateChangeListener.faceDetected(hasFace);
                                }
                            }

                            @Override
                            public void playStateChanged(final int soundId, boolean play) {
                                if (null != StickerAdjustFilter.this.soundPool) {
                                    if (play) {
                                        StickerAdjustFilter.this.setRunableCalledWhenLoaded(soundId, new Runnable(){

                                            @Override
                                            public void run() {
                                                MDLog.d((String)"media", (String)"[SoundPool] Start play sounds !");
                                                int newSoundId = StickerAdjustFilter.this.soundPool.play(soundId, 1.0f, 1.0f, 0, sticker.isLoopSound() ? -1 : 0, 1.0f);
                                                sticker.setPlayingSoundId(newSoundId);
                                            }
                                        });
                                    } else if (sticker.getPlayingSoundId() > 0) {
                                        StickerAdjustFilter.this.soundPool.pause(sticker.getPlayingSoundId());
                                    }
                                }
                                StickerAdjustFilter.this.stickerStateChangeListener.playStateChanged(soundId, play);
                            }

                            @Override
                            public void distortionStateChanged(boolean faceBeauty, float faceValue, float eyeValue, float skinValue, float skinWhitevalue) {
                            }
                        });
                        this.mMultiStickerMaskFilter.setStickerFinishListener(new MultiStickerMaskFilter.StickerFinishListener(){

                            @Override
                            public void stickerRenderFinished(int stickerNum, Sticker removeSticker) {
                                if (StickerAdjustFilter.this.finishListener != null) {
                                    int num = stickerNum + StickerAdjustFilter.this.mStickerFilterMap.size() + Math.round(StickerAdjustFilter.this.mBigEye) + Math.round(StickerAdjustFilter.this.mThinFace);
                                    StickerAdjustFilter.this.finishListener.stickerRenderFinished(num, removeSticker);
                                }
                            }
                        });
                        maskFilter = null;
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type MultiStickerMaskFilter !!!");
                    } else if (sticker.getStickerType().startsWith("weex")) {
                        maskFilter = new WeexStickerMaskFilter(sticker);
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type WeexStickerMaskFilter !!!");
                    } else {
                        maskFilter = sticker.getEtcTextureBatch() != null ? new StickerEtc1MaskFilter(this.mContext, sticker) : new StickerMaskFilter(this.mContext, sticker, sticker.getImageProvider());
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                    }
                }
                if (maskFilter != null) {
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerBlendFilter !!!");
                    StickerBlendFilter stickerBlendFilter = new StickerBlendFilter(maskFilter, sticker);
                    stickerBlendFilter.setSegmentBody(sticker.isClearsBodyArea());
                    stickerBlendFilter.setSegmentStrokeColor(sticker.getStrokeColor());
                    stickerBlendFilter.setSegmentStrokeRadius(sticker.getStrokeRadius());
                    stickerBlendFilter.stickerStateChangeListener = new StickerBlendFilter.StickerStateChangeListener(){

                        @Override
                        public void stickerStateChanged(int trigerType, int state) {
                            StickerAdjustFilter.this.updateplayStatus(sticker, trigerType, state);
                            if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                StickerAdjustFilter.this.stickerStateChangeListener.stickerStateChanged(trigerType, state);
                            }
                        }

                        @Override
                        public void faceDetected(boolean hasFace) {
                            if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                StickerAdjustFilter.this.stickerStateChangeListener.faceDetected(hasFace);
                            }
                        }

                        @Override
                        public void stickerGestureTypeChanged(String trigerType, boolean isDraw) {
                            if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                StickerAdjustFilter.this.stickerStateChangeListener.stickerGestureTypeChanged(trigerType, isDraw);
                            }
                        }

                        @Override
                        public void playStateChanged(final int soundId, boolean play) {
                            if (null != StickerAdjustFilter.this.soundPool) {
                                if (play) {
                                    StickerAdjustFilter.this.setRunableCalledWhenLoaded(soundId, new Runnable(){

                                        @Override
                                        public void run() {
                                            MDLog.d((String)"media", (String)"[SoundPool] Start play sounds !");
                                            int newSoundId = StickerAdjustFilter.this.soundPool.play(soundId, 1.0f, 1.0f, 0, sticker.isLoopSound() ? -1 : 0, 1.0f);
                                            sticker.setPlayingSoundId(newSoundId);
                                        }
                                    });
                                } else if (sticker.getPlayingSoundId() > 0) {
                                    StickerAdjustFilter.this.soundPool.pause(sticker.getPlayingSoundId());
                                }
                            }
                            if (StickerAdjustFilter.this.stickerStateChangeListener != null) {
                                StickerAdjustFilter.this.stickerStateChangeListener.playStateChanged(soundId, play);
                            }
                        }

                        @Override
                        public void distortionStateChanged(boolean faceBeauty, float faceValue, float eyeValue, float skinValue, float skinWhitevalue) {
                        }
                    };
                    this.mStickerFilterMap.put(sticker.getStickerType(), stickerBlendFilter);
                    this.addTerminalBlendFilter(stickerBlendFilter);
                    stickerBlendFilter.sticker = sticker;
                    stickerBlendFilter.mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
                    stickerBlendFilter.setFinishListener(new StickerBlendFilter.StickerMaskFinishListener(){

                        @Override
                        public void stickerRenderFinished() {
                            StickerAdjustFilter.this.removeStickerFilter(sticker);
                        }
                    });
                }
            } else if (null != sticker.getImageFolderPath() && sticker.getImageFolderPath().equals(filter.sticker.getImageFolderPath())) {
                if (sticker.getStickerType().equals("FACE_MASK_TYPE") && sticker.getMask().swapFacialMask) {
                    filter.mStickerDuration = 30000000L;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                } else {
                    filter.mStickerDuration = filter.mStickerDuration - filter.getEscapedTime() + sticker.getDuration();
                }
            } else {
                filter.sticker = sticker;
                filter.resetSticker(sticker);
                filter.mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStickerFilter(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            StickerBlendFilter filter = this.mStickerFilterMap.get(sticker.getStickerType());
            filter.setFinishListener(null);
            if (filter == null) {
                return;
            }
            this.removeStickerBlendFilter(filter);
            this.mStickerFilterMap.remove(sticker.getStickerType());
            this.filtersToDestroy.add((GLRenderer)filter);
            if (null != this.finishListener) {
                int beautyCount = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + beautyCount, sticker);
            }
        }
    }

    private void removeStickerBlendFilter(StickerBlendFilter filter) {
        BasicFilter parentFilter = filter.parentFilter;
        parentFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter((BasicFilter)filter);
            this.registerTerminalFilter(parentFilter);
            parentFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = parentFilter;
        } else {
            this.removeFilter((BasicFilter)filter);
            if (filter.getTargets().get(0) instanceof StickerBlendFilter) {
                StickerBlendFilter targetFilter = (StickerBlendFilter)((Object)filter.getTargets().get(0));
                targetFilter.parentFilter = parentFilter;
                parentFilter.addTarget((GLTextureInputRenderer)targetFilter);
            } else {
                BasicFilter basicFilter = (BasicFilter)filter.getTargets().get(0);
                basicFilter.parentFilter = parentFilter;
                parentFilter.addTarget((GLTextureInputRenderer)basicFilter);
            }
        }
    }

    private void addTerminalFilter(BasicFilter filter) {
        this.mTerminalFilter.removeTarget((GLTextureInputRenderer)this);
        this.mTerminalFilter.addTarget((GLTextureInputRenderer)filter);
        filter.parentFilter = this.mTerminalFilter;
        this.removeTerminalFilter(this.mTerminalFilter);
        this.registerFilter(this.mTerminalFilter);
        this.mTerminalFilter = filter;
        filter.addTarget((GLTextureInputRenderer)this);
        this.registerTerminalFilter(this.mTerminalFilter);
    }

    private void addTerminalMultiStickerFilter(BasicFilter filter) {
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            this.insertSpecifiedPosition(this.mTerminalFilter, filter);
        } else {
            this.addTerminalFilter(filter);
        }
    }

    private void insertSpecifiedPosition(BasicFilter destFilter, BasicFilter filter) {
        BasicFilter parentFilter = destFilter.parentFilter;
        parentFilter.removeTarget((GLTextureInputRenderer)destFilter);
        parentFilter.addTarget((GLTextureInputRenderer)filter);
        this.registerFilter(filter);
        filter.parentFilter = parentFilter;
        destFilter.parentFilter = filter;
        filter.addTarget((GLTextureInputRenderer)destFilter);
    }

    private void addTerminalBlendFilter(StickerBlendFilter blendFilter) {
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            if (this.mMultiStickerMaskFilter != null) {
                this.insertSpecifiedPosition(this.mMultiStickerMaskFilter, (BasicFilter)blendFilter);
            } else {
                this.insertSpecifiedPosition(this.mTerminalFilter, (BasicFilter)blendFilter);
            }
        } else if (this.mTerminalFilter == this.mMultiStickerMaskFilter && blendFilter.segmentFilter != null) {
            this.insertSpecifiedPosition(this.mTerminalFilter, (BasicFilter)blendFilter);
        } else {
            this.addTerminalFilter((BasicFilter)blendFilter);
        }
    }

    private void drawTrackerSticker(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        filter.setDetectParam(param);
    }

    private void drawFixedSticker(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        float scale;
        Sticker sticker = filter.sticker;
        float x = (float)this.getWidth() / 2.0f;
        float y = sticker.isShowTop() ? (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f : (float)this.getHeight() - (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF point1 = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        float scaleWidth = scale = (float)sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        float scaleHeight = scale;
        param.scaleW = scaleWidth;
        param.scaleH = scaleHeight;
        param.centerPoint = point1;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawFullScreenFixed(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        float x = (float)this.getWidth() / 2.0f;
        float y = ((float)this.getHeight() - (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF point1 = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        float scaleWidth = 1.5f;
        float scaleHeight = 1.5f;
        if (filter.sticker.getImageWidth() > 360) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else if (this.getWidth() == 720) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else {
            scaleWidth = 1.5f;
            scaleHeight = 1.5f;
        }
        param.scaleW = scaleWidth;
        param.scaleH = scaleHeight;
        param.centerPoint = point1;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawPositionSetFixed(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        float scale = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        param.scaleH = (float)this.getHeight() / (float)filter.sticker.getImageHeight() * scale;
        param.scaleW = (float)this.getWidth() / (float)filter.sticker.getImageWidth() * scale;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawAbsolutePostion(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        AbsolutePosition absolutePos = filter.sticker.getAbsolutePos();
        float scale = (float)filter.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        if (absolutePos != null && absolutePos.getCenter() != null) {
            float x = (float)this.getWidth() * absolutePos.getCenter().x;
            float y = (float)this.getHeight() * absolutePos.getCenter().y;
            param.centerPoint = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        } else {
            param.centerPoint = new PointF(0.5f, 0.5f);
        }
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawAbsolutePostionUseStcikerDim(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        AbsolutePosition absolutePos = filter.sticker.getAbsolutePos();
        float scale = (float)filter.sticker.getImageWidth() * ((float)this.getHeight() * 1.0f / (float)filter.sticker.getBaseDemensionHeight()) / ((float)this.getWidth() / 2.0f);
        if (absolutePos != null && absolutePos.getCenter() != null) {
            float x = (float)this.getWidth() * absolutePos.getCenter().x;
            float y = (float)this.getHeight() * absolutePos.getCenter().y;
            param.centerPoint = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        } else {
            param.centerPoint = new PointF(0.5f, 0.5f);
        }
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawAbsPostionAdjustResolution(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        float ratio = (float)this.getWidth() > 480.0f ? (float)this.getWidth() / 352.0f : 1.0f;
        float scale = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f) * ratio;
        AbsolutePosition absolutePos = filter.sticker.getAbsolutePos();
        param.centerPoint = absolutePos != null && absolutePos.getCenter() != null ? new PointF(absolutePos.getCenter().x, absolutePos.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawScaleCenterCrop(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        float dWidth = filter.sticker.getImageWidth();
        float dHeight = filter.sticker.getImageHeight();
        float scale = 1.5f;
        scale = dWidth * (float)this.getHeight() > (float)this.getWidth() * dHeight ? (float)this.getHeight() / dHeight : (float)this.getWidth() / dWidth;
        param.scaleW = scale * 2.0f;
        param.scaleH = scale * 2.0f;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        filter.setDetectParam(param);
    }

    private void drawGestureFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        if (filter.sticker.isDonotTrack()) {
            this.drawGestureFixedFilter(filter, param);
        } else {
            this.drawGestureTrackingFilter(filter, param);
        }
    }

    private void drawGestureFixedFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (null == this.mmcvBoxes || this.mmcvBoxes.getDetectResult() == null || this.mmcvBoxes.getDetectResult().length == 0) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.triggerType = filter.sticker.getObjectTriggerType();
        for (MMBox mmBox : this.mmcvBoxes.getDetectResult()) {
            if (mmBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)mmBox.class_name_) || !mmBox.class_name_.equals(param.triggerType)) continue;
            param.gestureRect = new RectF((float)mmBox.x_, (float)mmBox.y_, (float)(mmBox.x_ + mmBox.width_), (float)(mmBox.y_ + mmBox.height_));
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRectForTrigger(PointF center, float angle, float scale, boolean forceUpdate, int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
                faceDetectParam.angle = angle;
                faceDetectParam.centerPoint = new PointF(center.x, center.y);
                faceDetectParam.triggerType = "tracking_rect";
                faceDetectParam.scaleH = 0.5f * scale;
                faceDetectParam.scaleW = 0.5f * scale;
                this.mMultiStickerMaskFilter.setHaniStickerParam(faceDetectParam, haniId);
                return;
            }
        }
    }

    private void drawGestureTrackingFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.isTrackingInit()) {
            return;
        }
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (null == this.mmcvBoxes || null == this.mmcvBoxes.getDetectResult() || this.mmcvBoxes.getDetectResult().length == 0) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.triggerType = filter.sticker.getObjectTriggerType();
        for (MMBox mmBox : this.mmcvBoxes.getDetectResult()) {
            RectF rectF;
            if (mmBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)mmBox.class_name_) || !mmBox.class_name_.equals(param.triggerType)) continue;
            param.gestureRect = rectF = new RectF((float)mmBox.x_, (float)mmBox.y_, (float)(mmBox.x_ + mmBox.width_), (float)(mmBox.y_ + mmBox.height_));
            this.mmcvRect = new MMRect();
            if (filter.sticker.getTrackingRegion() != null) {
                ObjectRegion trackingRegion = filter.sticker.getTrackingRegion();
                RectF regionRect = new RectF(rectF);
                this.mmcvRect.x_ = (int)(regionRect.left + regionRect.width() * trackingRegion.x);
                this.mmcvRect.y_ = (int)(regionRect.top + regionRect.height() * trackingRegion.y);
                this.mmcvRect.width_ = (int)((float)this.mmcvRect.x_ + regionRect.width() * trackingRegion.w);
                this.mmcvRect.height_ = (int)((float)this.mmcvRect.y_ + regionRect.height() * trackingRegion.h);
            } else {
                this.mmcvRect.x_ = (int)rectF.left;
                this.mmcvRect.y_ = (int)rectF.top;
                this.mmcvRect.width_ = (int)(rectF.right - rectF.left);
                this.mmcvRect.height_ = (int)(rectF.bottom - rectF.top);
            }
            if (this.mGestureTrackingFilter != null) {
                this.mGestureTrackingFilter.setMMCVRect(this.mmcvRect);
            }
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            if (this.mGestureTrackingFilter == null) continue;
            this.mGestureTrackingFilter.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (null == mmcvInfo) {
            return;
        }
        this.mCurCVInfo = mmcvInfo;
        Object object = this.getLockObject();
        synchronized (object) {
            Object landmarks68;
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.mStickerFilterMap != null && this.mStickerFilterMap.size() > 0) {
                for (StickerBlendFilter blendFilter : this.mStickerFilterMap.values()) {
                    if (blendFilter.segmentFilter == null) continue;
                    blendFilter.setMMCVInfo(mmcvInfo);
                }
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.expressDetector != null) {
                this.expressDetector.setMMCVInfo(mmcvInfo);
            }
            if (null != this.gestureDetector) {
                this.gestureDetector.setMMCVInfo(mmcvInfo);
            }
            if (this.mGestureTrackingFilter != null) {
                this.mGestureTrackingFilter.setMMCVInfo(mmcvInfo);
            }
            this.processDistortionState();
            boolean hasFace = true;
            int faceIndex = 0;
            if (mmcvInfo.getMaxFaceCnt() <= 0) {
                hasFace = false;
                this.lastFacesCnt = 0;
            } else if (this.multiSwitchEnable) {
                faceIndex = this.calculateFaceIndex(mmcvInfo);
                landmarks68 = mmcvInfo.getFaceAttributeInfo(faceIndex).getLandmarks68();
                this.lastFacePosition.set(landmarks68[0], landmarks68[68]);
                this.lastFacesCnt = mmcvInfo.getMaxFaceCnt();
            }
            this.filterTriggerManager.setTriggerFaceIndex(faceIndex);
            this.filterTriggerManager.adjustStateBy(mmcvInfo);
            if (this.mMultiStickerMaskFilter != null) {
                if (null != this.stickerStateChangeListener) {
                    this.stickerStateChangeListener.faceDetected(hasFace);
                }
                this.mMultiStickerMaskFilter.setMainFaceIndex(faceIndex);
                this.mMultiStickerMaskFilter.setFilterTriggerManager(this.filterTriggerManager);
                this.mMultiStickerMaskFilter.setMmcvBoxes(this.mmcvBoxes);
                this.mMultiStickerMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                landmarks68 = this.face3DMaskFilters.iterator();
                while (landmarks68.hasNext()) {
                    Face3DMaskFilter face3DMaskFilter = (Face3DMaskFilter)((Object)landmarks68.next());
                    if (!face3DMaskFilter.needFaceDetect()) continue;
                    face3DMaskFilter.setMMCVInfo(mmcvInfo);
                }
            }
            if (mmcvInfo.getMaxFaceCnt() == 0) {
                int i = 0;
                for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
                    FaceDetectFilter.FaceDetectParam param = new FaceDetectFilter.FaceDetectParam();
                    if (!TextUtils.isEmpty((CharSequence)filter.sticker.getLayerType()) && filter.sticker.getLayerType().equals("object_follower")) {
                        filter.clearPoints();
                        this.drawGestureFilter(filter, param);
                    } else if (!filter.sticker.isAlwaysShow()) {
                        filter.clearPoints();
                    } else if (filter.sticker.getType() == 1) {
                        filter.clearPoints();
                        this.drawFixedSticker(filter, param);
                    } else if (filter.sticker.getType() == 2) {
                        filter.clearPoints();
                        this.drawFullScreenFixed(filter, param);
                    } else if (filter.sticker.getType() == 3) {
                        filter.clearPoints();
                        this.drawPositionSetFixed(filter, param);
                    } else if (filter.sticker.getType() == 99) {
                        filter.clearPoints();
                        this.drawScaleCenterCrop(filter, param);
                    } else if (filter.sticker.getType() == 5) {
                        filter.clearPoints();
                        this.drawAbsolutePostion(filter, param);
                    } else if (filter.sticker.getType() == 6) {
                        filter.clearPoints();
                        this.drawAbsolutePostionUseStcikerDim(filter, param);
                    } else if (filter.sticker.getType() == 7) {
                        filter.clearPoints();
                        this.drawAbsPostionAdjustResolution(filter, param);
                    }
                    ++i;
                }
                if (null != this.stickerStateChangeListener) {
                    this.stickerStateChangeListener.faceDetected(false);
                }
            } else {
                if (null != this.stickerStateChangeListener) {
                    this.stickerStateChangeListener.faceDetected(true);
                }
                for (int j = mmcvInfo.getMaxFaceCnt() - 1; j >= 0; --j) {
                    for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
                        PointF centerPoint;
                        Sticker sticker = filter.sticker;
                        FaceDetectFilter.FaceDetectParam param = new FaceDetectFilter.FaceDetectParam();
                        param.mmcvBoxes = this.mmcvBoxes;
                        if (!TextUtils.isEmpty((CharSequence)filter.sticker.getLayerType()) && filter.sticker.getLayerType().equals("object_follower")) {
                            filter.clearPoints();
                            this.drawGestureFilter(filter, param);
                            continue;
                        }
                        if (sticker.getType() == 1) {
                            filter.clearPoints();
                            this.drawFixedSticker(filter, param);
                            continue;
                        }
                        if (sticker.getType() == 2) {
                            filter.clearPoints();
                            this.drawFullScreenFixed(filter, param);
                            continue;
                        }
                        if (sticker.getType() == 3) {
                            filter.clearPoints();
                            this.drawPositionSetFixed(filter, param);
                            continue;
                        }
                        if (filter.sticker.getType() == 99) {
                            filter.clearPoints();
                            this.drawScaleCenterCrop(filter, param);
                            continue;
                        }
                        if (filter.sticker.getType() == 5) {
                            filter.clearPoints();
                            this.drawAbsolutePostion(filter, param);
                            continue;
                        }
                        if (filter.sticker.getType() == 6) {
                            filter.clearPoints();
                            this.drawAbsolutePostionUseStcikerDim(filter, param);
                            continue;
                        }
                        if (filter.sticker.getType() == 7) {
                            filter.clearPoints();
                            this.drawAbsPostionAdjustResolution(filter, param);
                            continue;
                        }
                        if (sticker.getType() != 0) continue;
                        filter.clearPoints();
                        FaceAttributeInfo faceInfo = mmcvInfo.getFaceAttributeInfo(j);
                        float[] landmarks682 = faceInfo.getLandmarks68();
                        float x1 = landmarks682[sticker.getFacePositionLeft()];
                        float y1 = landmarks682[sticker.getFacePositionLeft() + 68];
                        float x2 = landmarks682[sticker.getFacePositionRight()];
                        float y2 = landmarks682[sticker.getFacePositionRight() + 68];
                        PointF point1 = new PointF(x1, y1);
                        PointF point2 = new PointF(x2, y2);
                        float angleZDegree = faceInfo.getFaceRotateDegree_2d();
                        PointF tPoint = new PointF((float)sticker.getOffsetX() * this.getAdjustWidthScale(), (float)sticker.getOffsetY() * this.getAdjustWidthScale());
                        this.rotatePoint(tPoint, angleZDegree);
                        if (sticker.hasCenterPoint()) {
                            centerPoint = new PointF(landmarks682[sticker.getCenterIndex()], landmarks682[sticker.getCenterIndex() + 68]);
                        } else if (sticker.getPointIndexes().length == 1) {
                            int pointIndex1 = sticker.getPointIndexes()[0];
                            float pX1 = landmarks682[pointIndex1];
                            float pY1 = landmarks682[pointIndex1 + 68];
                            centerPoint = new PointF(pX1, pY1);
                        } else {
                            int pointIndex1 = sticker.getPointIndexes()[0];
                            int pointIndex2 = sticker.getPointIndexes()[1];
                            float pX1 = landmarks682[pointIndex1];
                            float pY1 = landmarks682[pointIndex1 + 68];
                            float pX2 = landmarks682[pointIndex2];
                            float pY2 = landmarks682[pointIndex2 + 68];
                            centerPoint = this.getCenterPoint(new PointF(pX1, pY1), new PointF(pX2, pY2));
                        }
                        float distance = (float)this.getmDistancePoint(point1, point2);
                        float scale = distance / 180.0f / this.getAdjustWidthScale();
                        float defaultDrawWidth = this.getWidth() / 2;
                        float imageScale = (float)sticker.getImageWidth() * this.getAdjustWidthScale() / defaultDrawWidth;
                        scale *= imageScale;
                        centerPoint.x += tPoint.x * (distance / 180.0f) / this.getAdjustWidthScale();
                        centerPoint.y += tPoint.y * (distance / 180.0f) / this.getAdjustWidthScale();
                        PointF pointF = new PointF(centerPoint.x / (float)this.getWidth(), centerPoint.y / (float)this.getHeight());
                        param.scaleW = scale;
                        param.scaleH = scale;
                        if (sticker.isComic()) {
                            param.centerPoint = pointF;
                            param.angle = angleZDegree <= 90.0f && angleZDegree >= 0.0f || angleZDegree >= 270.0f && angleZDegree <= 360.0f ? 0.0f : 180.0f;
                        } else {
                            param.centerPoint = pointF;
                            param.angle = angleZDegree;
                        }
                        param.points68 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
                        param.points96 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks96();
                        param.points104 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks104();
                        param.warpedPoints104 = mmcvInfo.getFaceAttributeInfo(0).getWarpedLandmarks104();
                        param.filterTrigerManager = this.filterTriggerManager;
                        param.euler_angles = mmcvInfo.getFaceAttributeInfo(0).getEulerAngles();
                        filter.setDetectParam(param);
                    }
                }
            }
        }
    }

    private void processDistortionState() {
        if (this.mDistorationMask != null) {
            if (!this.mFaceStateChange && this.mmcvBoxes != null) {
                for (MMBox mmBox : this.mmcvBoxes.getDetectResult()) {
                    if (!mmBox.class_name_.equals(this.mDistorationMask.getHidingObjectTriggerType())) continue;
                    this.mFaceStateChange = true;
                }
            }
            if (this.mFaceStateChange) {
                if (this.mDistorationMask.getStrengthStep() == 0.0f && this.mDistorationMask.getStrengthStepB() == 0.0f) {
                    this.mFaceBeauty = true;
                } else if (!this.mFaceBeauty) {
                    if (this.mFaceThinValue > 0.0f) {
                        this.mFaceThinValue -= this.mDistorationMask.getStrengthStep();
                    }
                    if (this.mBigEyeValue > 0.0f) {
                        this.mBigEyeValue -= this.mDistorationMask.getStrengthStepB();
                    }
                    if (this.mFaceThinValue <= 0.0f && this.mBigEyeValue <= 0.0f) {
                        this.mFaceBeauty = true;
                    }
                }
                if (this.mFaceBeauty && !this.mFaceBeautyHaveFinish) {
                    this.mFaceThinValue = this.mDistorationMask.getStrengthStep() == 0.0f ? this.mBeautyFace.getThinFaceValue() : (this.mFaceThinValue += this.mDistorationMask.getStrengthStep());
                    this.mBigEyeValue = this.mDistorationMask.getStrengthStepB() == 0.0f ? this.mBeautyFace.getBigEyeValue() : (this.mBigEyeValue += this.mDistorationMask.getStrengthStepB());
                    if (this.mFaceThinValue >= this.mBeautyFace.getThinFaceValue() && this.mBigEyeValue >= this.mBeautyFace.getBigEyeValue()) {
                        this.stickerStateChangeListener.distortionStateChanged(true, this.mBeautyFace.getThinFaceValue(), this.mBeautyFace.getBigEyeValue(), this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                        this.mFaceBeautyHaveFinish = true;
                    } else {
                        this.stickerStateChangeListener.distortionStateChanged(true, this.mFaceThinValue, this.mBigEyeValue, this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                    }
                } else {
                    this.stickerStateChangeListener.distortionStateChanged(false, this.mFaceThinValue, this.mBigEyeValue, 0.0f, 0.0f);
                }
            }
        }
    }

    public synchronized void destroy() {
        for (StickerBlendFilter blendFilter : this.mStickerFilterMap.values()) {
            blendFilter.cancelDraw();
            blendFilter.destroy();
        }
        if (this.mEffectGroupFilter != null) {
            this.mEffectGroupFilter.destroy();
        }
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.destroy();
        }
        super.destroy();
        if (null != this.mNormalFilter) {
            this.mNormalFilter.destroy();
        }
        if (null != this.gestureDetector) {
            this.gestureDetector.cancel();
        }
        this.gestureDetectorListener = null;
        this.stopExpressDetect();
        FacerigHelper.release();
        BodyLandHelper.release();
        SegmentHelper.release();
        FacerigHelper.releseFaceRigInfo();
        this.releaseSoundPlayer();
        if (this.mFaceMaskFilter != null) {
            this.mFaceMaskFilter.destroy();
        }
        if (this.mSwapFacialMaskSticker != null) {
            this.mSwapFacialMaskSticker.clear();
            this.mSwapFacialMaskSticker = null;
        }
        if (this.mLookupFilter != null) {
            this.mLookupFilter.destroy();
            this.mLookupFilter = null;
        }
        if (this.filtersToDestroy != null && this.filtersToDestroy.size() > 0) {
            for (GLRenderer glRenderer : this.filtersToDestroy) {
                glRenderer.destroy();
            }
        }
        SharedExecutor.getInstance().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.scaleWidth == 0) {
                this.scaleWidth = this.getWidth();
                this.scaleWidthRatio = 1.0f;
            } else if (this.getWidth() > 0) {
                this.scaleWidthRatio = (float)this.scaleWidth * 1.0f / (float)this.getWidth();
            }
            if (this.scaleHeight == 0) {
                this.scaleHeight = this.getHeight();
                this.scaleHeightRatio = 1.0f;
            } else if (this.getHeight() > 0) {
                this.scaleHeightRatio = (float)this.scaleHeight * 1.0f / (float)this.getHeight();
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.setScaleWidthRatio(this.scaleWidthRatio);
                this.mMultiStickerMaskFilter.setScaleHeightRatio(this.scaleHeightRatio);
            }
            if (this.enableSelfRender) {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                this.setTimeStamp(System.currentTimeMillis() - this.startTime);
            }
            for (GLRenderer renderer : this.filtersToDestroy) {
                renderer.destroy();
            }
            this.filtersToDestroy.clear();
            super.newTextureReady(texture, source, newData);
        }
    }

    public void setTimeStamp(long ms) {
        for (StickerBlendFilter blendFilter : this.mStickerFilterMap.values()) {
            blendFilter.setTimeStamp(ms);
        }
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.setTimeStamp(ms);
        }
        if (this.enableSelfRender) {
            this.setMMCVInfo(new MMCVInfo());
        }
        if (this.mEffectGroupFilter != null) {
            if (this.mLastRenderTime == 0L) {
                this.mLastRenderTime = System.currentTimeMillis();
            }
            this.mEffectGroupFilter.setTimeStamp(ms - this.mLastRenderTime);
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() * 1.0f / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSticker(String stickerType) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.removeSticker(stickerType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskWithModelType(int modelType) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
                if (filter.sticker.getModelType() != modelType) continue;
                filter.setFinishListener(null);
                if (filter == null) {
                    return;
                }
                this.removeStickerBlendFilter(filter);
                this.filtersToDestroy.add((GLRenderer)filter);
                if (null != this.finishListener) {
                    int beautyCount = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                    Sticker sticker = filter.sticker;
                    this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + beautyCount, sticker);
                }
                this.mStickerFilterMap.remove(filter.sticker.getStickerType());
                if (!(filter.stickerMaskFilter instanceof Face3DMaskFilter) || this.face3DMaskFilters == null) continue;
                this.face3DMaskFilters.remove((Object)filter.stickerMaskFilter);
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.clearMaskWithModelType(modelType);
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.clearWithModelType(modelType);
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskFilters() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
                filter.setFinishListener(null);
                if (filter == null) {
                    return;
                }
                this.removeStickerBlendFilter(filter);
                this.filtersToDestroy.add((GLRenderer)filter);
                if (null == this.finishListener) continue;
                int beautyCount = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                Sticker sticker = filter.sticker;
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + beautyCount, sticker);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                this.face3DMaskFilters.clear();
                this.face3DMaskFilters = null;
            }
            if (BodyLandHelper.isUseBodyLand()) {
                BodyLandHelper.setUseBodyLand((boolean)false);
            }
            if (this.mMultiStickerMaskFilter != null) {
                BasicFilter parentFilter = this.mMultiStickerMaskFilter.parentFilter;
                parentFilter.removeTarget((GLTextureInputRenderer)this.mMultiStickerMaskFilter);
                if (this.mTerminalFilter == this.mMultiStickerMaskFilter) {
                    this.removeTerminalFilter(this.mMultiStickerMaskFilter);
                    this.registerTerminalFilter(parentFilter);
                    parentFilter.addTarget((GLTextureInputRenderer)this);
                    this.mTerminalFilter = parentFilter;
                } else {
                    this.removeFilter(this.mMultiStickerMaskFilter);
                    BasicFilter targetFilter = (BasicFilter)this.mMultiStickerMaskFilter.getTargets().get(0);
                    targetFilter.parentFilter = parentFilter;
                    parentFilter.addTarget((GLTextureInputRenderer)targetFilter);
                }
                this.filtersToDestroy.add((GLRenderer)this.mMultiStickerMaskFilter);
                this.mMultiStickerMaskFilter = null;
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.clearAll();
            }
            if (this.mFaceMaskFilter != null) {
                this.filtersToDestroy.add((GLRenderer)this.mFaceMaskFilter);
                this.mFaceMaskFilter = null;
            }
            if (this.mSwapFacialMaskSticker != null) {
                this.mSwapFacialMaskSticker.clear();
                this.mSwapFacialMaskSticker = null;
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
            this.releaseSoundPlayer();
            SegmentHelper.release();
            FacerigHelper.releseFaceRigInfo();
            this.mStickerFilterMap.clear();
        }
    }

    private void removeEffectFilter(BasicFilter filter) {
        BasicFilter parentFilter = filter.parentFilter;
        parentFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter(filter);
            this.registerTerminalFilter(parentFilter);
            parentFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = parentFilter;
        } else {
            this.removeFilter(filter);
            BasicFilter basicFilter = (BasicFilter)filter.getTargets().get(0);
            filter.removeTarget((GLTextureInputRenderer)basicFilter);
            basicFilter.parentFilter = parentFilter;
            parentFilter.addTarget((GLTextureInputRenderer)basicFilter);
        }
    }

    public void releaseSoundPlayer() {
        this.clearAllSoundPoolInfo();
        if (null != this.soundPool) {
            if (this.soundIds != null && this.soundIds.size() > 0) {
                for (Integer soundId : this.soundIds) {
                    this.soundPool.unload(soundId.intValue());
                }
                this.soundIds.clear();
            }
            this.soundPool.release();
        }
        if (null != this.soundPlayer) {
            this.soundPlayer.release();
            this.soundPlayer = null;
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
    }

    public int getTextOutID() {
        BasicFilter terminalFilter = (BasicFilter)this.getTerminalFilters().get(0);
        if (terminalFilter != null) {
            return terminalFilter.getTextOutID();
        }
        return 0;
    }

    public void lockTexture() {
        for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
            filter.lockTexture();
        }
    }

    public void unlockTexture() {
        for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
            filter.unlockTexture();
        }
    }

    public void setScaleWidth(int scaleWidth) {
        this.scaleWidth = scaleWidth;
    }

    public void setScaleHeight(int scaleHeight) {
        this.scaleHeight = scaleHeight;
    }

    public void setGameScoreListener(GameScoreListener listener) {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).setGameScoreListener(listener);
        }
    }

    public void startPlayingTailMoving() {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            MultiStickerGameMaskFilter gameMaskFilter = (MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter;
            gameMaskFilter.playingTailMoving();
        }
    }

    private boolean isBitmapValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    public void initGameFixSticker(Bitmap scoreBitmap, Bitmap iconBitmap, int width, int height) {
        if (this.isBitmapValid(scoreBitmap) && this.isBitmapValid(iconBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).initGameFixStickerItem(scoreBitmap, iconBitmap, width, height);
        }
    }

    public void updateGameFixStickerScore(Bitmap scoreBitmap) {
        if (this.isBitmapValid(scoreBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).updateGameFixStickerScore(scoreBitmap);
        }
    }

    public void setGameStickerDownVelocity(float downVelocity) {
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.setDownVelocity(downVelocity);
        }
    }

    public void setIsUseStickerOptimization(boolean isUsePlus) {
    }

    public void setGestureDetectedListener(GestureDetectedListener listener) {
        this.gestureDetectedListener = listener;
    }

    public void pauseRender() {
        for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
            filter.pauseBitmapCache();
        }
    }

    public void resumeRender() {
        for (StickerBlendFilter filter : this.mStickerFilterMap.values()) {
            filter.resumeBitmapCache();
        }
    }

    protected void initFBO() {
        super.initFBO();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            boolean isProcess = false;
            return isProcess;
        }
        return false;
    }

    private int calculateFaceIndex(MMCVInfo mmcvInfo) {
        int faceCount = mmcvInfo.getMaxFaceCnt();
        if (faceCount == 1) {
            return 0;
        }
        boolean useY = false;
        int cameraDegree = mmcvInfo.cameraDegree;
        if (cameraDegree / 90 % 2 == 0) {
            useY = true;
        }
        if (faceCount >= this.lastFacesCnt) {
            float minDistance = 10000.0f;
            int index = 0;
            for (int i = 0; i < faceCount; ++i) {
                float[] landmarks68 = mmcvInfo.getFaceAttributeInfo(i).getLandmarks68();
                PointF faceLeft = new PointF(landmarks68[0], landmarks68[68]);
                float distance = (float)PointHelper.getmDistancePoint(faceLeft, this.lastFacePosition);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                index = i;
            }
            return index;
        }
        float[] landmarks68 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
        float minValue = useY ? landmarks68[68] : landmarks68[0];
        int minXindex = 0;
        float minDistance = 10000.0f;
        int index = -1;
        for (int i = 0; i < faceCount; ++i) {
            PointF faceLeft;
            float distance;
            landmarks68 = mmcvInfo.getFaceAttributeInfo(i).getLandmarks68();
            if (!useY && landmarks68[0] < minValue || useY && landmarks68[68] < minValue) {
                minValue = useY ? landmarks68[68] : landmarks68[0];
                minXindex = i;
            }
            if (!useY && landmarks68[0] <= this.lastFacePosition.x || useY && landmarks68[68] < this.lastFacePosition.y || !((distance = (float)PointHelper.getmDistancePoint(faceLeft = new PointF(landmarks68[0], landmarks68[68]), this.lastFacePosition)) < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        if (index != -1) {
            return index;
        }
        return minXindex;
    }

    public void setplayStatusListener(MStickerActions.onPlayStatusListener listener) {
        this.playStatusListener = listener;
    }

    private void updateplayStatus(Sticker sticker, int triggerType, int state) {
        if (this.playStatusListener != null && triggerType == sticker.getTriggerType() && sticker.getTriggerPlayStatus() != -1) {
            boolean needTrigger = false;
            switch (triggerType) {
                case 1: {
                    if (state != 0) break;
                    needTrigger = true;
                    break;
                }
                default: {
                    needTrigger = false;
                }
            }
            if (!this.isplayStatusTriggered && needTrigger) {
                this.isplayStatusTriggered = true;
                this.playStatusListener.onPlayStatusChanged(sticker.getTriggerPlayStatus());
            }
            if (this.isplayStatusTriggered && sticker.curIndex == sticker.getLoopStart()) {
                this.isplayStatusTriggered = false;
                this.playStatusListener.onPlayStatusChanged(-1);
            }
        }
    }

    public void updateFrameInfo(Frame frame, Session session) {
        ArCoreHelper.getInstance().setArCoreInfo(frame, session);
        if (this.mArCoreFrameListener != null) {
            this.mArCoreFrameListener.getARCoreFrame(frame);
        }
        ArCoreHelper.getInstance().getPlaneTrackInfo();
    }

    public void setCapture3DImageListener(Capture3DImageListener capture3DImageListener) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                face3DMaskFilter.setCapture3DImageListener(capture3DImageListener);
            }
        }
    }

    public void setCapture3DRenderImage(boolean isCapture, Rect rect) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                face3DMaskFilter.setCapture(isCapture, rect);
            }
        }
    }

    public List<Size> getViewPortSize() {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                sizes.add(face3DMaskFilter.getViewPortSize());
            }
        }
        return sizes;
    }

    public void setARCoreFrameListener(ARCoreFrameListener arCoreFrameListener) {
        this.mArCoreFrameListener = arCoreFrameListener;
    }

    public void setIntensity(float intensity) {
        if (this.mLookupFilter instanceof SingleLineGroupFilter) {
            this.mLookupFilter.setIntensity(intensity);
        }
    }

    public void setEffectTimeInfoByHaniId(EffectTimeBean time, int haniId) {
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.setEffectTimeInfoByHaniId(time, haniId);
        }
    }

    public static interface GestureDetectedListener {
        public void gestureDetected(String var1);

        public void onPreGestureAdded(String var1);
    }

    public static interface StickerMaskFinishListener {
        public void stickerRenderFinished(int var1, Sticker var2);
    }

    private class SoundPoolInfo {
        int soundId = 0;
        boolean isLoaded = false;
        Runnable runnable = null;

        SoundPoolInfo() {
        }
    }
}

