/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.os.SystemClock;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.SegmentHelper;
import com.core.glcore.util.TextureHelper;
import com.cosmos.mdlog.MDLog;
import com.immomo.baseutil.MediaStatisticModel;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class SegmentFilter
extends FaceDetectFilter {
    private static final String UNIFORM_TEXTURE_ALPHA = "inputImageTexture2";
    protected MMCVInfo mmcvInfo;
    protected int alphaTexture = 0;
    protected int alphaHandler;
    protected MMFrameInfo mmcvFrame = new MMFrameInfo();
    protected MMParamsInfo params = new MMParamsInfo(4);

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mmcvInfo = mmcvInfo;
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        super.newTextureReady(texture, (GLTextureOutputRenderer)this, newData);
    }

    public void drawSub() {
        super.drawSub();
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture2;\nvarying vec2 textureCoordinate;\nvoid main(){\n   vec4 colorAlpha = texture2D(inputImageTexture2, vec2(textureCoordinate.x, 1.0 - textureCoordinate.y));\n   gl_FragColor = colorAlpha;\n}\n";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.alphaHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXTURE_ALPHA);
    }

    protected void passShaderValues() {
        super.passShaderValues();
        this.processSegment(this.getWidth(), this.getHeight());
    }

    protected void processSegment(int width, int height) {
        if (this.mmcvInfo == null || this.mmcvInfo.frameData == null) {
            MDLog.e((String)"lclc", (String)"mmcv is null or mmcv.frameInfo is null");
            return;
        }
        if (this.mmcvInfo.isVideoMode()) {
            this.mmcvFrame.setFormat(17);
        } else {
            this.mmcvFrame.setFormat(4);
            this.params.setSegmentParamsType(false);
        }
        this.mmcvFrame.setDataPtr(this.mmcvInfo.frameData);
        this.mmcvFrame.setDataLen(this.mmcvInfo.frameData.length);
        this.mmcvFrame.setWidth(this.mmcvInfo.getWidth());
        this.mmcvFrame.setHeight(this.mmcvInfo.getHeight());
        this.mmcvFrame.setStep_(this.mmcvInfo.getWidth());
        this.params.setFlipedShow(SegmentHelper.isFrontCamera());
        this.params.setRotateDegree(SegmentHelper.getRotateDegree());
        this.params.setRestoreDegree(SegmentHelper.getRestoreDegree());
        long start = SystemClock.elapsedRealtime();
        byte[] buffer = SegmentHelper.process((MMFrameInfo)this.mmcvFrame, (MMParamsInfo)this.params, (!this.mmcvInfo.isVideoMode() ? 1 : 0) != 0);
        long detectUse = SystemClock.elapsedRealtime() - start;
        MediaStatisticModel.getInstance().setImageDetect(detectUse);
        GLES20.glActiveTexture((int)33987);
        if (this.alphaTexture == 0) {
            this.alphaTexture = TextureHelper.byteToLuminanceTexture((byte[])buffer, (int)width, (int)height);
        } else {
            TextureHelper.byteToLuminanceTextureBytextureId((int)this.alphaTexture, (byte[])buffer, (int)width, (int)height);
        }
        GLES20.glUniform1i((int)this.alphaHandler, (int)3);
    }

    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.alphaTexture != 0) {
            int[] textures = new int[]{this.alphaTexture};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.alphaTexture = 0;
        }
    }

    public void destroy() {
        if (this.alphaTexture != 0) {
            int[] textures = new int[]{this.alphaTexture};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.alphaTexture = 0;
        }
        super.destroy();
    }
}

