/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerDelegateItem;
import com.momo.mcamera.mask.StickerETC1Item;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerHaniItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.util.PointHelper;
import com.momocv.MMBox;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.EffectTimeBean;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class MultiStickerMaskFilter
extends BasicFilter
implements IVideoTrackTime,
FaceDetectInterface {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_3 = "position3";
    public static final String UNIFORM_ETC1FLAG = "etc1Flag";
    public static final String UNIFORM_PREMULTI = "isPreMulti";
    protected static final long DEFAULT_DURATION = 30000000L;
    protected List<StickerItem> stickerItemList;
    protected List<List<StickerItem>> mPollTriggerStickerItemList;
    protected List<StickerItem> stickerItemDestroyList;
    protected final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    protected static final int COORDS_PER_VERTEX = 2;
    protected final int vertexStride = 8;
    protected int decorateHandler;
    private int mVPMatrixHandler;
    private int mETC1Handler;
    protected int positionHandle3;
    private int isPreMultiHandle;
    public ShortBuffer drawListBuffer;
    private boolean lockTexture = false;
    protected final float[] mProjectionMatrix = new float[16];
    FilterTriggerManager filterTriggerManager;
    float scaleWidthRatio = 1.0f;
    float scaleHeightRatio = 1.0f;
    public static final int POINTS_LENGTH = 68;
    private MMCVBoxes mmcvBoxes;
    public StickerFinishListener finishListener;
    protected FloatBuffer vertexBufer;
    protected float[] textureCoord;
    protected Context context;
    private boolean isPreMultiMode = false;
    protected int faceIndex = 0;
    private boolean projectionInit = false;
    protected long lastStickerTime = 0L;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   inputTextureCoordinate ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nvoid main() {  gl_Position = position;  vec2 coord = inputTextureCoordinate.xy;  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture0;uniform float etc1Flag;\nuniform int isPreMulti;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\nif(etc1Flag > 0.5){\n   color1.a  = texture2D(inputImageTexture0,textureCoordinate1).r;\n}else{\n   if(isPreMulti == 1){\n       if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}   }\n}\n   gl_FragColor = color1; }";
    private List<StickerItem> mCurrentStickerItem = null;
    private int mIndex = 0;
    private boolean mLastMmcvBoxIsEmpty = true;
    private int mNoBoxCount = 0;
    private long mCurrentTime = 0L;

    public MultiStickerMaskFilter(Context context) {
        this.context = context;
        this.stickerItemList = new ArrayList<StickerItem>();
        this.stickerItemDestroyList = new ArrayList<StickerItem>();
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.drawListBuffer = dlb.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
    }

    public void setPollGroupNumber(int number) {
        this.mPollTriggerStickerItemList = new ArrayList<List<StickerItem>>();
        for (int i = 0; i < number; ++i) {
            this.mPollTriggerStickerItemList.add(new ArrayList());
        }
    }

    public void addSticker(final StickerItem item) {
        if (item != null) {
            item.setProjectionMatrix(this.mProjectionMatrix);
            item.setFinishListener(new StickerBlendFilter.StickerMaskFinishListener(){

                @Override
                public void stickerRenderFinished() {
                    MultiStickerMaskFilter.this.removeStickerItem(item);
                    if (MultiStickerMaskFilter.this.finishListener != null) {
                        int num = MultiStickerMaskFilter.this.stickerItemList.size() - MultiStickerMaskFilter.this.stickerItemDestroyList.size();
                        MultiStickerMaskFilter.this.finishListener.stickerRenderFinished(num > 0 ? num : 0, item.sticker);
                    }
                }
            });
            if (item.sticker.getPollTrigger()) {
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    this.mPollTriggerStickerItemList.get(item.sticker.getGroupNum()).add(item);
                }
            } else {
                this.stickerItemList.add(item);
            }
        }
    }

    public void addSticker(Sticker sticker, StickerBlendFilter.StickerStateChangeListener listener) {
        StickerItem item = null;
        if (sticker != null) {
            item = sticker.getEtcTextureBatch() != null ? new StickerETC1Item(sticker, this.context) : (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().startsWith("weex") ? new StickerDelegateItem(sticker, this.context) : (sticker.isGameSticker ? new StickerGameItem(sticker, this.context) : ("STICKER_TYPE_GAME_FIX_TYPE".equals(sticker.getStickerType()) ? new StickerFixItem(sticker, this.context) : (sticker.isHaniSticker ? new StickerHaniItem(sticker, this.context) : new StickerItem(sticker, this.context)))));
            item.setStickerStateChangeListener(listener);
            item.mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
            this.addSticker(item);
        }
    }

    protected void passStickerShaderValues(StickerItem item, float[] mvpMatrix) {
        if (item.fvertexBuffer == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
            bb.order(ByteOrder.nativeOrder());
            item.fvertexBuffer = bb.asFloatBuffer();
        }
        item.fvertexBuffer.position(0);
        item.fvertexBuffer.put(mvpMatrix);
        item.fvertexBuffer.position(0);
        if (item instanceof StickerETC1Item) {
            this.setUseETC1(true);
        } else {
            this.setUseETC1(false);
        }
        GLES20.glUniform1i((int)this.isPreMultiHandle, (int)(this.isPreMultiMode ? 1 : 0));
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.vertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.vertexBuffer2);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle3);
        GLES20.glActiveTexture((int)33984);
        if (item instanceof StickerETC1Item) {
            GLES20.glBindTexture((int)3553, (int)((StickerETC1Item)item).etc1_texture_sticker);
        } else {
            GLES20.glBindTexture((int)3553, (int)item.texture_sticker);
        }
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    public void drawStick(float aspectRatio) {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)aspectRatio);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        this.disableDrawArray();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle3);
    }

    public void drawBackgroundImage() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)1.0f);
        this.setUseETC1(false);
        if (this.textureCoord == null) {
            this.textureCoord = new float[8];
        }
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(this.textureCoord);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(this.textureCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        for (int i = 0; i < 8; ++i) {
            this.textureCoord[i] = this.textureCoord[i] * -1.0f + 0.5f;
        }
        this.vertexBufer.position(0);
        this.vertexBufer.put(this.textureCoord);
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle3);
    }

    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.drawBackgroundImage();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (this.stickerItemDestroyList.size() > 0) {
            ArrayList<StickerItem> destroyList = new ArrayList<StickerItem>(this.stickerItemDestroyList);
            for (StickerItem stickerItem : destroyList) {
                stickerItem.destroy();
                this.stickerItemDestroyList.remove(stickerItem);
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                        if (!pollTriggerItemList.contains(stickerItem)) continue;
                        pollTriggerItemList.remove(stickerItem);
                    }
                }
                this.stickerItemList.remove(stickerItem);
            }
            destroyList.clear();
        }
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemList) {
                this.drawSubStickerItemByAll(stickerItem);
            }
        }
        if (this.mCurrentStickerItem != null && this.mCurrentStickerItem.size() > 0) {
            for (StickerItem stickerItem : this.mCurrentStickerItem) {
                this.drawSubStickerItemByAll(stickerItem);
            }
        }
        GLES20.glDisable((int)3042);
    }

    private void drawSubStickerItemByAll(StickerItem stickerItem) {
        if (stickerItem.getEffectTimeBean() != null && stickerItem.sticker.isHaniSticker) {
            if (this.mCurrentTime >= stickerItem.getEffectTimeBean().mStartTime && this.mCurrentTime <= stickerItem.getEffectTimeBean().mEndTime) {
                this.drawSubStickerItem(stickerItem);
            }
        } else {
            this.drawSubStickerItem(stickerItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSubStickerItem(StickerItem stickerItem) {
        Object object = stickerItem.getLockObject();
        synchronized (object) {
            boolean isETC1Sticker = false;
            stickerItem.imageWidth = this.getWidth();
            stickerItem.imageHeight = this.getHeight();
            if (stickerItem.mvpLists != null && stickerItem.mvpLists.size() > 0 && stickerItem.isDraw) {
                if (stickerItem instanceof StickerETC1Item) {
                    StickerETC1Item item = (StickerETC1Item)stickerItem;
                    isETC1Sticker = true;
                    if (item.etc1_texture_sticker == 0) {
                        item.etc1_texture_sticker = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)item.texture);
                    }
                    item.updateETC1Coordinate();
                } else {
                    MMFrameInfo bitmap = stickerItem.getMmcvImage(this.context);
                    if (null != bitmap && bitmap.getDataPtr() != null) {
                        stickerItem.texture_sticker = stickerItem.texture_sticker == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)bitmap) : TextureHelper.loadDataToTexture((int)stickerItem.texture_sticker, (MMFrameInfo)bitmap);
                    } else {
                        Bitmap curBitmap = stickerItem.getBitmap();
                        if (curBitmap != null && !curBitmap.isRecycled()) {
                            if (stickerItem.texture_sticker > 0) {
                                TextureHelper.updateBitmap((Bitmap)curBitmap, (int)stickerItem.texture_sticker);
                            } else {
                                stickerItem.texture_sticker = TextureHelper.bitmapToTexture((Bitmap)curBitmap);
                            }
                        }
                    }
                }
            } else if (stickerItem.sticker.getLoopStart() <= 0 || !stickerItem.sticker.isAlwaysShow()) {
                stickerItem.sticker.curIndex = 0;
            }
            if (stickerItem.isDraw && (stickerItem.texture_sticker != 0 || isETC1Sticker)) {
                this.isPreMultiMode = stickerItem.sticker.isPreMultiAlpha();
                for (float[] mvpMatrix : stickerItem.mvpLists) {
                    this.passStickerShaderValues(stickerItem, mvpMatrix);
                    this.drawStick(stickerItem.getStickerAspectRatio());
                }
                stickerItem.clearPoints();
            }
        }
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle3 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_3);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
        this.mETC1Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ETC1FLAG);
        this.isPreMultiHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_PREMULTI);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = texture;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            float ratio = (float)this.getWidth() / (float)this.getHeight();
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / ratio), (float)(1.0f / ratio), (float)3.0f, (float)7.0f);
            this.projectionInit = true;
        }
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   inputTextureCoordinate ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nvoid main() {  gl_Position = position;  vec2 coord = inputTextureCoordinate.xy;  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture0;uniform float etc1Flag;\nuniform int isPreMulti;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\nif(etc1Flag > 0.5){\n   color1.a  = texture2D(inputImageTexture0,textureCoordinate1).r;\n}else{\n   if(isPreMulti == 1){\n       if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}   }\n}\n   gl_FragColor = color1; }";
    }

    public void destroy() {
        super.destroy();
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemList) {
                stickerItem.destroy();
            }
            this.stickerItemList.clear();
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List list : this.mPollTriggerStickerItemList) {
                for (StickerItem item : list) {
                    item.destroy();
                }
                list.clear();
            }
            this.mPollTriggerStickerItemList.clear();
        }
        if (this.stickerItemDestroyList != null && this.stickerItemDestroyList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemDestroyList) {
                stickerItem.destroy();
            }
            this.stickerItemDestroyList.clear();
        }
    }

    public void setTimeStamp(long ms) {
        this.mCurrentTime = ms;
        for (StickerItem stickerItem : this.stickerItemList) {
            stickerItem.setRenderTime(ms);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List list : this.mPollTriggerStickerItemList) {
                for (StickerItem item : list) {
                    item.setRenderTime(ms);
                }
            }
        }
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.lastStickerTime = System.currentTimeMillis();
        if (!this.projectionInit && this.getWidth() > 0 && this.getHeight() > 0) {
            float ratio = (float)this.getWidth() / (float)this.getHeight();
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / ratio), (float)(1.0f / ratio), (float)3.0f, (float)7.0f);
            this.projectionInit = true;
        }
        if (mmcvInfo.getMaxFaceCnt() <= 0) {
            this.updateFaceInfo(mmcvInfo, 0.0f, null, false);
        } else if (this.faceIndex != 0 && this.faceIndex < mmcvInfo.getMaxFaceCnt()) {
            float degree = mmcvInfo.getFaceAttributeInfo(this.faceIndex).getFaceRotateDegree_2d();
            float[] landmarks68 = mmcvInfo.getFaceAttributeInfo(this.faceIndex).getLandmarks68();
            this.updateFaceInfo(mmcvInfo, degree, landmarks68, true);
        } else {
            for (int j = mmcvInfo.getMaxFaceCnt() - 1; j >= 0; --j) {
                float degree = mmcvInfo.getFaceAttributeInfo(j).getFaceRotateDegree_2d();
                float[] landmarks68 = mmcvInfo.getFaceAttributeInfo(j).getLandmarks68();
                this.updateFaceInfo(mmcvInfo, degree, landmarks68, true);
            }
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() * 1.0f / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    public void setFilterTriggerManager(FilterTriggerManager filterTriggerManager) {
        this.filterTriggerManager = filterTriggerManager;
    }

    public void setMmcvBoxes(MMCVBoxes mmcvBoxes) {
        this.mmcvBoxes = mmcvBoxes;
        if (this.mmcvBoxes != null && this.mCurrentStickerItem == null && this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0 && this.mmcvBoxes.getDetectResult()[0].class_name_.equals(this.mPollTriggerStickerItemList.get((int)0).get((int)0).sticker.getObjectTriggerType())) {
            this.mCurrentStickerItem = this.mPollTriggerStickerItemList.get(this.mIndex);
            this.mLastMmcvBoxIsEmpty = false;
        } else if (mmcvBoxes != null && this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0 && this.mmcvBoxes.getDetectResult().length > 0 && this.mmcvBoxes.getDetectResult()[0].class_name_.equals(this.mPollTriggerStickerItemList.get((int)0).get((int)0).sticker.getObjectTriggerType())) {
            if (this.mLastMmcvBoxIsEmpty) {
                ++this.mIndex;
                this.mCurrentStickerItem = this.mPollTriggerStickerItemList.get(this.mIndex % this.mPollTriggerStickerItemList.size());
            }
            this.mLastMmcvBoxIsEmpty = false;
        } else {
            if (this.mNoBoxCount == 3) {
                this.mLastMmcvBoxIsEmpty = true;
                this.mNoBoxCount = 0;
            }
            ++this.mNoBoxCount;
        }
    }

    public void updateFaceInfo(MMCVInfo info, float angle, float[] facePos, boolean hasFace) {
        for (StickerItem stickerItem : this.stickerItemList) {
            this.updateFaceInfoBySingleItem(info, angle, facePos, hasFace, stickerItem);
        }
        if (this.mPollTriggerStickerItemList != null && this.mCurrentStickerItem != null) {
            for (StickerItem stickerItem : this.mCurrentStickerItem) {
                this.updateFaceInfoBySingleItem(info, angle, facePos, hasFace, stickerItem);
            }
        }
    }

    private void updateFaceInfoBySingleItem(MMCVInfo info, float angle, float[] facePos, boolean hasFace, StickerItem stickerItem) {
        stickerItem.setCurrentTime(this.lastStickerTime);
        Sticker sticker = stickerItem.sticker;
        FaceDetectFilter.FaceDetectParam param = new FaceDetectFilter.FaceDetectParam();
        if (hasFace) {
            param.mmcvBoxes = this.mmcvBoxes;
            if (!this.drawAllStickers(stickerItem, param, hasFace) && sticker.getType() == 0) {
                this.drawFaceSticker(stickerItem, param, info, facePos, angle);
            }
        } else {
            this.drawAllStickers(stickerItem, param, hasFace);
        }
    }

    public boolean drawAllStickers(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param, boolean hasFace) {
        Sticker sticker = stickerItem.sticker;
        if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("object_follower")) {
            stickerItem.clearPoints();
            this.drawGestureFilter(stickerItem, param);
        } else if (!sticker.isAlwaysShow() && !hasFace) {
            stickerItem.clearPoints();
        } else if (sticker.getType() == 1) {
            stickerItem.clearPoints();
            this.drawFixedSticker(stickerItem, param);
        } else if (sticker.getType() == 2) {
            stickerItem.clearPoints();
            this.drawFullScreenFixed(stickerItem, param);
        } else if (sticker.getType() == 3) {
            stickerItem.clearPoints();
            this.drawScaleToFill(stickerItem, param);
        } else if (sticker.getType() == 99) {
            stickerItem.clearPoints();
            this.drawScaleCenterCrop(stickerItem, param);
        } else if (sticker.getType() == 5) {
            stickerItem.clearPoints();
            this.drawAbsolutePostion(stickerItem, param);
        } else if (sticker.getType() == 6) {
            stickerItem.clearPoints();
            this.drawAbsolutePostionUseStcikerDim(stickerItem, param);
        } else if (sticker.getType() == 7) {
            stickerItem.clearPoints();
            this.drawAbsPostionAdjustResolution(stickerItem, param);
        } else if (sticker.isNotHiddenAfterTrigger() && !hasFace) {
            stickerItem.setDetectParam(param);
        } else {
            return false;
        }
        return true;
    }

    private void drawFaceSticker(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param, MMCVInfo info, float[] facePos, float faceRotateDegree) {
        int pointIndex1;
        PointF centerPoint;
        Sticker sticker = stickerItem.sticker;
        if (!sticker.isGameSticker) {
            stickerItem.clearPoints();
        }
        float x1 = facePos[sticker.getFacePositionLeft()];
        float y1 = facePos[sticker.getFacePositionLeft() + 68];
        float x2 = facePos[sticker.getFacePositionRight()];
        float y2 = facePos[sticker.getFacePositionRight() + 68];
        PointF point1 = new PointF(x1, y1);
        PointF point2 = new PointF(x2, y2);
        float angleZDegree = faceRotateDegree;
        PointF tPoint = new PointF((float)sticker.getOffsetX() * this.getAdjustWidthScale(), (float)sticker.getOffsetY() * this.getAdjustWidthScale());
        PointHelper.rotatePoint(tPoint, angleZDegree);
        if (sticker.hasCenterPoint()) {
            centerPoint = new PointF(facePos[sticker.getCenterIndex()], facePos[sticker.getCenterIndex() + 68]);
        } else if (sticker.getPointIndexes().length == 1) {
            pointIndex1 = sticker.getPointIndexes()[0];
            float pX1 = facePos[pointIndex1];
            float pY1 = facePos[pointIndex1 + 68];
            centerPoint = new PointF(pX1, pY1);
        } else {
            pointIndex1 = sticker.getPointIndexes()[0];
            int pointIndex2 = sticker.getPointIndexes()[1];
            float pX1 = facePos[pointIndex1];
            float pY1 = facePos[pointIndex1 + 68];
            float pX2 = facePos[pointIndex2];
            float pY2 = facePos[pointIndex2 + 68];
            centerPoint = PointHelper.getCenterPoint(new PointF(pX1, pY1), new PointF(pX2, pY2));
        }
        float distance = (float)PointHelper.getmDistancePoint(point1, point2);
        float scale = distance / 180.0f / this.getAdjustWidthScale();
        float defaultDrawWidth = this.getWidth() / 2;
        float imageScale = (float)sticker.getImageWidth() * this.getAdjustWidthScale() / defaultDrawWidth;
        scale *= imageScale;
        centerPoint.x += tPoint.x * (distance / 180.0f) / this.getAdjustWidthScale();
        centerPoint.y += tPoint.y * (distance / 180.0f) / this.getAdjustWidthScale();
        PointF pointF = new PointF(centerPoint.x / (float)this.getWidth(), centerPoint.y / (float)this.getHeight());
        param.scaleW = scale;
        param.scaleH = scale;
        param.centerPoint = pointF;
        param.angle = angleZDegree;
        if (info.getMaxFaceCnt() > 0) {
            param.points68 = info.getFaceAttributeInfo(0).getLandmarks68();
            param.points96 = info.getFaceAttributeInfo(0).getLandmarks96();
            param.points104 = info.getFaceAttributeInfo(0).getLandmarks104();
            param.warpedPoints104 = info.getFaceAttributeInfo(0).getWarpedLandmarks104();
        }
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawFixedSticker(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float scale;
        Sticker sticker = stickerItem.sticker;
        float x = (float)this.getWidth() / 2.0f;
        float y = sticker.isShowTop() ? (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f : (float)this.getHeight() - (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF point1 = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        param.scaleW = scale = (float)stickerItem.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        param.scaleH = scale;
        param.centerPoint = point1;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawGestureFilter(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        if (stickerItem.sticker.isDonotTrack()) {
            this.drawGestureFixedFilter(stickerItem, param);
        }
    }

    private void drawGestureFixedFilter(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        if (null == stickerItem.sticker.getObjectTriggerType()) {
            return;
        }
        if (null == this.mmcvBoxes || null == this.mmcvBoxes.getDetectResult()) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            stickerItem.setDetectParam(param);
            return;
        }
        param.triggerType = stickerItem.sticker.getObjectTriggerType();
        if (!TextUtils.isEmpty((CharSequence)param.triggerType)) {
            for (MMBox mmBox : this.mmcvBoxes.getDetectResult()) {
                if (!param.triggerType.equals(mmBox.class_name_)) continue;
                param.gestureRect = new RectF((float)mmBox.x_, (float)mmBox.y_, (float)(mmBox.x_ + mmBox.width_), (float)(mmBox.y_ + mmBox.height_));
                param.filterTrigerManager = this.filterTriggerManager;
                param.centerPoint = new PointF(0.0f, 0.0f);
                stickerItem.setDetectParam(param);
            }
        }
    }

    private void drawFullScreenFixed(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float x = (float)this.getWidth() / 2.0f;
        float y = ((float)this.getHeight() - (float)stickerItem.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)stickerItem.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF point1 = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        float scaleWidth = 1.5f;
        float scaleHeight = 1.5f;
        if (stickerItem.sticker.getImageWidth() > 360) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else if (this.getWidth() == 720) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else {
            scaleWidth = 1.5f;
            scaleHeight = 1.5f;
        }
        param.scaleW = scaleWidth;
        param.scaleH = scaleHeight;
        param.centerPoint = point1;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawScaleToFill(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float scale = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        param.scaleH = (float)this.getHeight() / (float)stickerItem.sticker.getImageHeight() * scale;
        param.scaleW = (float)this.getWidth() / (float)stickerItem.sticker.getImageWidth() * scale;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawScaleCenterCrop(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float slefScale = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        float dWidth = stickerItem.sticker.getImageWidth();
        float dHeight = stickerItem.sticker.getImageHeight();
        float scale = 1.5f;
        scale = dWidth * (float)this.getHeight() > (float)this.getWidth() * dHeight ? (float)this.getHeight() / dHeight * slefScale : (float)this.getWidth() / dWidth * slefScale;
        param.scaleW = scale;
        param.scaleH = scale;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawAbsolutePostion(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float scale = (float)stickerItem.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        AbsolutePosition absolutePos = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePos != null && absolutePos.getCenter() != null ? new PointF(absolutePos.getCenter().x, absolutePos.getCenter().y) : new PointF(0.5f, 0.5f);
        if (stickerItem instanceof StickerFixItem) {
            scale = 2.0f * (float)stickerItem.sticker.getImageWidth() / (float)this.getWidth();
            float marginLeft = absolutePos.getCenter().x * absolutePos.getCenter().w + ((float)this.getWidth() - absolutePos.getCenter().w) / 2.0f;
            float marginTop = absolutePos.getCenter().y * absolutePos.getCenter().h;
            param.centerPoint.x = marginLeft / (float)this.getWidth();
            param.centerPoint.y = marginTop / (float)this.getHeight();
        }
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawAbsolutePostionUseStcikerDim(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float scale = (float)stickerItem.sticker.getImageWidth() * ((float)this.getHeight() * 1.0f / (float)stickerItem.sticker.getBaseDemensionHeight()) / ((float)this.getWidth() / 2.0f);
        AbsolutePosition absolutePos = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePos != null && absolutePos.getCenter() != null ? new PointF(absolutePos.getCenter().x, absolutePos.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    private void drawAbsPostionAdjustResolution(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        float ratio = (float)this.getWidth() > 480.0f ? (float)this.getWidth() / 352.0f : 1.0f;
        float scale = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f) * ratio;
        AbsolutePosition absolutePos = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePos != null && absolutePos.getCenter() != null ? new PointF(absolutePos.getCenter().x, absolutePos.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = scale;
        param.scaleH = scale;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        stickerItem.setDetectParam(param);
    }

    public float getScaleWidthRatio() {
        return this.scaleWidthRatio;
    }

    public void setScaleWidthRatio(float scaleWidthRatio) {
        this.scaleWidthRatio = scaleWidthRatio;
    }

    public float getScaleHeightRatio() {
        return this.scaleHeightRatio;
    }

    public void setScaleHeightRatio(float scaleHeightRatio) {
        this.scaleHeightRatio = scaleHeightRatio;
    }

    public void setDownVelocity(float downVelocity) {
        for (StickerItem stickerItem : this.stickerItemList) {
            if (!(stickerItem instanceof StickerGameItem)) continue;
            ((StickerGameItem)stickerItem).downVelocity = downVelocity;
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List list : this.mPollTriggerStickerItemList) {
                for (StickerItem item : list) {
                    if (!(item instanceof StickerGameItem)) continue;
                    ((StickerGameItem)item).downVelocity = downVelocity;
                }
            }
        }
    }

    public void setHaniStickerParam(FaceDetectFilter.FaceDetectParam faceDetectParam, int haniID) {
        this.setHanniStickerParamInItemList(this.stickerItemList, faceDetectParam, haniID);
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                this.setHanniStickerParamInItemList(pollTriggerItemList, faceDetectParam, haniID);
            }
        }
    }

    private void setHanniStickerParamInItemList(List<StickerItem> itemList, FaceDetectFilter.FaceDetectParam faceDetectParam, int haniID) {
        StickerHaniItem haniItem = null;
        boolean hasHaniID = false;
        for (int i = 0; i < itemList.size(); ++i) {
            StickerItem item = itemList.get(i);
            if (!(item instanceof StickerHaniItem)) continue;
            haniItem = (StickerHaniItem)item;
            if (haniItem.sticker.getModelType() != haniID) continue;
            haniItem.setDetectParam(faceDetectParam);
            itemList.remove(item);
            hasHaniID = true;
            break;
        }
        if (hasHaniID && haniItem != null) {
            itemList.add(haniItem);
        }
    }

    public void removeHaniSticker(int haniID) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            this.removeHaniStickerFromList(this.stickerItemList, haniID);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                this.removeHaniStickerFromList(pollTriggerItemList, haniID);
            }
        }
    }

    private void removeHaniStickerFromList(List<StickerItem> itemList, int haniID) {
        for (StickerItem item : itemList) {
            if (!(item instanceof StickerHaniItem)) continue;
            StickerHaniItem haniItem = (StickerHaniItem)item;
            if (haniItem.sticker.getModelType() != haniID) continue;
            this.stickerItemDestroyList.add(item);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStickerItem(StickerItem item) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.stickerItemDestroyList.add(item);
        }
    }

    public void clearMaskWithModelType(int modelType) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            this.clearMaskWithModeTypeFromList(this.stickerItemList, modelType);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                this.clearMaskWithModeTypeFromList(pollTriggerItemList, modelType);
            }
            this.mPollTriggerStickerItemList.clear();
            this.mPollTriggerStickerItemList = null;
        }
    }

    private void clearMaskWithModeTypeFromList(List<StickerItem> itemList, int modelType) {
        for (StickerItem item : itemList) {
            if (item.sticker.getModelType() != modelType) continue;
            this.stickerItemDestroyList.add(item);
        }
    }

    public void removeSticker(String stickerType) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            this.removeStickerFromList(this.stickerItemList, stickerType);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                this.removeStickerFromList(pollTriggerItemList, stickerType);
            }
        }
    }

    private void removeStickerFromList(List<StickerItem> itemList, String stickerType) {
        for (StickerItem item : itemList) {
            if (!stickerType.equals(item.sticker.getStickerType())) continue;
            this.stickerItemDestroyList.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickerItemListSize() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.stickerItemList != null) {
                int pollTriggerStickerItemListSize = 0;
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    for (List<StickerItem> pollTriggerItemList : this.mPollTriggerStickerItemList) {
                        pollTriggerStickerItemListSize += pollTriggerItemList.size();
                    }
                }
                return this.stickerItemList.size() + pollTriggerStickerItemListSize;
            }
        }
        return 0;
    }

    public boolean isHaveSameSticker(Sticker sticker) {
        if (TextUtils.isEmpty((CharSequence)sticker.getStickerType())) {
            return false;
        }
        for (StickerItem stickerItem : this.stickerItemList) {
            if (!sticker.getStickerType().equals(stickerItem.sticker.getStickerType())) continue;
            return this.judgeHaveSameSticker(sticker, stickerItem);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List list : this.mPollTriggerStickerItemList) {
                for (StickerItem stickerItem : list) {
                    if (!stickerItem.sticker.getStickerType().equals(sticker.getStickerType())) continue;
                    return this.judgeHaveSameSticker(sticker, stickerItem);
                }
            }
        }
        return false;
    }

    private boolean judgeHaveSameSticker(Sticker sticker, StickerItem stickerItem) {
        if (stickerItem instanceof StickerDelegateItem && stickerItem.sticker.getImageProvider() != null) {
            ((StickerDelegateItem)stickerItem).replaceSticker(sticker);
            return true;
        }
        this.removeStickerItem(stickerItem);
        return false;
    }

    protected void setUseETC1(boolean bUseETC1) {
        if (bUseETC1) {
            GLES20.glUniform1f((int)this.mETC1Handler, (float)1.0f);
        } else {
            GLES20.glUniform1f((int)this.mETC1Handler, (float)0.0f);
        }
    }

    public void setMainFaceIndex(int index) {
        this.faceIndex = index;
    }

    public void setStickerFinishListener(StickerFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void setEffectTimeInfoByHaniId(EffectTimeBean time, int haniId) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemList) {
                if (stickerItem.sticker.getModelType() != haniId) continue;
                stickerItem.setEffectTimeInfo(time);
            }
        }
    }

    public static interface StickerFinishListener {
        public void stickerRenderFinished(int var1, Sticker var2);
    }
}

