/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameEngine;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class MultiStickerGameMaskFilter
extends MultiStickerMaskFilter {
    StickerGameEngine mStickerGameEngine = new StickerGameEngine();
    public static final int POINTS_LENGTH = 68;
    private static int INDEX_MOUSE_LEFT = 48;
    private static int INDEX_MOUSE_RIGHT = 54;
    private static int INDEX_MOUSE_UPTOP = 51;
    private static int INDEX_MOUSE_DOWNBOTTOM = 57;
    private boolean isMouthOpen;
    private boolean lastOpenState;
    private int triggerRegionOffset = 0;
    private long curTimeStamp = 0L;
    private boolean isGameOver = false;

    public MultiStickerGameMaskFilter(Context context) {
        super(context);
    }

    @Override
    public void addSticker(StickerItem item) {
        super.addSticker(item);
        if (item != null && item instanceof StickerGameItem) {
            this.mStickerGameEngine.addSticker((StickerGameItem)item);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        super.setTimeStamp(ms);
        this.curTimeStamp = ms;
    }

    public void setGameScoreListener(GameScoreListener listener) {
        this.mStickerGameEngine.setGameScoreListener(listener);
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        super.setMMCVInfo(mmcvInfo);
        this.updateFaceStatus(mmcvInfo);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.mStickerGameEngine != null) {
            this.mStickerGameEngine.setImageHeight(this.getHeight());
            this.mStickerGameEngine.setImageWidth(this.getWidth());
            this.mStickerGameEngine.setSrcImageWidthScaleRatio(this.scaleWidthRatio);
            this.mStickerGameEngine.setSrcImageHeightScaleRatio(this.scaleHeightRatio);
        }
        if (this.mStickerGameEngine != null) {
            this.mStickerGameEngine.setTimeStamp(this.curTimeStamp);
        }
        super.newTextureReady(texture, source, newData);
    }

    private void updateFaceStatus(MMCVInfo info) {
        if (null != this.filterTriggerManager) {
            boolean bl = this.isMouthOpen = this.filterTriggerManager.mouseOpenState == 0;
            if (!this.isMouthOpen && this.lastOpenState && info.getMaxFaceCnt() > 0) {
                float[] points = info.getFaceAttributeInfo(0).getLandmarks68();
                float mousePosLeftTopY = points[INDEX_MOUSE_UPTOP + 68] - (float)this.triggerRegionOffset;
                float mousePosLeftTopX = points[INDEX_MOUSE_LEFT] - (float)this.triggerRegionOffset;
                float mousePosRightBottomX = points[INDEX_MOUSE_RIGHT] + (float)this.triggerRegionOffset;
                float mousePosRightBottomY = points[INDEX_MOUSE_DOWNBOTTOM + 68] + (float)this.triggerRegionOffset;
                float widthDistance = Math.abs(mousePosLeftTopX - mousePosRightBottomX);
                float heighDistance = Math.abs(mousePosLeftTopY - mousePosRightBottomY);
                if (heighDistance < widthDistance) {
                    float distance = (widthDistance - heighDistance) / 2.0f;
                    mousePosLeftTopY -= distance;
                    mousePosRightBottomY += distance;
                } else {
                    float distance = (heighDistance - widthDistance) / 2.0f;
                    mousePosLeftTopX -= distance;
                    mousePosRightBottomX += distance;
                }
                if (this.mStickerGameEngine != null && !this.isGameOver) {
                    this.mStickerGameEngine.updateTriggerStatus(mousePosLeftTopX, mousePosLeftTopY, mousePosRightBottomX, mousePosRightBottomY);
                }
            }
            this.lastOpenState = this.isMouthOpen;
        }
    }

    public void playingTailMoving() {
        this.isGameOver = true;
        for (StickerItem item : this.stickerItemList) {
            item.isDraw = false;
            item.isTriggered = true;
            if (item.sticker.getObjectTriggerType() == null || !item.sticker.getObjectTriggerType().equals("game_over")) continue;
            item.startPlay();
        }
    }

    public void initGameFixStickerItem(Bitmap scoreBitmap, Bitmap iconBitmap, int width, int height) {
        int diff = scoreBitmap.getWidth() - iconBitmap.getWidth();
        Sticker iconSticker = new Sticker();
        iconSticker.setDuration(99999999999L);
        iconSticker.setFrameRate(20);
        iconSticker.setType(5);
        iconSticker.setStickerType("STICKER_TYPE_GAME_FIX_TYPE");
        iconSticker.setLayerType("default");
        iconSticker.setAlwaysShow(true);
        iconSticker.setObjectTriggerType("");
        iconSticker.setImageWidth(iconBitmap.getWidth());
        iconSticker.setImageHeight(iconBitmap.getHeight());
        AbsolutePosition position = new AbsolutePosition();
        ObjectRegion center = new ObjectRegion();
        float stepX = (float)(iconBitmap.getWidth() / 2) / ((float)width * 1.0f);
        float stepY = (float)(iconBitmap.getHeight() / 2) / ((float)height * 1.0f);
        float stepX1 = diff > 0 ? (float)(iconBitmap.getWidth() / 2 + diff) / ((float)width * 1.0f) : (float)(iconBitmap.getWidth() / 2) / ((float)width * 1.0f);
        float stepY1 = (float)(iconBitmap.getHeight() / 2) / ((float)height * 1.0f);
        center.x = 1.0f - stepX1 - 0.05f;
        center.y = stepY1 + 0.05f;
        center.w = width;
        center.h = height;
        position.setCenter(center);
        iconSticker.setAbsolutePos(position);
        StickerFixItem item = new StickerFixItem(iconSticker, null);
        item.setBitmap(iconBitmap);
        item.sticker.setImageWidth(iconBitmap.getWidth());
        item.sticker.setImageHeight(iconBitmap.getHeight());
        item.fixStickerType = "FIX_STICKER_TYPE_ICON";
        super.addSticker(item);
        Sticker scoreSticker = new Sticker();
        scoreSticker.setDuration(99999999999L);
        scoreSticker.setFrameRate(20);
        scoreSticker.setType(5);
        scoreSticker.setStickerType("STICKER_TYPE_GAME_FIX_TYPE");
        scoreSticker.setLayerType("default");
        scoreSticker.setAlwaysShow(true);
        scoreSticker.setObjectTriggerType("");
        scoreSticker.setImageWidth(scoreBitmap.getWidth());
        scoreSticker.setImageHeight(scoreBitmap.getHeight());
        AbsolutePosition position2 = new AbsolutePosition();
        ObjectRegion center2 = new ObjectRegion();
        float stepX2 = diff > 0 ? (float)(scoreBitmap.getWidth() / 2) / ((float)width * 1.0f) : (float)(scoreBitmap.getWidth() / 2 + diff) / ((float)width * 1.0f);
        float stepY2 = (float)(scoreBitmap.getHeight() / 2 + iconBitmap.getHeight()) / ((float)height * 1.0f);
        center2.x = 1.0f - stepX2 - 0.05f;
        center2.y = stepY2 + 0.05f + 0.01f;
        center2.w = width;
        center2.h = height;
        position2.setCenter(center2);
        scoreSticker.setAbsolutePos(position2);
        StickerFixItem item2 = new StickerFixItem(scoreSticker, null);
        item2.setBitmap(scoreBitmap);
        item2.sticker.setImageWidth(scoreBitmap.getWidth());
        item2.sticker.setImageHeight(scoreBitmap.getHeight());
        item2.fixStickerType = "FIX_STICKER_TYPE_SCORE";
        super.addSticker(item2);
    }

    public void updateGameFixStickerScore(Bitmap scoreBitmap) {
        for (StickerItem item : this.stickerItemList) {
            if (!(item instanceof StickerFixItem)) continue;
            StickerFixItem fixItem = (StickerFixItem)item;
            if (fixItem.fixStickerType != "FIX_STICKER_TYPE_SCORE") continue;
            fixItem.setBitmap(scoreBitmap);
        }
    }
}

