/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;

public class MmcvImageLoader {
    protected final int STICKER_MMTIME_PER_FRAME = 50;
    protected MMFrameInfo mMMCVImage;
    private ImageDelegateProvider mImageDelegateProvider;
    protected Sticker sticker;
    long mRenderTime = -1L;
    public String imagePath;
    protected long lastFrameTime;
    protected long currentTime;
    protected int mCurrentIndex;
    protected int lastCurSticker;

    public MmcvImageLoader(Sticker sticker) {
        this.sticker = sticker;
        if (sticker != null) {
            this.mImageDelegateProvider = sticker.getImageProvider();
        }
    }

    public int getMmcvTexture(Context context, int texture_in) {
        int texture = 0;
        MMFrameInfo mmcvImage = this.getMmcvImage(context);
        if (mmcvImage != null && mmcvImage.getFrame() != null) {
            texture = texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mmcvImage) : TextureHelper.loadDataToTexture((int)texture_in, (MMFrameInfo)mmcvImage);
        } else {
            Bitmap bitmap = this.getDelegateBitmap();
            if (bitmap != null) {
                texture = TextureHelper.bitmapToTexture((Bitmap)bitmap);
            }
        }
        return texture;
    }

    public MMFrameInfo getMmcvImage(Context context) {
        long curTime;
        long l = curTime = this.currentTime == 0L ? System.currentTimeMillis() : this.currentTime;
        if (this.mMMCVImage == null) {
            this.imagePath = this.sticker.getImagePath(context);
            if (this.imagePath == null) {
                return null;
            }
            this.mMMCVImage = new MMFrameInfo();
            ImageUtils.decodeMMCVImage((MMFrameInfo)this.mMMCVImage, (String)this.imagePath);
            this.lastFrameTime = this.mRenderTime == -1L ? curTime : this.mRenderTime;
        } else {
            long duration;
            long l2 = duration = this.mRenderTime == -1L ? curTime - this.lastFrameTime : this.mRenderTime - this.lastFrameTime;
            if (duration > 50L) {
                this.imagePath = this.sticker.getImagePath(context);
                if (this.imagePath == null) {
                    return null;
                }
                this.lastFrameTime = this.mRenderTime == -1L ? curTime : this.mRenderTime;
            }
            ImageUtils.decodeMMCVImage((MMFrameInfo)this.mMMCVImage, (String)this.imagePath);
        }
        return this.mMMCVImage;
    }

    public void setRenderTime(long renderTime) {
        this.mRenderTime = renderTime;
    }

    public Bitmap getDelegateBitmap() {
        return this.mImageDelegateProvider != null ? this.mImageDelegateProvider.getRealBitmap() : null;
    }

    public void cancel() {
        this.sticker.curIndex = 0;
        if (this.mMMCVImage != null) {
            this.mMMCVImage = null;
        }
    }

    protected int getImageIndexByPath(String path) {
        String[] results = path.split("_");
        String number = results[results.length - 1];
        number = number.replace(".png", "");
        return Integer.parseInt(number);
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public int getCurrentStickerImageIndex() {
        return this.mCurrentIndex;
    }
}

