/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.text.TextUtils;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.mm.mmutil.task.ThreadUtils;
import com.momo.mcamera.mask.MmcvImageLoader;
import com.momo.mcamera.mask.Sticker;

public class MmcvImageCacheLoader
extends MmcvImageLoader {
    private MMFrameInfo mCacheImage = new MMFrameInfo();
    private int mCacheIndex;
    private Object waitSignal = new Object();
    private volatile boolean cacheReady = false;

    public MmcvImageCacheLoader(Sticker sticker, Context context) {
        super(sticker);
        this.lastCurSticker = -1;
        this.executeStickerCacheThread(sticker, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MMFrameInfo getMmcvImage(Context context) {
        long curTime = this.currentTime == 0L ? System.currentTimeMillis() : this.currentTime;
        try {
            Object object = this.waitSignal;
            synchronized (object) {
                long duration;
                if (this.mMMCVImage == null) {
                    this.mMMCVImage = new MMFrameInfo();
                }
                long l = duration = this.mRenderTime == -1L ? curTime - this.lastFrameTime : this.mRenderTime - this.lastFrameTime;
                if (duration > 50L || this.lastCurSticker != this.sticker.curIndex) {
                    this.imagePath = this.sticker.getImagePath(context);
                    if (this.imagePath == null) {
                        return null;
                    }
                    int index = this.getImageIndexByPath(this.imagePath);
                    if (index == this.mCacheIndex && this.cacheReady) {
                        MMFrameInfo tempImage = null;
                        tempImage = this.mMMCVImage;
                        this.mMMCVImage = this.mCacheImage;
                        this.mCacheImage = tempImage;
                    } else {
                        ImageUtils.decodeMMCVImage((MMFrameInfo)this.mMMCVImage, (String)this.imagePath);
                    }
                    this.mCacheIndex = this.sticker.curIndex;
                    this.cacheReady = false;
                    this.mCurrentIndex = index;
                    this.lastCurSticker = this.sticker.curIndex;
                    this.lastFrameTime = this.mRenderTime == -1L ? curTime : this.mRenderTime;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        this.executeStickerCacheThread(this.sticker, context);
        return this.mMMCVImage;
    }

    private void executeStickerCacheThread(final Sticker sticker, final Context context) {
        ThreadUtils.execute((int)2, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = MmcvImageCacheLoader.this.waitSignal;
                synchronized (object) {
                    try {
                        String cacheImagePath;
                        if (!MmcvImageCacheLoader.this.cacheReady && (cacheImagePath = sticker.getImagePathByIndex(context, MmcvImageCacheLoader.this.mCacheIndex)) != null && !TextUtils.isEmpty((CharSequence)cacheImagePath)) {
                            ImageUtils.decodeMMCVImage((MMFrameInfo)MmcvImageCacheLoader.this.mCacheImage, (String)cacheImagePath);
                            if (MmcvImageCacheLoader.this.mCacheImage.getFrame() != null) {
                                MmcvImageCacheLoader.this.cacheReady = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

