/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.momo.mcamera.mask.GLProgram;
import java.util.HashMap;

public class GLFaceBlendProgram
extends GLProgram {
    private static final String BLEND_KEY_ADD = "Add";
    private static final String BLEND_KEY_COLOR = "Color";
    private static final String BLEND_KEY_COLOR_BURN = "ColorBurn";
    private static final String BLEND_KEY_COLOR_DODGE = "ColorDodge";
    private static final String BLEND_KEY_DARKEN = "Darken";
    private static final String BLEND_KEY_DIFFERENCE = "Difference";
    private static final String BLEND_KEY_DIVIDE = "Divide";
    private static final String BLEND_KEY_EXCLUSION = "Exclusion";
    private static final String BLEND_KEY_HARDLIGHT = "HardLight";
    private static final String BLEND_KEY_HUE = "Hue";
    private static final String BLEND_KEY_LIGHTEN = "Lighten";
    private static final String BLEND_KEY_LINEARBURN = "LinearBurn";
    private static final String BLEND_KEY_LUMINOSITY = "Luminosity";
    private static final String BLEND_KEY_MASK = "Mask";
    private static final String BLEND_KEY_MULTIPLY = "Multiply";
    private static final String BLEND_KEY_NORMAL = "Normal";
    private static final String BLEND_KEY_OVERLAY = "Overlay";
    private static final String BLEND_KEY_SATURATION = "Saturation";
    private static final String BLEND_KEY_SCREEN_BLEND = "Screen";
    private static final String BLEND_KEY_SOFT_LIGHT = "SoftLight";
    private static final String BLEND_KEY_SOURCE_OVER = "SourceOver";
    private static final String BLEND_KEY_SUBTRACT = "Subtract";
    private static final String INTENSITY = "intensity";
    private HashMap<String, String> blendFragmentShaderMap = new HashMap();
    private float mIntensity = 0.0f;
    private int mHandleIntensity = 0;
    private float BLEND_RATIO = 0.8f;
    private String mBlendType = "Normal";
    private String normalFragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate0;\nvarying vec2 textureCoordinate1;\nuniform float intensity;\n\n" + this.premultiply() + this.unpremultiply() + this.normalBlend() + "void main(){\n  vec4 uCb = texture2D(inputImageTexture0, textureCoordinate" + 0 + ");\n  vec4 uCf = texture2D(inputImageTexture1, textureCoordinate" + 1 + ");\n  vec4 blendedColor = normalBlend(uCb, uCf);\n  gl_FragColor = mix(uCb,blendedColor,intensity);\n}";
    protected String multiplyFragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate0;\nvarying vec2 textureCoordinate1;\nuniform float intensity;\n\n" + this.premultiply() + this.unpremultiply() + this.normalBlend() + this.blendBaseAlpha() + this.multiplayBlend() + "void main(){\n  vec4 uCb = texture2D(inputImageTexture0, " + "textureCoordinate" + 0 + ");\n  vec4 uCf = texture2D(inputImageTexture1, " + "textureCoordinate" + 1 + ");\n  vec4 blendedColor = multiplyBlend(uCb, uCf);\n  gl_FragColor = mix(uCb,blendedColor,intensity);\n}";
    protected String overlayFragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate0;\nvarying vec2 textureCoordinate1;\nuniform float intensity;\n\n" + this.premultiply() + this.unpremultiply() + this.normalBlend() + this.blendBaseAlpha() + this.overlayBlendSingleChannel() + this.overlayBlend() + "void main(){\n  vec4 uCb = texture2D(inputImageTexture0, " + "textureCoordinate" + 0 + ");\n  vec4 uCf = texture2D(inputImageTexture1, " + "textureCoordinate" + 1 + ");\n  vec4 blendedColor = overlayBlend(uCb, uCf);\n  gl_FragColor = mix(uCb,blendedColor,intensity);\n}";
    protected String subtractFragmentShader = "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate0;\nvarying vec2 textureCoordinate1;\nuniform float intensity;\nvoid main(){\n   vec4 color1 = texture2D(inputImageTexture0,textureCoordinate0);\n   vec4 color2 = texture2D(inputImageTexture1,textureCoordinate1);\n   gl_FragColor = mix(vec4(color1.rgb - color2.rgb, color1.a), color1, intensity);\n}\n";

    private String multiplayBlend() {
        return "vec4 multiplyBlend(vec4 cb, vec4 cs){\n  vec4 B = clamp(vec4(cb.rgb * cs.rgb, cs.a), vec4(0), vec4(1));\n  return blendBaseAlpha(cb, cs, B);\n}\n";
    }

    private String overlayBlend() {
        return "\nvec4 overlayBlend(vec4 cb, vec4 cs){\n  vec4 b = vec4(overlayBlendSingleChannel(cb.r, cs.r), overlayBlendSingleChannel(cb.g, cs.g), overlayBlendSingleChannel(cb.b, cs.b), cs.a);\n  return blendBaseAlpha(cb, cs, b);\n}\n";
    }

    private String overlayBlendSingleChannel() {
        return "float overlayBlendSingleChannel(float b, float s){\n  return b < 0.5 ? (2.0 * s * b) : (1.0 - 2.0 * (1.0 - b) * (1.0 - s));\n}\n";
    }

    private String blendBaseAlpha() {
        return "vec4 blendBaseAlpha(vec4 cb, vec4 cs, vec4 b){\n  vec4 cr = vec4((1.0 - cb.a) * cs.rgb + cb.a * clamp(b.rgb, vec3(0.0), vec3(1.0)), cs.a);\n  return normalBlend(cb, cr);\n}\n";
    }

    private String normalBlend() {
        return "vec4 normalBlend(vec4 cb, vec4 cs){\n  vec4 dst = premultiply(cb);\n  vec4 src = premultiply(cs);\n  return unpremultiply(src + dst * (1.0 - src.a));\n}\n";
    }

    private String premultiply() {
        return "vec4 premultiply(vec4 s){\n  return vec4(s.rgb * s.a, s.a);\n}\n";
    }

    private String unpremultiply() {
        return "vec4 unpremultiply(vec4 s){\n  return vec4(s.rgb/max(s.a, 0.00001), s.a);\n}\n";
    }

    public GLFaceBlendProgram() {
        super(2, 2);
        this.blendFragmentShaderMap.put(BLEND_KEY_MULTIPLY, this.multiplyFragmentShader);
        this.blendFragmentShaderMap.put(BLEND_KEY_NORMAL, this.normalFragmentShader);
        this.blendFragmentShaderMap.put(BLEND_KEY_OVERLAY, this.overlayFragmentShader);
    }

    public void setIntensity(float value) {
        this.mIntensity = value;
    }

    public void setBlendType(String type) {
        if (this.mBlendType == type) {
            return;
        }
        this.mBlendType = type;
        this.initialized = false;
    }

    @Override
    public void setDrawType(int type) {
        super.setDrawType(type);
    }

    @Override
    public void setRenderSize(int width, int height) {
        super.setRenderSize(width, height);
    }

    @Override
    public void drawFrame(float[][] triArray, int[] textures) {
        super.drawFrame(triArray, textures);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected String getSubVertexShader() {
        return super.getSubVertexShader();
    }

    @Override
    protected String getSubFrameShader() {
        if (TextUtils.isEmpty((CharSequence)this.mBlendType) || !this.blendFragmentShaderMap.containsKey(this.mBlendType)) {
            this.mBlendType = BLEND_KEY_NORMAL;
        }
        String fshader = this.blendFragmentShaderMap.get(this.mBlendType);
        return fshader;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mHandleIntensity = GLES20.glGetUniformLocation((int)this.programHandle, (String)INTENSITY);
    }

    @Override
    protected void passShaderValues(float[][] triArray, int[] textures) {
        super.passShaderValues(triArray, textures);
        GLES20.glUniform1f((int)this.mHandleIntensity, (float)(this.mIntensity * this.BLEND_RATIO));
    }
}

