/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import android.graphics.RectF;
import android.text.TextUtils;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momocv.MMBox;

public class FilterTriggerManager {
    public static final int TRIGER_MOUSE = 1;
    public static final int TRIGER_LEFT_EYE = 8;
    public static final int TRIGER_LEFT_EYE_BLINK = 16;
    public static final int TRIGER_RIGHT_EYE = 64;
    public static final int TRIGER_RIGHT_EYE_BLINK = 128;
    public static final int TRIGER_EYE_BLINK = 256;
    public static final int TRIGER_SMILE = 512;
    public static final int TRIGER_DUCK_FACE = 1024;
    public static final int TRIGER_CLICK = 2048;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSE = 1;
    private static int INDEX_FACE_LEFT = 0;
    private static int INDEX_FACE_RIGHT = 16;
    private static int INDEX_MOUSE_UP = 62;
    private static int INDEX_MOUSE_DOWN = 66;
    public int mouseOpenState = 1;
    public int leftEyeBlinkState = 1;
    public int leftEyeBlinkCount = 0;
    public int eyeBlinkState = 1;
    public int eyeBlinkCount = 0;
    public int rightEyeBlinkState = 0;
    public int rightEyeBlinkCount = 0;
    public int leftEyeOpenState = 0;
    public int rightEyeOpenState = 0;
    public int expressionState = -1;
    public int smileState = 1;
    public int duckFaceState = 1;
    public float leftEyeOpenAmount = 1.0f;
    public float rightEyeOpenAmount = 1.0f;
    private int flag = -1;
    private int hiddenFlag = -1;
    private int faceIndex = 0;

    public static boolean isTriggerRegionMatches(MMCVBoxes mmcvBoxes, String triggerType, MaskModel model, int width, int height) {
        boolean triggerRegionMatches = true;
        if (null != model.getTriggerRegion() && model.getTriggerRegion().length == 3) {
            PointF centerPoint = null;
            if (mmcvBoxes.getDetectResult() == null || mmcvBoxes.getDetectResult().length == 0) {
                return false;
            }
            for (MMBox mmBox : mmcvBoxes.getDetectResult()) {
                if (!triggerType.equals(mmBox.class_name_)) continue;
                RectF rectF = new RectF((float)mmBox.x_, (float)mmBox.y_, (float)(mmBox.x_ + mmBox.width_), (float)(mmBox.y_ + mmBox.height_));
                centerPoint = new PointF(rectF.centerX(), rectF.centerY());
            }
            if (centerPoint == null) {
                return false;
            }
            int[] triggerRegion = model.getTriggerRegion();
            int widthSlice = triggerRegion[0];
            int heightSlice = triggerRegion[1];
            int region = triggerRegion[2];
            float sliceWidth = width / widthSlice;
            float sliceHeight = height / widthSlice;
            RectF regionRect = new RectF((float)(region % widthSlice) * sliceWidth, (float)(region / heightSlice) * sliceHeight, (float)(region % widthSlice) * sliceWidth + sliceWidth, (float)(region / heightSlice) * sliceHeight + sliceHeight);
            triggerRegionMatches = regionRect.contains(centerPoint.x, centerPoint.y);
        }
        return triggerRegionMatches;
    }

    public void setTriggerType(int permission) {
        if (this.flag == -1) {
            this.flag = permission;
        } else {
            this.enable(permission);
        }
    }

    private void enable(int permission) {
        this.flag |= permission;
    }

    public void disable(int permission) {
        this.flag &= ~permission;
    }

    private boolean isContain(int permission) {
        return (this.flag & permission) == permission;
    }

    public void setHiddenTriggerType(int permission) {
        if (this.hiddenFlag == -1) {
            this.hiddenFlag = permission;
        } else {
            this.hiddenEnable(permission);
        }
    }

    private void hiddenEnable(int permission) {
        this.hiddenFlag |= permission;
    }

    private void hiddenDisable(int permission) {
        this.hiddenFlag &= ~permission;
    }

    private boolean isHiddenContain(int permission) {
        return (this.hiddenFlag & permission) == permission;
    }

    public void adjustStateBy(MMCVInfo mmcvInfo) {
        FaceAttributeInfo faceInfo;
        if (mmcvInfo == null) {
            return;
        }
        if (this.faceIndex >= mmcvInfo.getMaxFaceCnt()) {
            this.faceIndex = 0;
        }
        if ((faceInfo = mmcvInfo.getFaceAttributeInfo(this.faceIndex)) != null) {
            if (this.isContain(1) || this.isHiddenContain(1)) {
                this.updateMouseState(faceInfo.getLandmarks68());
            }
            if (this.isContain(1024) || this.isContain(512) || this.isHiddenContain(1024) || this.isHiddenContain(512)) {
                this.smileState = 1;
                this.duckFaceState = 1;
                if (faceInfo.getExpression() == 1) {
                    this.duckFaceState = 0;
                } else if (faceInfo.getExpression() == 2) {
                    this.smileState = 0;
                }
            }
            if (this.isContain(8) || this.isContain(64) || this.isContain(16) || this.isContain(128) || this.isHiddenContain(8) || this.isHiddenContain(64) || this.isHiddenContain(256) || this.isHiddenContain(16) || this.isHiddenContain(128)) {
                this.updateEyeState(faceInfo);
            }
            if (this.isContain(16) || this.isContain(128) || this.isContain(256) || this.isHiddenContain(16) || this.isHiddenContain(128)) {
                if (this.rightEyeOpenState == 0 && this.leftEyeOpenState == 1) {
                    ++this.leftEyeBlinkCount;
                    this.leftEyeBlinkState = this.leftEyeBlinkCount > 1 ? 0 : 1;
                } else {
                    this.leftEyeBlinkCount = 0;
                    this.leftEyeBlinkState = 1;
                }
                if (this.rightEyeOpenState == 1 && this.leftEyeOpenState == 0) {
                    ++this.rightEyeBlinkCount;
                    this.rightEyeBlinkState = this.rightEyeBlinkCount > 1 ? 0 : 1;
                } else {
                    this.rightEyeBlinkCount = 0;
                    this.rightEyeBlinkState = 1;
                }
                if (this.rightEyeOpenState == 1 || this.leftEyeOpenState == 1) {
                    ++this.eyeBlinkCount;
                    this.eyeBlinkState = this.eyeBlinkCount > 1 ? 0 : 1;
                } else {
                    this.eyeBlinkCount = 0;
                    this.eyeBlinkState = 1;
                }
            }
        }
    }

    public void updateEyeState(FaceAttributeInfo faceAttributeInfo) {
        this.leftEyeOpenAmount = faceAttributeInfo.getLeftEyeCloseProb();
        this.rightEyeOpenAmount = faceAttributeInfo.getRightEyeCloseProb();
        this.leftEyeOpenState = (double)this.leftEyeOpenAmount >= 0.7 ? 1 : 0;
        this.rightEyeOpenState = (double)this.rightEyeOpenAmount >= 0.7 ? 1 : 0;
    }

    public void updateMouseState(float[] points) {
        if (points == null) {
            return;
        }
        float xUP = points[INDEX_FACE_LEFT];
        float yUP = points[INDEX_FACE_LEFT + 68];
        float xDown = points[INDEX_FACE_RIGHT];
        float yDown = points[INDEX_FACE_RIGHT + 68];
        float xLeft = points[INDEX_MOUSE_DOWN];
        float yLeft = points[INDEX_MOUSE_DOWN + 68];
        float xRight = points[INDEX_MOUSE_UP];
        float yRight = points[INDEX_MOUSE_UP + 68];
        float distance = (float)Math.hypot(xUP - xDown, yUP - yDown);
        float hDistance = (float)Math.hypot(xRight - xLeft, yRight - yLeft);
        if (this.mouseOpenState == 0) {
            if ((double)hDistance < (double)(distance * 1.0f) / 14.0) {
                this.mouseOpenState = 1;
            }
        } else {
            this.mouseOpenState = hDistance > distance * 1.0f / 10.0f ? 0 : 1;
        }
    }

    public boolean triggerTypeProcess(Sticker sticker, StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        int hiddenTriggerType;
        boolean shouldShow = true;
        if (sticker.getTriggerType() > 0) {
            sticker.setTriggerState(this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            if (null != stickerStateChangeListener) {
                stickerStateChangeListener.stickerStateChanged(sticker.getTriggerType(), this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            }
            shouldShow = sticker.getTriggerState() != 1;
        }
        if ((hiddenTriggerType = sticker.getHiddenTriggerType()) > 0) {
            int stateByTriggerType = this.getTriggerStateByTriggerType(hiddenTriggerType);
            sticker.setTriggerState(stateByTriggerType);
            if (null != stickerStateChangeListener) {
                stickerStateChangeListener.stickerStateChanged(sticker.getTriggerType(), this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            }
            shouldShow = hiddenTriggerType == 8 || hiddenTriggerType == 64 ? sticker.getTriggerState() == 0 : sticker.getTriggerState() != 0;
        }
        return shouldShow;
    }

    public boolean objectTriggerTypeProcess(Sticker sticker, FaceDetectFilter.FaceDetectParam param, boolean isTriggered) {
        String objectTriggerType;
        boolean shouldShow = true;
        String hiddenObjectTriggerType = sticker.getHiddenObjectTriggerType();
        if (!TextUtils.isEmpty((CharSequence)hiddenObjectTriggerType) && param.mmcvBoxes != null && param.mmcvBoxes.getDetectResult() != null) {
            for (MMBox mmBox : param.mmcvBoxes.getDetectResult()) {
                if (!hiddenObjectTriggerType.equals(mmBox.class_name_)) continue;
                return false;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(objectTriggerType = sticker.getObjectTriggerType()))) {
            if (objectTriggerType.equals("game_over")) {
                shouldShow = isTriggered;
            } else if (param.mmcvBoxes != null && param.mmcvBoxes.getDetectResult() != null && param.mmcvBoxes.getDetectResult().length > 0) {
                for (MMBox mmBox : param.mmcvBoxes.getDetectResult()) {
                    if (!objectTriggerType.equals(mmBox.class_name_)) continue;
                    return true;
                }
                shouldShow = false;
            } else if (param.gestureRect == null) {
                shouldShow = false;
            }
        }
        return shouldShow;
    }

    public int getTriggerStateByTriggerType(int triggerType) {
        int state = this.mouseOpenState;
        switch (triggerType) {
            case 1: {
                state = this.mouseOpenState;
                break;
            }
            case 8: {
                state = this.leftEyeOpenState;
                break;
            }
            case 64: {
                state = this.rightEyeOpenState;
                break;
            }
            case 128: {
                state = this.rightEyeBlinkState;
                break;
            }
            case 16: {
                state = this.leftEyeBlinkState;
                break;
            }
            case 256: {
                state = this.eyeBlinkState;
                break;
            }
            case 512: {
                state = this.smileState;
                break;
            }
            case 1024: {
                state = this.duckFaceState;
            }
        }
        return state;
    }

    public void setTriggerFaceIndex(int faceIndex) {
        this.faceIndex = faceIndex;
    }
}

