/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FaceWarpFilter
extends FaceDetectFilter {
    private List<MMCVInfo> mvpLists = Collections.synchronizedList(new ArrayList());

    protected String getFragmentShader() {
        return super.getFragmentShader();
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
    }

    protected void passShaderValues() {
    }

    public void drawSub() {
        if (this.mvpLists.size() > 0 && this.mvpLists.get(0).getSrcWarpPoints() != null) {
            long t0 = System.currentTimeMillis();
            GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
            GLES20.glClear((int)16640);
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.texture_in);
            GLES20.glUniform1i((int)this.textureHandle, (int)0);
            GLES20.glUseProgram((int)this.programHandle);
            float[] srcWarpPoints = this.mvpLists.get(0).getSrcWarpPoints();
            int point_sz = srcWarpPoints.length / 2;
            int triangle_size = srcWarpPoints.length / 6;
            float[] vertexCoord = this.mvpLists.get(0).getDstWarpPoints();
            float[] textCoord = srcWarpPoints;
            ByteBuffer byteBuf_ver = ByteBuffer.allocateDirect(vertexCoord.length * 4);
            byteBuf_ver.order(ByteOrder.nativeOrder());
            FloatBuffer buffer_ver = byteBuf_ver.asFloatBuffer();
            buffer_ver.put(vertexCoord);
            buffer_ver.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer_ver);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            ByteBuffer byteBuf_tex = ByteBuffer.allocateDirect(textCoord.length * 4);
            byteBuf_tex.order(ByteOrder.nativeOrder());
            FloatBuffer buffer_tex = byteBuf_tex.asFloatBuffer();
            buffer_tex.put(textCoord);
            buffer_tex.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer_tex);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glDrawArrays((int)4, (int)0, (int)(triangle_size * 3));
            this.disableDrawArray();
        } else {
            long t0 = System.currentTimeMillis();
            float[] vertexCoord = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
            float[] textCoord = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
            GLES20.glClear((int)16640);
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glUseProgram((int)this.programHandle);
            ByteBuffer byteBuf = ByteBuffer.allocateDirect(vertexCoord.length * 4);
            byteBuf.order(ByteOrder.nativeOrder());
            FloatBuffer buffer = byteBuf.asFloatBuffer();
            buffer.put(vertexCoord);
            buffer.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            byteBuf = ByteBuffer.allocateDirect(textCoord.length * 4);
            byteBuf.order(ByteOrder.nativeOrder());
            buffer = byteBuf.asFloatBuffer();
            buffer.put(textCoord);
            buffer.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.texture_in);
            GLES20.glUniform1i((int)this.textureHandle, (int)0);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            this.disableDrawArray();
        }
        this.clearPoints();
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (null != mmcvInfo) {
            this.mvpLists.add(mmcvInfo);
        }
    }

    @Override
    public void clearPoints() {
        this.mvpLists.clear();
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }
}

