/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import com.momocv.mangaface.MangaFace;
import com.momocv.mangaface.MangaFaceInfo;
import com.momocv.mangaface.MangaFaceParams;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class FaceMaskFilter
extends FaceDetectFilter {
    private Sticker sticker;
    private MMFrameInfo curMMCVImage;
    private List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    private List<Map<Float, float[]>> mvpAngle = Collections.synchronizedList(new ArrayList());
    protected Object maskListLock = new Object();
    private boolean mStickerChanged = false;
    private List<Sticker> mStickersList = null;
    private int mCount = 0;
    private boolean mLastHasFace = false;
    protected FloatBuffer vertexBufer;
    protected final int vertexStride = 8;
    protected static final int COORDS_PER_VERTEX = 2;
    private Model model;

    public FaceMaskFilter(Sticker sticker) {
        this.sticker = sticker;
        this.model = new Model();
        this.curMMCVImage = new MMFrameInfo();
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.curMMCVImage, (String)sticker.getMask().getTexturePath());
        this.model.data = this.curMMCVImage.getDataPtr();
        this.model.texCoords = sticker.getMask().landmarks;
        this.model.comic = sticker.isComic();
    }

    protected String getFragmentShader() {
        return super.getFragmentShader();
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    protected void passShaderValues() {
        super.passShaderValues();
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
    }

    private void drawFace(float[] face_points, float[] angle) {
        float[] textCoord;
        float[] vertexCoord;
        int drawCount;
        if (this.model.comic) {
            drawCount = AIFaceTriangulation.CXFaceTriangulationIndexesWithCornerPoint.length;
            MangaFace mangaFace = new MangaFace();
            MangaFaceParams mangaFaceParams = new MangaFaceParams();
            mangaFaceParams.euler_angles_ = angle;
            mangaFaceParams.image_height_ = this.getHeight();
            mangaFaceParams.image_width_ = this.getWidth();
            mangaFaceParams.landmarks96_ = face_points;
            if (this.sticker.getImageHeight() == 0 || this.sticker.getImageWidth() == 0) {
                mangaFaceParams.manga_height_ = 640;
                mangaFaceParams.manga_width_ = 480;
            } else {
                mangaFaceParams.manga_height_ = this.sticker.getImageHeight();
                mangaFaceParams.manga_width_ = this.sticker.getImageWidth();
            }
            mangaFaceParams.manga_landmarks_ = this.model.texCoords;
            MangaFaceInfo mangaFaceInfo = new MangaFaceInfo();
            mangaFace.manga_face(mangaFaceParams, mangaFaceInfo);
            float[][] array = AIFaceTriangulation.getFaceTriangulationWithCornerPoint(mangaFaceInfo.landmarks96_plus4_pts_, this.model.texCoords);
            vertexCoord = array[0];
            textCoord = array[2];
        } else {
            drawCount = AIFaceTriangulation.CXFaceTriangulationIndexes.length;
            float[][] array = AIFaceTriangulation.getFaceTriangulation(face_points, this.getWidth(), this.getHeight(), this.model.texCoords);
            vertexCoord = array[0];
            textCoord = array[2];
        }
        this.setRenderVertices(vertexCoord);
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(textCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.vertexBufer.rewind();
        this.vertexBufer.put(textCoord);
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glDrawArrays((int)4, (int)0, (int)drawCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            if (this.model.comic) {
                for (int i = 0; i < this.mvpAngle.size(); ++i) {
                    super.passShaderValues();
                    Set<Float> set = this.mvpAngle.get(i).keySet();
                    for (float[] fArray : set) {
                        float[] points = this.mvpAngle.get(i).get(fArray);
                        this.drawFace(points, fArray);
                    }
                }
            } else {
                for (float[] points : this.mvpLists) {
                    super.passShaderValues();
                    this.drawFace(points, null);
                }
            }
        }
        this.disableDrawArray();
        this.clearPoints();
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (this.mvpLists != null && this.mvpAngle != null) {
            this.mvpLists.add(detectParam.warpedPoints104 == null ? detectParam.points104 : detectParam.warpedPoints104);
            HashMap<float[], float[]> hashMap = new HashMap<float[], float[]>();
            hashMap.put(detectParam.euler_angles, detectParam.points96);
            this.mvpAngle.add(hashMap);
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null || this.texture_in == 0) {
            return;
        }
        if (mmcvInfo.getMaxFaceCnt() <= 0 && this.mLastHasFace && this.mStickersList != null && this.mStickersList.size() > 0) {
            ++this.mCount;
            this.mCount %= this.mStickersList.size();
            this.resetSticker(this.mStickersList.get(this.mCount));
            this.mLastHasFace = false;
        }
        if (mmcvInfo.getMaxFaceCnt() > 0) {
            this.mLastHasFace = true;
        }
    }

    @Override
    public void clearPoints() {
        if (this.mvpLists != null) {
            this.mvpLists.clear();
        }
        if (this.mvpAngle != null) {
            this.mvpAngle.clear();
        }
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
        if (this.model != null || this.curMMCVImage != null) {
            this.model = null;
            this.curMMCVImage = null;
        }
        if (this.texture_in != 0) {
            int[] textureArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])textureArray, (int)0);
            this.texture_in = 0;
        }
        this.sticker = sticker;
        this.model = new Model();
        this.curMMCVImage = new MMFrameInfo();
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.curMMCVImage, (String)sticker.getMask().getTexturePath());
        this.model.data = this.curMMCVImage.getDataPtr();
        this.model.texCoords = sticker.getMask().landmarks;
        this.model.comic = sticker.isComic();
        this.mStickerChanged = false;
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        if (this.texture_in == 0 || !this.mStickerChanged) {
            this.texture_in = TextureHelper.bitmapToTexture((MMFrameInfo)this.curMMCVImage);
            this.mStickerChanged = true;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
        if (null != this.curMMCVImage) {
            this.curMMCVImage = null;
        }
    }

    public void addStickerList(List<Sticker> stickersList) {
        this.mStickersList = stickersList;
    }

    private class Model {
        float[] texCoords;
        byte[] data;
        boolean comic;

        private Model() {
        }
    }
}

