/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.google.ar.core.Frame;
import com.google.ar.core.Session;
import com.momo.mcamera.mask.FaceDetectGroupFilter;
import com.momo.mcamera.mask.StickerAdjustFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.ARCoreInterface;
import project.android.imageprocessing.inter.IPlayStatusInterface;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.MStickerActions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class FaceDetectSingleLineGroup
extends FaceDetectGroupFilter
implements IVideoTrackTime,
IPlayStatusInterface,
ARCoreInterface {
    private ArrayList<FaceDetectInterface> faceDetectGroupFilters = new ArrayList();
    private ArrayList<BasicFilter> mFilters = new ArrayList();
    private CopyOnWriteArrayList<BasicFilter> destroyList = new CopyOnWriteArrayList();

    public FaceDetectSingleLineGroup(List<BasicFilter> filters) {
        this.constructGroupFilter(filters);
    }

    private void constructGroupFilter(List<BasicFilter> filters) {
        if (filters.size() > 0) {
            BasicFilter filterBegin = filters.get(0);
            BasicFilter filterEnd = filters.get(filters.size() - 1);
            this.registerInitialFilter(filterBegin);
            BasicFilter curFilter = null;
            for (int i = 0; i <= filters.size() - 1; ++i) {
                BasicFilter basicFilter = filters.get(i);
                if (basicFilter instanceof FaceDetectInterface) {
                    this.faceDetectGroupFilters.add((FaceDetectInterface)basicFilter);
                }
                this.mFilters.add(basicFilter);
                basicFilter.clearTarget();
                if (curFilter == null) {
                    curFilter = basicFilter;
                } else {
                    curFilter.addTarget((GLTextureInputRenderer)filters.get(i));
                }
                if (i > 0 && i < filters.size() - 1) {
                    this.registerFilter(basicFilter);
                }
                curFilter = filters.get(i);
            }
            filterEnd.addTarget((GLTextureInputRenderer)this);
            this.registerTerminalFilter(filterEnd);
        }
    }

    private void destructGroupFilter() {
        if (this.mFilters.size() > 0) {
            BasicFilter filterBegin = this.mFilters.get(0);
            BasicFilter filterEnd = this.mFilters.get(this.mFilters.size() - 1);
            this.removeTerminalFilter(filterEnd);
            filterEnd.clearTarget();
            for (int i = this.mFilters.size() - 1; i >= 0; --i) {
                BasicFilter basicFilter = this.mFilters.get(i);
                if (basicFilter instanceof FaceDetectInterface) {
                    this.faceDetectGroupFilters.remove((FaceDetectInterface)basicFilter);
                }
                basicFilter.clearTarget();
                if (i <= 0 || i >= this.mFilters.size() - 1) continue;
                this.removeFilter(basicFilter);
            }
            this.removeInitialFilter(filterBegin);
            this.mFilters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean resetFilter(BasicFilter oldFilter, BasicFilter newFilter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (newFilter == null || oldFilter == null || oldFilter == newFilter) {
                return false;
            }
            boolean inFiltersList = false;
            for (int i = 0; i < this.mFilters.size(); ++i) {
                BasicFilter filter = this.mFilters.get(i);
                BasicFilter preFilter = null;
                BasicFilter afterFilter = null;
                if (filter != oldFilter) continue;
                inFiltersList = true;
                if (i > 0) {
                    preFilter = this.mFilters.get(i - 1);
                }
                if (i + 1 < this.mFilters.size()) {
                    afterFilter = this.mFilters.get(i + 1);
                }
                if (preFilter != null && afterFilter != null) continue;
                if (preFilter == null && afterFilter != null) {
                    oldFilter.clearTarget();
                    this.removeInitialFilter(oldFilter);
                    this.registerTerminalFilter(newFilter);
                    newFilter.addTarget((GLTextureInputRenderer)afterFilter);
                    continue;
                }
                if (afterFilter == null && preFilter != null) {
                    preFilter.clearTarget();
                    oldFilter.clearTarget();
                    this.removeTerminalFilter(oldFilter);
                    this.registerTerminalFilter(newFilter);
                    preFilter.addTarget((GLTextureInputRenderer)newFilter);
                    newFilter.addTarget((GLTextureInputRenderer)this);
                    continue;
                }
                if (preFilter == null || afterFilter == null) continue;
                preFilter.removeTarget((GLTextureInputRenderer)oldFilter);
                oldFilter.removeTarget((GLTextureInputRenderer)afterFilter);
                this.removeFilter(oldFilter);
                this.registerFilter(newFilter);
                preFilter.addTarget((GLTextureInputRenderer)newFilter);
                newFilter.addTarget((GLTextureInputRenderer)afterFilter);
            }
            if (!inFiltersList) {
                return false;
            }
            if (oldFilter instanceof FaceDetectInterface) {
                this.faceDetectGroupFilters.remove(oldFilter);
            }
            if (newFilter instanceof FaceDetectInterface) {
                this.faceDetectGroupFilters.add((FaceDetectInterface)newFilter);
            }
            this.mFilters.remove(oldFilter);
            this.mFilters.add(newFilter);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEndFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            List terminalFilters;
            if (this.mFilters.size() > 0 && filter != null && (terminalFilters = this.getTerminalFilters()).size() == 1) {
                BasicFilter oldEndFilter = (BasicFilter)terminalFilters.get(0);
                this.removeTerminalFilter(oldEndFilter);
                this.registerFilter(oldEndFilter);
                oldEndFilter.clearTarget();
                oldEndFilter.addTarget((GLTextureInputRenderer)filter);
                filter.addTarget((GLTextureInputRenderer)this);
                this.registerTerminalFilter(filter);
                if (filter instanceof FaceDetectInterface) {
                    this.faceDetectGroupFilters.add((FaceDetectInterface)filter);
                }
                this.mFilters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (FaceDetectInterface faceDetectGroupFilter : this.faceDetectGroupFilters) {
                faceDetectGroupFilter.setMMCVInfo(mmcvInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimeStamp(long ms) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (BasicFilter filter : this.mFilters) {
                if (!(filter instanceof IVideoTrackTime)) continue;
                ((IVideoTrackTime)filter).setTimeStamp(ms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<BasicFilter> resetFilters(List<BasicFilter> filters) {
        Object object = this.getLockObject();
        synchronized (object) {
            ArrayList<BasicFilter> arrayList = new ArrayList<BasicFilter>(this.mFilters);
            this.destructGroupFilter();
            this.constructGroupFilter(filters);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPlayStatusChangeListener(MStickerActions.onPlayStatusListener listener) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (BasicFilter filter : this.mFilters) {
                if (!(filter instanceof StickerAdjustFilter)) continue;
                ((StickerAdjustFilter)filter).setplayStatusListener(listener);
            }
        }
    }

    public void updateFrameInfo(Frame frame, Session session) {
        for (int i = 0; i < this.faceDetectGroupFilters.size(); ++i) {
            if (!(this.faceDetectGroupFilters.get(i) instanceof ARCoreInterface)) continue;
            ((ARCoreInterface)this.faceDetectGroupFilters.get(i)).updateFrameInfo(frame, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFilterFromLine(BasicFilter removeFilter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (removeFilter == null) {
                return;
            }
            for (int i = 0; i < this.mFilters.size(); ++i) {
                BasicFilter filter = this.mFilters.get(i);
                BasicFilter preFilter = null;
                BasicFilter afterFilter = null;
                if (filter != removeFilter) continue;
                if (i > 0) {
                    preFilter = this.mFilters.get(i - 1);
                }
                if (i + 1 < this.mFilters.size()) {
                    afterFilter = this.mFilters.get(i + 1);
                }
                if (preFilter == null && afterFilter != null) {
                    filter.clearTarget();
                    this.removeInitialFilter(filter);
                    this.registerInitialFilter(afterFilter);
                } else if (afterFilter == null && preFilter != null) {
                    preFilter.clearTarget();
                    filter.clearTarget();
                    this.removeTerminalFilter(filter);
                    this.registerTerminalFilter(preFilter);
                    preFilter.addTarget((GLTextureInputRenderer)this);
                } else if (preFilter != null && afterFilter != null) {
                    preFilter.removeTarget((GLTextureInputRenderer)filter);
                    filter.removeTarget((GLTextureInputRenderer)afterFilter);
                    this.removeFilter(filter);
                    preFilter.addTarget((GLTextureInputRenderer)afterFilter);
                }
                this.mFilters.remove(filter);
                if (this.destroyList == null) continue;
                this.destroyList.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mFilters.size() > 0 && filter != null) {
                List initFilters = this.getInitialFilters();
                if (initFilters.size() == 1) {
                    BasicFilter oldHeadFilter = (BasicFilter)initFilters.get(0);
                    this.removeInitialFilter(oldHeadFilter);
                    this.registerInitialFilter(filter);
                    filter.clearTarget();
                    filter.addTarget((GLTextureInputRenderer)oldHeadFilter);
                    this.registerFilter(oldHeadFilter);
                    this.mFilters.add(0, filter);
                }
            } else {
                this.registerInitialFilter(filter);
                filter.addTarget((GLTextureInputRenderer)this);
                this.registerTerminalFilter(filter);
                this.mFilters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.newTextureReady(texture, source, newData);
            if (this.destroyList.size() > 0) {
                this.doDestroyFilters();
            }
        }
    }

    private void doDestroyFilters() {
        for (BasicFilter filter : this.destroyList) {
            filter.destroy();
        }
        this.destroyList.clear();
    }

    public synchronized void addFilterToDestroy(BasicFilter removeFilter) {
        if (this.mFilters.contains(removeFilter)) {
            this.mFilters.remove(removeFilter);
        }
        if (this.destroyList != null) {
            this.destroyList.add(removeFilter);
        }
    }
}

