/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.GLFaceBlendProgram;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class FaceBlushFilter
extends BasicFilter
implements FaceDetectInterface {
    private int maskTexture = 0;
    private String mImagePath = null;
    private MMCVInfo mMmcvInfo = null;
    private boolean bitMapChanged = false;
    private GLFaceBlendProgram glFaceBlendProgram = new GLFaceBlendProgram();

    public FaceBlushFilter() {
        if (this.glFaceBlendProgram != null) {
            this.glFaceBlendProgram.setDrawType(4);
            this.glFaceBlendProgram.setBlendType("Normal");
        }
    }

    public void setImagePath(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.mImagePath = path;
        this.bitMapChanged = true;
    }

    public void setIntensity(float value) {
        if (this.glFaceBlendProgram != null) {
            this.glFaceBlendProgram.setIntensity(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            if ((this.maskTexture == 0 || this.bitMapChanged) && !TextUtils.isEmpty((CharSequence)this.mImagePath)) {
                MMFrameInfo mmcvImage = new MMFrameInfo();
                ImageUtils.decodeMMCVImage((MMFrameInfo)mmcvImage, (String)this.mImagePath);
                if (mmcvImage.getDataPtr() != null && mmcvImage.getWidth() > 0 && mmcvImage.getHeight() > 0) {
                    this.maskTexture = this.maskTexture == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mmcvImage) : TextureHelper.loadDataToTexture((int)this.maskTexture, (MMFrameInfo)mmcvImage);
                }
                this.bitMapChanged = false;
            }
            super.newTextureReady(texture, source, newData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = mmcvInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        super.drawSub();
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
                for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                    if (this.glFaceBlendProgram == null || this.maskTexture == 0) continue;
                    int[] texture = new int[]{this.texture_in, this.maskTexture};
                    float[][] array = AIFaceTriangulation.getFaceTriangulation(this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight()));
                    this.glFaceBlendProgram.drawFrame(array, texture);
                }
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.maskTexture != 0) {
            int[] textureArray = new int[]{this.maskTexture};
            GLES20.glDeleteTextures((int)1, (int[])textureArray, (int)0);
            this.maskTexture = 0;
        }
    }

    private float[] landMark104ToPoint(float[] landmarks104, float width, float height) {
        float[] resultArray = new float[landmarks104.length];
        int size = landmarks104.length;
        for (int i = 0; i < size / 2; ++i) {
            resultArray[i] = landmarks104[i] / width;
            resultArray[i + size / 2] = landmarks104[i + size / 2] / height;
        }
        return resultArray;
    }
}

