/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.text.TextUtils;
import android.view.Display;
import com.core.glcore.config.Size;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.datadot.DataDotUtils;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.core.glcore.util.XEFaceInfoHelper;
import com.cosmos.mdlog.MDLog;
import com.mm.mmutil.task.ThreadUtils;
import com.momo.mcamera.mask.AdditionalInfo;
import com.momo.mcamera.mask.Capture3DImageListener;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.util.ArCoreHelper;
import com.momo.render.SharedExecutor;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.bean.CVSegmentInfo;
import com.momo.xeengine.xnative.XESegment;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class Face3DMaskFilter
extends FaceDetectFilter {
    private String rendertaskName;
    private String sceneId;
    private Sticker sticker;
    MMCVInfo mmcvInfo;
    private boolean inited = false;
    private boolean needFaceDetect = true;
    private int antialias = 1;
    private int frameCounter = 0;
    private boolean isCameraFront = false;
    private static boolean forbiddenRender = false;
    private WeakReference<Context> mContext = null;
    static boolean autoRender = false;
    private boolean isCapture = false;
    private boolean isDrawBackGround = true;
    private Capture3DImageListener mCapture3DImageListener = null;
    private Rect mCaptureRect = null;
    private Display mDisplay;
    private int w;
    private int h;
    private AdditionalInfo mAdditionalInfo = null;
    int textureId;
    private SharedExecutor.OnRenderCallback mCallback;
    MMFrameInfo mmcvFrame = new MMFrameInfo();
    MMParamsInfo params = new MMParamsInfo(4);

    public static void SetAutoRender(boolean enable) {
        autoRender = enable;
    }

    public Face3DMaskFilter(Sticker sticker, boolean isCameraFront, Context context) {
        this.isCameraFront = isCameraFront;
        this.mContext = new WeakReference<Context>(context);
        this.sticker = sticker;
        this.loadScene(sticker);
        this.rendertaskName = ((Object)((Object)this)).toString();
    }

    public void setCamera(boolean isFront) {
        if (this.isCameraFront != isFront) {
            this.isCameraFront = isFront;
            this.frameCounter = 0;
        }
    }

    public boolean needFaceDetect() {
        return this.needFaceDetect || FacerigHelper.isUseFacerig();
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.needFaceDetect()) {
            this.mmcvInfo = mmcvInfo;
            XEFaceInfoHelper.setFaceInfo((MMCVInfo)this.mmcvInfo);
        }
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    public void destroy() {
        super.destroy();
        if (ArCoreHelper.getInstance().isUseARCore()) {
            ArCoreHelper.getInstance().unRegisterARCoreListener();
        }
        if (!TextUtils.isEmpty((CharSequence)this.sceneId)) {
            XE3DEngine.getInstance().unloadScene(this.sceneId);
            this.sceneId = null;
        }
        SharedExecutor.getInstance().removeTask(this.rendertaskName);
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.inited = false;
        this.isCameraFront = false;
        this.mmcvInfo = null;
        this.antialias = 1;
        this.frameCounter = 0;
        if (ArCoreHelper.getInstance().isUseARCore()) {
            ArCoreHelper.getInstance().unRegisterARCoreListener();
        }
        SharedExecutor.getInstance().removeTask(this.rendertaskName);
        this.mCallback = null;
        this.loadScene(this.sticker);
    }

    public void resetArInfo() {
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        super.newTextureReady(texture, (GLTextureOutputRenderer)this, newData);
    }

    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
        this.glFrameBuffer.activityFrameBuffer(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException((Object)((Object)this) + ": Failed to set up render buffer with status " + status + " and error " + GLES20.glGetError());
        }
    }

    public static boolean is3DRenderReady() {
        return true;
    }

    protected void drawBgFrame() {
        GLES20.glViewport((int)0, (int)0, (int)(this.width * this.antialias), (int)(this.height * this.antialias));
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
    }

    public void drawSub() {
        this.isDrawBackGround = !this.isCapture;
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glEnable((int)3089);
        GLES20.glFinish();
        long start = System.currentTimeMillis();
        final int width = this.getWidth() * this.antialias;
        final int height = this.getHeight() * this.antialias;
        if (!this.inited) {
            this.inited = true;
            final Context ctx = (Context)this.mContext.get();
            if (ctx != null) {
                XE3DEngine.getInstance().init(ctx);
            }
            SharedExecutor.getInstance().init(EGL14.eglGetCurrentContext());
            if (this.mCallback == null) {
                this.mCallback = new SharedExecutor.OnRenderCallback(){

                    public void onTextureCreated(String name, int textureId) {
                        Face3DMaskFilter.this.textureId = textureId;
                        XE3DEngine.getInstance().init(ctx);
                        XE3DEngine.getInstance().runEngine();
                        XE3DEngine.getInstance().clearBackground();
                        XE3DEngine.getInstance().enableClearColor(false);
                        if (!autoRender) {
                            XE3DEngine.getInstance().loadSceneWithId(Face3DMaskFilter.this.sticker.getXengineResRelativePath(), Face3DMaskFilter.this.sceneId);
                            DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraEnable3DXengine(true);
                        }
                    }

                    public int getBgTexture() {
                        return Face3DMaskFilter.this.isDrawBackGround ? Face3DMaskFilter.this.texture_in : 0;
                    }

                    public void onRender(String name) {
                        XE3DEngine.getInstance().resizeWindow(width, height);
                        if (autoRender) {
                            XE3DEngine.getInstance().render();
                        } else {
                            XE3DEngine.getInstance().render(Face3DMaskFilter.this.sceneId);
                        }
                        GLES20.glFinish();
                    }
                };
            }
            SharedExecutor.getInstance().addRenderTask(this.rendertaskName, width, height, this.mCallback);
            SharedExecutor.getInstance().startRender();
        }
        if (ArCoreHelper.getInstance().getSession() != null && ArCoreHelper.getInstance().getFrame() != null) {
            ArCoreHelper.getInstance().updateCameraMatrix();
        }
        SharedExecutor.getInstance().render(this.rendertaskName);
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)3089);
        if (this.textureId > 0) {
            this.drawEngineFrame();
        }
        if (this.isCapture && !this.isDrawBackGround) {
            this.get3DRenderImage();
        }
        MDLog.v((String)"FaceRig", (String)("draw : " + (System.currentTimeMillis() - start)));
    }

    private void drawEngineFrame() {
        GLES20.glViewport((int)0, (int)0, (int)(this.width * this.antialias), (int)(this.height * this.antialias));
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        this.passEngineFrameValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
    }

    private void passEngineFrameValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textureId);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        if (this.mAdditionalInfo != null && this.mAdditionalInfo.isBodySegmentDetectEnable()) {
            this.processSegment();
        }
    }

    void loadScene(Sticker sticker) {
        int n = this.antialias = sticker.isEnable3DAntialiasing() ? 2 : 1;
        if (this.sceneId == null) {
            this.sceneId = sticker.getXengineResRelativePath() + "_" + System.currentTimeMillis();
        }
        if (ArCoreHelper.getInstance().isUseARCore()) {
            ArCoreHelper.getInstance().registerARCoreListener();
        }
    }

    public void setCapture(boolean isCapture, Rect rect) {
        this.isCapture = isCapture;
        this.mCaptureRect = rect;
    }

    public void setCapture3DImageListener(Capture3DImageListener capture3DImageListener) {
        this.mCapture3DImageListener = capture3DImageListener;
    }

    private void get3DRenderImage() {
        ByteBuffer PixelBuffer;
        if (this.mCaptureRect != null) {
            this.w = this.mCaptureRect.right - this.mCaptureRect.left;
            this.h = this.mCaptureRect.bottom - this.mCaptureRect.top;
            int x = this.mCaptureRect.left;
            int y = this.height - this.mCaptureRect.top - this.h;
            PixelBuffer = ByteBuffer.allocate(this.w * this.h * 4);
            PixelBuffer.position(0);
            GLES20.glReadPixels((int)x, (int)y, (int)this.w, (int)this.h, (int)6408, (int)5121, (Buffer)PixelBuffer);
        } else {
            PixelBuffer = ByteBuffer.allocate(this.getWidth() * this.getHeight() * 4);
            PixelBuffer.position(0);
            GLES20.glReadPixels((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)6408, (int)5121, (Buffer)PixelBuffer);
        }
        PixelBuffer.position(0);
        this.isCapture = false;
        ThreadUtils.execute((int)2, (Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bmp = Face3DMaskFilter.this.mCaptureRect != null ? Bitmap.createBitmap((int)Face3DMaskFilter.this.w, (int)Face3DMaskFilter.this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)Face3DMaskFilter.this.width, (int)Face3DMaskFilter.this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)PixelBuffer);
                if (Face3DMaskFilter.this.mCapture3DImageListener != null) {
                    Matrix matrix = new Matrix();
                    matrix.postScale(1.0f, -1.0f);
                    matrix.postRotate(0.0f);
                    bmp = Face3DMaskFilter.this.mCaptureRect != null ? Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)Face3DMaskFilter.this.w, (int)Face3DMaskFilter.this.h, (Matrix)matrix, (boolean)true) : Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)Face3DMaskFilter.this.width, (int)Face3DMaskFilter.this.height, (Matrix)matrix, (boolean)true);
                    Face3DMaskFilter.this.mCapture3DImageListener.get3DRenderImage(bmp);
                }
            }
        });
    }

    public Size getViewPortSize() {
        Size size = new Size(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
        return size;
    }

    public Bitmap flushPicture(int degress) {
        int realWidth = 1;
        int realHeight = 1;
        if (realHeight > 0 && realWidth > 0) {
            IntBuffer Imc2Buf = IntBuffer.allocate(realWidth * realHeight);
            GLES20.glReadPixels((int)0, (int)0, (int)realWidth, (int)realHeight, (int)6408, (int)5121, (Buffer)Imc2Buf);
            return null;
        }
        return null;
    }

    private void processSegment() {
        if (this.mmcvInfo == null || this.mmcvInfo.frameData == null) {
            MDLog.e((String)"lclc", (String)"mmcv is null or mmcv.frameInfo is null");
            return;
        }
        this.mmcvFrame.setFormat(17);
        this.mmcvFrame.setDataPtr(this.mmcvInfo.frameData);
        this.mmcvFrame.setDataLen(this.mmcvInfo.frameData.length);
        this.mmcvFrame.setWidth(this.mmcvInfo.getWidth());
        this.mmcvFrame.setHeight(this.mmcvInfo.getHeight());
        this.mmcvFrame.setStep_(this.mmcvInfo.getWidth());
        this.params.setFlipedShow(SegmentHelper.isFrontCamera());
        this.params.setRotateDegree(SegmentHelper.getRotateDegree());
        this.params.setRestoreDegree(SegmentHelper.getRestoreDegree());
        byte[] buffer = SegmentHelper.process((MMFrameInfo)this.mmcvFrame, (MMParamsInfo)this.params);
        CVSegmentInfo info = new CVSegmentInfo();
        info.setDatas(buffer);
        info.setHeight(this.mmcvFrame.getWidth());
        info.setWidth(this.mmcvFrame.getHeight());
        info.setLength(buffer.length);
        XESegment.setSegmentInfo((CVSegmentInfo)info);
    }

    public void setAdditionalInfo(AdditionalInfo additionalInfo) {
        this.mAdditionalInfo = additionalInfo;
    }
}

