/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.CXTwoPassFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class CXFaceSkinSmoothFilter
extends CXTwoPassFilter
implements FaceDetectInterface {
    private static final String UNIFORM_EPSLONE = "epslone";
    private static final String UNIFORM_CX_SKIN_SMOOTHING_USES_MASK = "cxSkinSmoothingUsesMask";
    private static final String UNIFORM_CX_SKIN_SMOOTHING_CONSIDERS_SKIN_RELATION = "cxSkinSmoothingConsidersSkinRelation";
    private static final String UNIFORM_SAMPLE_STEP = "sampleStep";
    private static final String UNIFORM_LAND = "land";
    private static final String UNIFORM_WINSIZE = "winSize";
    private int mWinSize = 6;
    public static final int STEP_FIRST = 1;
    public static final int STEP_SECOND = 2;
    private static final int TYPE_FULL_SCREEN = 0;
    private static final int TYPE_NORMAL = 1;
    private static final int TYPE_HD = 2;
    private int[] mLowSkinThreshold = new int[]{0, 0, 0};
    private int[] mHighSkinThreshold = new int[]{255, 255, 255};
    private int[] mDefaultSkinThreshold = new int[]{160, 120, 110};
    private float mMMCVWidth = 0.0f;
    private int mCxSkinSmoothingUsesMask = 0;
    private int mCxSkinSmoothingConsidersSkinRelation = 0;
    private float[] mEpslone = new float[3];
    private float[] mSampleStep = new float[2];
    private float step = 0.0f;
    private float mFaceWidth = 0.0f;
    private int maskTexture = 0;
    private String maskPath = null;
    private int maskTextureHandle = 0;
    private int maskTexCoordHandle = 0;
    private int mDefaultSkinThresholdHandle = 0;
    private int mEpsloneHandle = 0;
    private int mCxSkinSmoothingUsesMaskHandle = 0;
    private int mCxSkinSmoothingConsidersSkinRelationHandle = 0;
    private int mSampleStepHandle = 0;
    private int mLandHandle = 0;
    private int mWinSizeHandle = 0;
    private List<SkinFaceBuffer> skinBuffers = new ArrayList<SkinFaceBuffer>(3);
    private int mType = 1;
    public int skinStep = 1;
    private int land = this.currentPass;
    private MMCVInfo mMmcvInfo;
    private float mDermabrasion = 0.0f;
    private float mEyesAreaAmount = 0.0f;
    private int textureId = -1;
    private int textureInId = -1;
    private int textureBeforeId = -1;
    private boolean isDiscard = false;

    public CXFaceSkinSmoothFilter() {
        this.init(6);
    }

    private void init(int winSize) {
        this.mWinSize = winSize;
        this.mLowSkinThreshold[0] = 0;
        this.mLowSkinThreshold[1] = 0;
        this.mLowSkinThreshold[2] = 0;
        this.mHighSkinThreshold[0] = 255;
        this.mHighSkinThreshold[1] = 255;
        this.mHighSkinThreshold[2] = 255;
        for (int i = 0; i < 3; ++i) {
            this.skinBuffers.add(new SkinFaceBuffer());
        }
    }

    protected String getVertexShader() {
        String vertexShader = "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nattribute vec2 inputTextureCoordinate1;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n  textureCoordinate1 = inputTextureCoordinate1;\n   gl_Position = position;\n}\n";
        return vertexShader;
    }

    protected String getFragmentShader() {
        String fragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec3 skinDefaultRGB;\nuniform vec3 epslone;\nuniform int cxSkinSmoothingUsesMask;\nuniform int cxSkinSmoothingConsidersSkinRelation;\nuniform int land;\nuniform vec2 sampleStep;\nuniform int winSize;\nvoid main() {\n    mediump vec4 meanI = vec4(0., 0., 0., 0.);\n    mediump vec4 meanII = vec4(0., 0., 0., 0.);\n    mediump vec4 temp = vec4(0., 0., 0., 0.);\n    mediump vec4 sourceColor = texture2D(inputImageTexture0,textureCoordinate);\n    float eps = epslone.r;\n    if (cxSkinSmoothingUsesMask > 0) {\n            vec4 mask = texture2D(inputImageTexture1,textureCoordinate1);\n            eps = dot(epslone, vec3(mask.rgb));\n    };\n    if (cxSkinSmoothingConsidersSkinRelation > 0) {\n            vec3 relation = vec3(1.) + min((sourceColor.xyz - vec3(skinDefaultRGB)), vec3(0.0));\n            float meanrelation = dot(relation, vec3(1.0/3.0));\n            float r = 1.0 / (1.0 + exp(24.0 - 30.0 * meanrelation));\n            eps = eps * r;\n        }\n    if (eps < 0.000001) {\n         gl_FragColor = sourceColor;\n         return;\n    }\n    mediump float sumW = 0.0;\n    float xInc = sampleStep.x;\n    float yInc = sampleStep.y;\n    if(land == 1){\n    float x = textureCoordinate.x + (-float(winSize) * 0.5 * xInc);\n    float y = textureCoordinate.y;\n         int j = 0;\n         for (int i = 0; i < winSize; i++) {\n             temp = texture2D(inputImageTexture0, vec2(x + float(i) * xInc, y));\n             vec3 weightsRelation = clamp((vec3(1.0) - vec3(5.0) * abs(temp.xyz - sourceColor.xyz)), vec3(0.0), vec3(1.0));\n             mediump float weightFloat = dot(weightsRelation, vec3(1.0/3.0));\n             sumW += weightFloat;\n             meanI += weightFloat * temp;\n             meanII += weightFloat * temp * temp;\n         }\n    }else{\n    float x = textureCoordinate.x;\n    float y = textureCoordinate.y + (-float(winSize) * 0.5 * yInc);\n          int i = 0;\n          for (int j = 0; j < winSize; j++) {\n              temp = texture2D(inputImageTexture0, vec2(x, y + float(j) * yInc));\n              vec3 weightsRelation = clamp((vec3(1.0) - vec3(5.0) * abs(temp.xyz - sourceColor.xyz)), vec3(0.0), vec3(1.0));\n              mediump float weightFloat = dot(weightsRelation, vec3(1.0/3.0));\n              sumW += weightFloat;\n              meanI += weightFloat * temp;\n              meanII += weightFloat * temp * temp;\n          }\n    }\n    meanI /= sumW;\n    meanII /= sumW;\n    temp = meanII - meanI * meanI;\n    vec3 a = clamp((vec4(temp) / (vec4(temp) + vec4(vec3(eps), 1.0))), vec4(0.0), vec4(1.0)).rgb;\n    vec3 b = vec4(meanI).rgb - a * vec4(meanI).rgb;\n    gl_FragColor = vec4(a * sourceColor.rgb + b,sourceColor.a);\n}\n";
        return fragmentShader;
    }

    private float CXSkinSmoothingEpsloneForAmount(float amount) {
        return 0.005f * amount * amount;
    }

    private float CXSkinSmoothingEpsloneForMaskAmount(float amount) {
        return 0.01f * amount * amount;
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.maskTexCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"inputTextureCoordinate1");
        this.maskTextureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture1");
        this.mDefaultSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinDefaultRGB");
        this.mEpsloneHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_EPSLONE);
        this.mCxSkinSmoothingUsesMaskHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CX_SKIN_SMOOTHING_USES_MASK);
        this.mCxSkinSmoothingConsidersSkinRelationHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CX_SKIN_SMOOTHING_CONSIDERS_SKIN_RELATION);
        this.mSampleStepHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SAMPLE_STEP);
        this.mLandHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LAND);
        this.mWinSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WINSIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)"inputTextureCoordinate1");
    }

    private void faceDisableDrawArray() {
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glDisableVertexAttribArray((int)this.maskTexCoordHandle);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private void facePassShaderValues() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        if (this.mCxSkinSmoothingUsesMask > 0) {
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)this.maskTexture);
            GLES20.glUniform1i((int)this.maskTextureHandle, (int)1);
        }
        this.land = this.currentPass - 1;
        GLES20.glUniform1i((int)this.mLandHandle, (int)this.land);
        GLES20.glUniform1i((int)this.mWinSizeHandle, (int)this.mWinSize);
        GLES20.glUniform3f((int)this.mDefaultSkinThresholdHandle, (float)((float)this.mDefaultSkinThreshold[0] / 255.0f), (float)((float)this.mDefaultSkinThreshold[1] / 255.0f), (float)((float)this.mDefaultSkinThreshold[2] / 255.0f));
        GLES20.glUniform1i((int)this.mCxSkinSmoothingUsesMaskHandle, (int)this.mCxSkinSmoothingUsesMask);
        GLES20.glUniform1i((int)this.mCxSkinSmoothingConsidersSkinRelationHandle, (int)this.mCxSkinSmoothingConsidersSkinRelation);
        GLES20.glUniform3f((int)this.mEpsloneHandle, (float)this.mEpslone[0], (float)this.mEpslone[1], (float)this.mEpslone[2]);
        GLES20.glUniform2f((int)this.mSampleStepHandle, (float)this.mSampleStep[0], (float)this.mSampleStep[1]);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.maskTexture == 0 && !TextUtils.isEmpty((CharSequence)this.maskPath)) {
            MMFrameInfo mmcvImage = new MMFrameInfo();
            ImageUtils.decodeMMCVImage((MMFrameInfo)mmcvImage, (String)this.maskPath);
            this.maskTexture = TextureHelper.bitmapToTexture((MMFrameInfo)mmcvImage);
        }
        if (this.textureInId != -1 && this.textureId != -1 && this.textureBeforeId != -1 && (texture != this.textureId || this.textureBeforeId != texture)) {
            this.isDiscard = true;
        }
        this.textureBeforeId = this.textureId;
        this.textureId = texture;
        this.textureInId = this.texture_in;
        super.newTextureReady(texture, source, newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = mmcvInfo;
            this.mLowSkinThreshold[0] = 0;
            this.mLowSkinThreshold[1] = 0;
            this.mLowSkinThreshold[2] = 0;
            this.mHighSkinThreshold[0] = 255;
            this.mHighSkinThreshold[1] = 255;
            this.mHighSkinThreshold[2] = 255;
            this.mDefaultSkinThreshold[0] = 160;
            this.mDefaultSkinThreshold[1] = 120;
            this.mDefaultSkinThreshold[2] = 110;
            this.mMMCVWidth = mmcvInfo.restoreDegree % 90 == 0 && mmcvInfo.restoreDegree % 180 != 0 ? (float)mmcvInfo.height : (float)mmcvInfo.width;
        }
    }

    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        this.facePassShaderValues();
    }

    private void setParamters(int type, int skinRelation, int usesMask, float faceWidth, float amount, float eyesAreaAmount) {
        switch (type) {
            case 0: {
                this.mWinSize = 4;
                this.step = 3.0f;
                break;
            }
            case 1: {
                this.mWinSize = 10;
                this.step = 3.0f;
                break;
            }
            case 2: {
                this.mWinSize = 12;
                this.step = 1.7f;
                break;
            }
        }
        this.mCxSkinSmoothingConsidersSkinRelation = skinRelation;
        this.mCxSkinSmoothingUsesMask = usesMask;
        this.mFaceWidth = faceWidth;
        float faceWidthFactor = this.mFaceWidth / 360.0f;
        float xInc = this.step / (float)this.width * faceWidthFactor;
        float yInc = this.step / (float)this.height * faceWidthFactor;
        this.mSampleStep[0] = xInc;
        this.mSampleStep[1] = yInc;
        float eps = 0.0f;
        if (usesMask > 0) {
            this.mEpslone[0] = this.CXSkinSmoothingEpsloneForMaskAmount(eyesAreaAmount);
            this.mEpslone[1] = this.CXSkinSmoothingEpsloneForMaskAmount(this.getNasolabialFoldAreaAmount(amount));
            this.mEpslone[2] = 0.0f;
        } else {
            this.mEpslone[0] = eps = this.CXSkinSmoothingEpsloneForAmount(amount);
            this.mEpslone[1] = eps;
            this.mEpslone[2] = eps;
        }
    }

    private float getNasolabialFoldAreaAmount(float value) {
        return Math.min(0.5f, Math.max(0.0f, value - 0.5f)) * 2.0f;
    }

    public void drawSub() {
        if (this.isDiscard) {
            return;
        }
        switch (this.skinStep) {
            case 1: {
                float amount = Math.min(this.mDermabrasion, 0.3f);
                this.setParamters(0, 1, 0, (float)this.getWidth() / 2.0f, amount, 0.0f);
                super.drawSub();
                if (this.mMmcvInfo == null || this.mMmcvInfo.getMaxFaceCnt() <= 0) break;
                for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                    if (this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                    float[] pointlandmarks_104 = this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight());
                    float faceWidth = AIFaceTriangulation.getFaceTriangulationWidth(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), (float)this.width / this.mMMCVWidth);
                    this.setParamters(this.mType, 1, 0, faceWidth, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    float[][] array = AIFaceTriangulation.getFaceSkinHead(pointlandmarks_104, false);
                    float[] vertexCoord = array[0];
                    float[] textureCoord = array[1];
                    float[] sourceCoord = array[2];
                    this.drawFace(vertexCoord, textureCoord, sourceCoord, this.skinBuffers.get(0));
                    this.setParamters(this.mType, 1, 0, faceWidth, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    array = AIFaceTriangulation.getfaceSkinBelowHead(pointlandmarks_104, true);
                    vertexCoord = array[0];
                    textureCoord = array[1];
                    sourceCoord = array[2];
                    this.drawFace(vertexCoord, textureCoord, sourceCoord, this.skinBuffers.get(1));
                }
                break;
            }
            case 2: {
                this.setParamters(0, 1, 0, (float)this.getWidth() / 2.0f, 0.0f, 0.0f);
                super.drawSub();
                if (this.mMmcvInfo == null || this.mMmcvInfo.getMaxFaceCnt() <= 0) break;
                for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                    if (this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                    float[] pointlandmarks_104 = this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight());
                    float faceWidth = AIFaceTriangulation.getFaceTriangulationWidth(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), (float)this.width / this.mMMCVWidth);
                    this.setParamters(this.mType, 1, 0, faceWidth, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    float[][] array = AIFaceTriangulation.getFaceSkinHead(pointlandmarks_104, false);
                    float[] vertexCoord = array[0];
                    float[] textureCoord = array[1];
                    float[] sourceCoord = array[2];
                    this.drawFace(vertexCoord, textureCoord, sourceCoord, this.skinBuffers.get(2));
                }
                break;
            }
        }
    }

    private void drawFace(float[] vertexCoord, float[] textureCoord, float[] sourceCoord, SkinFaceBuffer skinBuffer) {
        if (skinBuffer.byteBufVer == null) {
            skinBuffer.byteBufVer = ByteBuffer.allocateDirect(vertexCoord.length * 4);
            skinBuffer.byteBufVer.order(ByteOrder.nativeOrder());
        }
        if (skinBuffer.bufferVer == null) {
            skinBuffer.bufferVer = skinBuffer.byteBufVer.asFloatBuffer();
        }
        skinBuffer.bufferVer.clear();
        skinBuffer.bufferVer.put(vertexCoord);
        skinBuffer.bufferVer.flip();
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferVer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (skinBuffer.byteBufTex == null) {
            skinBuffer.byteBufTex = ByteBuffer.allocateDirect(textureCoord.length * 4);
            skinBuffer.byteBufTex.order(ByteOrder.nativeOrder());
        }
        if (skinBuffer.bufferTex == null) {
            skinBuffer.bufferTex = skinBuffer.byteBufTex.asFloatBuffer();
        }
        skinBuffer.bufferTex.clear();
        skinBuffer.bufferTex.put(textureCoord);
        skinBuffer.bufferTex.flip();
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferTex);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        if (this.mCxSkinSmoothingUsesMask > 0) {
            if (skinBuffer.byteBufSource == null) {
                skinBuffer.byteBufSource = ByteBuffer.allocateDirect(textureCoord.length * 4);
                skinBuffer.byteBufSource.order(ByteOrder.nativeOrder());
            }
            if (skinBuffer.bufferSource == null) {
                skinBuffer.bufferSource = skinBuffer.byteBufSource.asFloatBuffer();
            }
            skinBuffer.bufferSource.clear();
            skinBuffer.bufferSource.put(sourceCoord);
            skinBuffer.bufferSource.flip();
            GLES20.glVertexAttribPointer((int)this.maskTexCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferSource);
            GLES20.glEnableVertexAttribArray((int)this.maskTexCoordHandle);
        }
        GLES20.glDrawArrays((int)4, (int)0, (int)(textureCoord.length / 2));
        this.faceDisableDrawArray();
    }

    public void destroy() {
        super.destroy();
        if (this.maskTexture != 0) {
            int[] textureArray = new int[]{this.maskTexture};
            GLES20.glDeleteTextures((int)1, (int[])textureArray, (int)0);
            this.maskTexture = 0;
        }
    }

    public void onDrawFrame() {
        super.onDrawFrame();
    }

    public void setSkinParameter(float dermabrasion, float eyesAreaAmount) {
        this.mDermabrasion = dermabrasion;
        this.mEyesAreaAmount = eyesAreaAmount;
    }

    public String getMaskPath() {
        return this.maskPath;
    }

    public void setMaskPath(String maskPath) {
        this.maskPath = maskPath;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int mType) {
        this.mType = mType;
    }

    private float[] landMark104ToPoint(float[] landmarks104, float width, float height) {
        float[] resultArray = new float[landmarks104.length];
        int size = landmarks104.length;
        for (int i = 0; i < size / 2; ++i) {
            resultArray[i] = landmarks104[i] / width;
            resultArray[i + size / 2] = landmarks104[i + size / 2] / height;
        }
        return resultArray;
    }

    public class SkinFaceBuffer {
        private ByteBuffer byteBufVer = null;
        private FloatBuffer bufferVer = null;
        private ByteBuffer byteBufTex = null;
        private FloatBuffer bufferTex = null;
        private ByteBuffer byteBufSource = null;
        private FloatBuffer bufferSource = null;

        public String toString() {
            return "SkinFaceBuffer{byteBufVer=" + this.byteBufVer + ", bufferVer=" + this.bufferVer + ", byteBufTex=" + this.byteBufTex + ", bufferTex=" + this.bufferTex + ", byteBufSource=" + this.byteBufSource + ", bufferSource=" + this.bufferSource + '}';
        }
    }
}

