/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.os.Environment;
import com.core.glcore.datadot.RecoderDotUtil;
import com.core.glcore.util.FileUtil;
import com.momo.mcamera.mask.CXSkinWhiteningFilter;
import com.momo.mcamera.mask.FaceLightingFilter;
import com.momo.mcamera.mask.VersionType;
import com.momo.mcamera.util.CopyAssetsToSDCard;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import project.android.imageprocessing.filter.BasicFilter;

public class AISkinWhiteningFilter {
    private CXSkinWhiteningFilter mCXSkinWhiteningFilter;
    private FaceLightingFilter mFaceLightingFilter;
    private WeakReference<Context> mContext = null;
    private VersionType.CXSkinVersion mType;

    public BasicFilter getSkinWhiteningFilter(Context context, VersionType.CXSkinVersion type) {
        this.mContext = new WeakReference<Context>(context);
        this.mType = type;
        if (this.mType == VersionType.CXSkinVersion.VersionType1) {
            String filterPath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "whitening.zip";
            String filterPathDest = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "whitening";
            if (FileUtil.exist((String)filterPath)) {
                FileUtil.deleteFile((String)filterPath);
            }
            CopyAssetsToSDCard.copyAssertFileToSDcard((Context)this.mContext.get(), "whitening.zip", filterPath);
            try {
                FileUtil.ZipUtil.decompress((String)filterPath, (String)filterPathDest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File nomeidiaFile = new File(filterPathDest, ".nomedia");
            if (!nomeidiaFile.exists()) {
                try {
                    nomeidiaFile.createNewFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mCXSkinWhiteningFilter = new CXSkinWhiteningFilter();
            ArrayList<String> pathList = new ArrayList<String>();
            String curvePath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "whitening" + File.separator + "cax_color_enhancement_curve.png";
            String lookupPath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "whitening" + File.separator + "cax_color_enhancement_lookup.png";
            pathList.add(curvePath);
            pathList.add(lookupPath);
            this.mCXSkinWhiteningFilter.setImagepath(pathList);
            return this.mCXSkinWhiteningFilter;
        }
        if (this.mType == VersionType.CXSkinVersion.VersionType2) {
            this.mFaceLightingFilter = new FaceLightingFilter(FaceLightingFilter.WhiteningVersionEnum._8version);
        } else if (this.mType == VersionType.CXSkinVersion.VersionType3) {
            this.mFaceLightingFilter = new FaceLightingFilter(FaceLightingFilter.WhiteningVersionEnum.originWhiten);
        }
        return this.mFaceLightingFilter;
    }

    public void setSkinLightLevel(float skinLevel) {
        RecoderDotUtil.getInstance().setWhitenValue(skinLevel);
        if (this.mType == VersionType.CXSkinVersion.VersionType1) {
            if (this.mCXSkinWhiteningFilter != null) {
                this.mCXSkinWhiteningFilter.setAlpha(skinLevel);
            }
        } else if (this.mFaceLightingFilter != null) {
            this.mFaceLightingFilter.setSkinLightingScale(skinLevel);
        }
    }
}

