/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.JsonUtil;
import com.momo.mcamera.filtermanager.MMFilterConfig;
import com.momo.mcamera.filtermanager.MMPresetFilter;
import com.momo.mcamera.filtermanager.MMProcessUnit;
import com.momo.mcamera.filtermanager.filterext.BitmapBlendFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import project.android.imageprocessing.filter.colour.LookupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.filter.effect.ColorHalftoneFilter;
import project.android.imageprocessing.filter.effect.DotScreenFilter;
import project.android.imageprocessing.filter.effect.SketchFilter;
import project.android.imageprocessing.filter.effect.TVArtifactFilter;
import project.android.imageprocessing.filter.glitter.GlitterFilter;
import project.android.imageprocessing.filter.processing.EyeEffectFilter;
import project.android.imageprocessing.filter.processing.SplitPersonFilter;
import project.android.imageprocessing.filter.processing.SplitPersonVerticalFilter;
import project.android.imageprocessing.filter.processing.WaterReflectionFilter;

public class MMPresetFilterStore {
    public static final String PATH_SHADER = "light_room_filters";

    public static String getFilterFolder(Context context) {
        String path = MMPresetFilterStore.getDataFilterFolder(context);
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        return path;
    }

    public static String getDataFilterFolder(Context context) {
        return FileUtil.getCacheDirectory((Context)context).getPath();
    }

    public static List<MMPresetFilter> generateProcessFilters(Context context, String defaultPath) {
        ArrayList<MMPresetFilter> filterList = new ArrayList<MMPresetFilter>();
        String path = MMPresetFilterStore.getFilterFolder(context);
        Object[] folders = new File(path + "/" + defaultPath).listFiles();
        if (folders == null) {
            return filterList;
        }
        Arrays.sort(folders);
        for (Object folder : folders) {
            MMPresetFilter filter = MMPresetFilterStore.getPresetFilterByFolder(context, ((File)folder).getPath());
            if (null == filter) continue;
            filterList.add(filter);
        }
        return filterList;
    }

    public static MMPresetFilter getPresetFilterByFolder(Context context, String folderPath) {
        File folder = new File(folderPath);
        MMPresetFilter filter = new MMPresetFilter(context);
        filter.mFilterName = folder.getName();
        if (null == folder.list()) {
            return null;
        }
        MMPresetFilterStore.generateFilter(context, folder, filter);
        return filter;
    }

    public static void generateFilter(Context context, File folder, MMPresetFilter filter) {
        if (folder == null || folder.list() == null || folder.list().length == 0) {
            return;
        }
        List<String> folderList = Arrays.asList(folder.list());
        ArrayList<MMProcessUnit> units = new ArrayList<MMProcessUnit>();
        for (String folderListPath : folderList) {
            File classFile;
            File file;
            MMProcessUnit unit;
            if (folderListPath.contains("Lookup.png") || folderListPath.contains("lookup.png")) {
                unit = new MMProcessUnit(0);
                unit.setFilterName(LookupFilter.class.getName());
                unit.setTexturePath1(folder.getPath() + "/" + folderListPath);
                units.add(unit);
            } else if (folderListPath.contains("overlays")) {
                file = new File(folder.getPath() + "/overlays");
                if (file.exists()) {
                    File[] overlayFolders;
                    for (File overlayFile : overlayFolders = file.listFiles()) {
                        MMProcessUnit unit2;
                        String name = overlayFile.getName();
                        String[] namesArray = name.split("\\.");
                        if (namesArray.length != 3) continue;
                        String filterType = namesArray[1];
                        if (filterType.contains("Lookup")) {
                            unit2 = new MMProcessUnit(0);
                            unit2.setFilterName(LookupFilter.class.getName());
                            unit2.setTexturePath1(folder.getPath() + "/overlays/" + name);
                            units.add(unit2);
                            continue;
                        }
                        unit2 = new MMProcessUnit(0);
                        unit2.setFilterName(BitmapBlendFilter.class.getName());
                        HashMap<String, Object> unitMap = new HashMap<String, Object>();
                        unitMap.put("setBlendType", filterType);
                        unit2.setFilterMap(unitMap);
                        unit2.setTexturePath1(overlayFile.getAbsolutePath());
                        units.add(unit2);
                    }
                }
            } else if (folderListPath.contains("Classic.Dark.png")) {
                unit = new MMProcessUnit(0);
                unit.setFilterName(BitmapBlendFilter.class.getName());
                unit.setTexturePath1(folder.getPath() + "/Classic.Light.png");
                units.add(unit);
            } else if (folderListPath.contains("manifest.json")) {
                MMFilterConfig config;
                file = new File(folder.getPath() + "/manifest.json");
                String configContent = JsonUtil.getInstance().jsonStringFromFile(context, file.getAbsolutePath());
                if (!TextUtils.isEmpty((CharSequence)(configContent = configContent.trim())) && null != (config = (MMFilterConfig)JsonUtil.buildInGson().fromJson(configContent, MMFilterConfig.class)) && null != config.getFilterExt()) {
                    for (MMProcessUnit unit3 : config.getFilterExt()) {
                        if (!TextUtils.isEmpty((CharSequence)unit3.getFilterName())) {
                            unit3.setFilterName(MMPresetFilterStore.convertClassName(unit3.getFilterName()));
                        }
                        units.add(unit3);
                        if (!unit3.isDecoration()) continue;
                        unit3.setResourceName(folder.getPath() + "/" + unit3.getResourceName());
                    }
                    if (!TextUtils.isEmpty((CharSequence)config.getDisplayName())) {
                        filter.mFilterName = config.getDisplayName();
                    }
                }
            } else if (folderListPath.contains("Classic.Light.png") && (classFile = new File(folder.getPath() + "/Classic.Light.png")).exists() && classFile.length() > 0L) {
                MMProcessUnit unit4 = new MMProcessUnit(0);
                unit4.setFilterName(BitmapBlendFilter.class.getName());
                unit4.setTexturePath1(classFile.getAbsolutePath());
                units.add(unit4);
            }
            if (folderListPath.length() != 0) continue;
            unit = new MMProcessUnit(0);
            unit.setFilterName(NormalFilter.class.getName());
            units.add(unit);
        }
        filter.setProcessUnits(units);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapWithPath(String path, Context context) {
        InputStream is2 = null;
        Bitmap bitMap = null;
        try {
            is2 = context.getResources().getAssets().open(path);
            bitMap = BitmapFactory.decodeStream((InputStream)is2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bitMap;
    }

    public static String convertClassName(String name) {
        if (name.equals("SketchFilter")) {
            return SketchFilter.class.getName();
        }
        if (name.equals("GlitterFilter")) {
            return GlitterFilter.class.getName();
        }
        if (name.equals("TVArtifactFilter")) {
            return TVArtifactFilter.class.getName();
        }
        if (name.equals("DotScreenFilter")) {
            return DotScreenFilter.class.getName();
        }
        if (name.equals("ColorHalftoneFilter")) {
            return ColorHalftoneFilter.class.getName();
        }
        if (name.equals("EyeEffectFilter")) {
            return EyeEffectFilter.class.getName();
        }
        if (name.equals("SplitPersonVerticalFilter")) {
            return SplitPersonVerticalFilter.class.getName();
        }
        if (name.equals("SplitPersonFilter")) {
            return SplitPersonFilter.class.getName();
        }
        if (name.equals("WaterReflectionFilter")) {
            return WaterReflectionFilter.class.getName();
        }
        return name;
    }
}

