/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.dokibeauty;

import com.core.glcore.util.FileUtil;
import com.core.glcore.util.JsonUtil;
import com.cosmos.mdlog.MDLog;
import com.immomo.doki.media.FilterConfigHelper;
import com.immomo.doki.media.entity.MakeMetaData;
import com.immomo.doki.media.entity.MakeupLayer;
import java.io.File;
import java.util.ArrayList;

public class MakeupHelper {
    private static ArrayList<MakeupLayer> layerList = null;

    public static void parseMakeupResources(String path) {
        int i;
        File file = new File(path);
        File[] files = file.listFiles();
        if (files == null) {
            MDLog.e((String)"makeup", (String)"The makeup file is null !!!");
            return;
        }
        ArrayList<String> makeupList = new ArrayList<String>();
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            makeupList.add(files[i].getAbsolutePath());
        }
        layerList = new ArrayList();
        for (i = 0; i < makeupList.size(); ++i) {
            String layerId = (String)makeupList.get(i);
            String makeupLayerPath = layerId + "/";
            MakeupLayer makeupLayer = MakeupHelper.buildMakeupLayer(layerId, makeupLayerPath);
            layerList.add(makeupLayer);
            MDLog.e((String)"MMEdiaSDK", (String)("build make resouce id = " + makeupLayerPath));
        }
        MDLog.e((String)"MMEdiaSDK", (String)("chage bueautyMake layerList size is " + layerList.size()));
        FilterConfigHelper.getInstance().changeBeautyMakeup(layerList, 100);
    }

    public static void setMakeUpStrength(int strength) {
        FilterConfigHelper.getInstance().changeBeautyMakeup(layerList, strength);
    }

    private static MakeupLayer buildMakeupLayer(String id, String path) {
        MakeupLayer layer = new MakeupLayer();
        layer.setId(id);
        layer.setPath(path);
        File file = new File(path, "metadata.json");
        MakeMetaData makeMetaData = (MakeMetaData)JsonUtil.getInstance().fromJson(FileUtil.readString((File)file), MakeMetaData.class);
        layer.setMetaData(makeMetaData);
        layer.setMaxValue(0.5f);
        return layer;
    }

    public static void clearMakeupLayer() {
        FilterConfigHelper.getInstance().clearMakeupLayer();
    }

    public static void destroyMakeResource() {
        FilterConfigHelper.getInstance().destroy();
    }
}

