/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoprocess;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.view.Surface;
import com.core.glcore.util.FileUtil;
import com.momo.mcamera.videoencoder.ProcessParam;
import com.momo.mcamera.videoencoder.ProcessSurface;
import com.momo.mcamera.videoprocess.VideoProcessListener;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.YUVFileEndpoint;

@TargetApi(value=14)
public class VideoResourceProcessInput
extends GLTextureOutputRenderer
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String LOG_TAG = "VideoResourceProcessInput";
    private static final String UNIFORM_CAM_MATRIX = "u_Matrix";
    VideoThread player;
    Surface surface;
    YUVFileEndpoint yuvFileEndpoint;
    private SurfaceTexture videoTex;
    private GLSurfaceView view;
    private String videoPath;
    private int matrixHandle;
    private float[] matrix = new float[16];
    private boolean startWhenReady = false;
    private boolean ready = false;
    private volatile long mCurTimestamp = -100L;
    private volatile int mFrameIndex;
    private volatile int mFinishFrameIndex;
    private volatile boolean isProcess;
    private VideoProcessListener processListener;
    private volatile boolean recordVideo = true;
    private int frameSize = 0;
    private ProcessSurface processSurface;
    private MediaCodec.BufferInfo currentBufferInfo;
    private ProcessParam processParam;
    private SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener;
    private long renderTime = 0L;
    private int mFrameRate = -1;
    int addIndex = 0;

    public void setFrameRate(int mFrameRate) {
        this.mFrameRate = mFrameRate;
    }

    public VideoResourceProcessInput(ProcessParam processParam, ProcessSurface processSurface) {
        this.processParam = processParam;
        this.videoPath = processParam.getVideoPath();
        this.processSurface = processSurface;
        this.setRenderSize(processParam.getOutPutWidth(), processParam.getOutPutHeight());
    }

    public void setOnFrameAvailableListener(SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener) {
        this.onFrameAvailableListener = onFrameAvailableListener;
    }

    private void bindTexture() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.texture_in);
    }

    protected void drawFrame() {
        this.videoTex.updateTexImage();
        super.drawFrame();
    }

    protected String getFragmentShader() {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES inputImageTexture0;\nvarying vec2 textureCoordinate;\nvoid main() {\n   gl_FragColor = texture2D(inputImageTexture0, textureCoordinate);\n}\n";
    }

    protected String getVertexShader() {
        return "uniform mat4 u_Matrix;\nattribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvoid main() {\n   vec4 texPos = u_Matrix * vec4(inputTextureCoordinate, 1, 1);\n   textureCoordinate = texPos.xy;\n   gl_Position = position;\n}\n";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.matrixHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CAM_MATRIX);
    }

    protected void initWithGLContext() {
        this.ready = false;
        super.initWithGLContext();
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.texture_in = textures[0];
        this.videoTex = new SurfaceTexture(this.texture_in);
        this.videoTex.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surface = new Surface(this.videoTex);
        this.ready = true;
    }

    public void startVideoDecode() {
        VideoThread player = new VideoThread();
        player.start();
    }

    public void onFrameAvailable(SurfaceTexture arg0) {
        this.markAsDirty();
        if (null != this.view) {
            this.view.requestRender();
        }
        if (null != this.onFrameAvailableListener) {
            this.onFrameAvailableListener.onFrameAvailable(arg0);
        }
    }

    public Surface getSurface() {
        return this.surface;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.videoTex;
    }

    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        this.bindTexture();
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        this.videoTex.getTransformMatrix(this.matrix);
        GLES20.glUniformMatrix4fv((int)this.matrixHandle, (int)1, (boolean)false, (float[])this.matrix, (int)0);
    }

    public boolean isPlaying() {
        return true;
    }

    public void startWhenReady() {
        if (this.ready) {
            this.player.start();
        } else {
            this.startWhenReady = true;
        }
    }

    public void stop() {
        if (null != this.player) {
            this.player.stop();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
        this.recordVideo = false;
    }

    public void setRenderSize(int width, int height) {
        super.setRenderSize(width, height);
    }

    public void setProcessListener(VideoProcessListener processListener) {
        this.processListener = processListener;
    }

    public MediaCodec.BufferInfo getCurrentBuffer() {
        return this.currentBufferInfo;
    }

    private class VideoThread
    extends Thread {
        private MediaExtractor extractor;
        private MediaCodec decoder;

        @Override
        @TargetApi(value=18)
        public void run() {
            if (null != VideoResourceProcessInput.this.processListener) {
                VideoResourceProcessInput.this.processListener.onStart();
            }
            this.extractor = new MediaExtractor();
            try {
                FileUtil.exist((String)VideoResourceProcessInput.this.videoPath);
                this.extractor.setDataSource(VideoResourceProcessInput.this.videoPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.extractor.getTrackCount(); ++i) {
                MediaFormat format = this.extractor.getTrackFormat(i);
                String mime = format.getString("mime");
                if (!mime.startsWith("video/")) continue;
                this.extractor.selectTrack(i);
                try {
                    this.decoder = MediaCodec.createDecoderByType((String)mime);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.decoder.configure(format, VideoResourceProcessInput.this.surface, null, 0);
                break;
            }
            if (this.decoder == null) {
                return;
            }
            this.decoder.start();
            ByteBuffer[] inputBuffers = this.decoder.getInputBuffers();
            ByteBuffer[] outputBuffers = this.decoder.getOutputBuffers();
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int addNumber = 0;
            boolean isEOS = false;
            long startMs = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            boolean frameNumber = false;
            while (!Thread.interrupted()) {
                int inIndex;
                if (!isEOS && (inIndex = this.decoder.dequeueInputBuffer(10000L)) >= 0) {
                    ByteBuffer buffer = inputBuffers[inIndex];
                    int sampleSize = this.extractor.readSampleData(buffer, 0);
                    if (sampleSize < 0) {
                        this.decoder.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                        isEOS = true;
                    } else {
                        this.decoder.queueInputBuffer(inIndex, 0, sampleSize, this.extractor.getSampleTime(), 0);
                        this.extractor.advance();
                    }
                }
                int outIndex = this.decoder.dequeueOutputBuffer(info, 10000L);
                switch (outIndex) {
                    case -3: {
                        outputBuffers = this.decoder.getOutputBuffers();
                        break;
                    }
                    case -2: {
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        if (info.presentationTimeUs >= 0L) {
                            VideoResourceProcessInput.this.currentBufferInfo = info;
                            if (info.presentationTimeUs <= VideoResourceProcessInput.this.mCurTimestamp) {
                                VideoResourceProcessInput.this.currentBufferInfo = null;
                                break;
                            }
                            VideoResourceProcessInput.this.mCurTimestamp = info.presentationTimeUs;
                            if (((VideoResourceProcessInput)VideoResourceProcessInput.this).currentBufferInfo.presentationTimeUs <= 0L) break;
                            VideoResourceProcessInput.this.isProcess = true;
                            VideoResourceProcessInput.this.mFrameIndex++;
                            if (null != VideoResourceProcessInput.this.processListener) {
                                VideoResourceProcessInput.this.processListener.onProcessProgress((float)VideoResourceProcessInput.this.mCurTimestamp / (float)VideoResourceProcessInput.this.processParam.getVideoDuration());
                            }
                            ((VideoResourceProcessInput)VideoResourceProcessInput.this).processSurface.isRenderDrawing.set(true);
                            this.decoder.releaseOutputBuffer(outIndex, true);
                            if (VideoResourceProcessInput.this.renderTime == 0L) {
                                VideoResourceProcessInput.this.renderTime = VideoResourceProcessInput.this.mCurTimestamp;
                            }
                            if (VideoResourceProcessInput.this.mFrameRate > 0) {
                                if (VideoResourceProcessInput.this.mCurTimestamp - VideoResourceProcessInput.this.renderTime < (long)(1000000 / VideoResourceProcessInput.this.mFrameRate)) {
                                    ((VideoResourceProcessInput)VideoResourceProcessInput.this).processSurface.shouldDrop.set(true);
                                } else {
                                    VideoResourceProcessInput.this.renderTime = VideoResourceProcessInput.this.mCurTimestamp;
                                    ((VideoResourceProcessInput)VideoResourceProcessInput.this).processSurface.shouldDrop.set(false);
                                }
                            } else {
                                ((VideoResourceProcessInput)VideoResourceProcessInput.this).processSurface.shouldDrop.set(false);
                            }
                            while (((VideoResourceProcessInput)VideoResourceProcessInput.this).processSurface.isRenderDrawing.get() && addNumber < 20) {
                                try {
                                    VideoThread.sleep(10L);
                                    ++addNumber;
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    break;
                                }
                            }
                            addNumber = 0;
                            break;
                        }
                        if (info.presentationTimeUs >= 0L) break;
                        VideoResourceProcessInput.this.currentBufferInfo = null;
                    }
                }
                if ((info.flags & 4) == 0) continue;
                break;
            }
            VideoResourceProcessInput.this.frameSize = 0;
            this.decoder.stop();
            this.decoder.release();
            this.extractor.release();
            if (null != VideoResourceProcessInput.this.processListener) {
                VideoResourceProcessInput.this.processListener.onProcessFinish(null);
            }
        }
    }
}

