/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoencoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Environment;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.videoencoder.MediaEncoder;
import com.momo.mcamera.videoencoder.MediaVideoEncoder;
import com.momo.mcamera.videoencoder.ProcessSurface;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class MediaMuxerWrapper {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaMuxerWrapper";
    private static final String DIR_NAME = "AVRecSample";
    private static final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
    private String mOutputPath;
    private final MediaMuxer mMediaMuxer;
    private int mEncoderCount;
    private int mStatredCount;
    private boolean mIsStarted;
    private MediaEncoder mVideoEncoder;
    private MediaEncoder mAudioEncoder;

    @TargetApi(value=18)
    public MediaMuxerWrapper(String ext) throws IOException {
        this.mOutputPath = ext;
        this.mMediaMuxer = new MediaMuxer(this.mOutputPath, 0);
        this.mStatredCount = 0;
        this.mEncoderCount = 0;
        this.mIsStarted = false;
    }

    public String getOutputPath() {
        return this.mOutputPath;
    }

    public void prepareAudio(ProcessSurface processSurface, MediaFormat format) throws IOException {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper prepareAudio");
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.prepare(null, format);
        }
    }

    public void prepareVideo(ProcessSurface processSurface, MediaFormat format) throws IOException {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper prepareVideo");
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.prepare(processSurface, format);
        }
    }

    public void prepare(ProcessSurface processSurface, MediaFormat format) throws IOException {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper prepare");
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.prepare(processSurface, format);
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.prepare(null, format);
        }
    }

    public void startRecording() {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper startRecording");
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.startRecording();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.startRecording();
        }
    }

    public void stopRecording() {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper stopRecording");
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stopRecording();
        }
        this.mVideoEncoder = null;
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stopRecording();
        }
        this.mAudioEncoder = null;
    }

    public synchronized boolean isStarted() {
        return this.mIsStarted;
    }

    void addEncoder(MediaEncoder encoder) {
        MDLog.i((String)"mediaMuxer", (String)"MediaMuxerWrapper addEncoder");
        if (encoder instanceof MediaVideoEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
        } else {
            throw new IllegalArgumentException("unsupported encoder");
        }
        this.mVideoEncoder = encoder;
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    @TargetApi(value=18)
    synchronized boolean start() {
        ++this.mStatredCount;
        if (this.mEncoderCount > 0 && this.mStatredCount == this.mEncoderCount) {
            this.mMediaMuxer.start();
            this.mIsStarted = true;
            this.notifyAll();
        }
        return this.mIsStarted;
    }

    @TargetApi(value=18)
    synchronized void stop() {
        --this.mStatredCount;
        if (this.mEncoderCount > 0 && this.mStatredCount <= 0) {
            this.mMediaMuxer.stop();
            this.mMediaMuxer.release();
            this.mIsStarted = false;
        }
    }

    @TargetApi(value=18)
    synchronized int addTrack(MediaFormat format) {
        if (this.mIsStarted) {
            throw new IllegalStateException("muxer already started");
        }
        int trackIx = this.mMediaMuxer.addTrack(format);
        return trackIx;
    }

    @TargetApi(value=18)
    synchronized void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (this.mStatredCount > 0) {
            this.mMediaMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }

    public static final File getCaptureFile(String type, String ext) {
        File dir = new File(Environment.getExternalStoragePublicDirectory((String)type), DIR_NAME);
        dir.mkdirs();
        if (dir.canWrite()) {
            return new File(dir, MediaMuxerWrapper.getDateTimeString() + ext);
        }
        return null;
    }

    private static final String getDateTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return mDateTimeFormat.format(now.getTime());
    }
}

