/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import com.momo.mcamera.util.fft.FourierTransform;

public class FFT
extends FourierTransform {
    public static final int ACCURACY_LOWEST = 256;
    public static final int ACCURACY_LOW = 512;
    public static final int ACCURACY_MIDEUM = 1024;
    public static final int ACCURACY_HIGH = 2048;
    public static final int ACCURACY_HIGHEST = 4096;
    private int[] reverse;
    private float[] sinlookup;
    private float[] coslookup;

    public FFT(int timeSize, float sampleRate) {
        super(timeSize, sampleRate);
        if ((timeSize & timeSize - 1) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.buildReverseTable();
        this.buildTrigTables();
    }

    @Override
    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize];
        this.imag = new float[this.timeSize];
    }

    @Override
    public void scaleBand(int i, float s) {
        if (s < 0.0f) {
            return;
        }
        int n = i;
        this.real[n] = this.real[n] * s;
        int n2 = i;
        this.imag[n2] = this.imag[n2] * s;
        int n3 = i;
        this.spectrum[n3] = this.spectrum[n3] * s;
        if (i != 0 && i != this.timeSize / 2) {
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[i];
        }
    }

    @Override
    public void setBand(int i, float a) {
        if (a < 0.0f) {
            return;
        }
        if (this.real[i] == 0.0f && this.imag[i] == 0.0f) {
            this.real[i] = a;
            this.spectrum[i] = a;
        } else {
            int n = i;
            this.real[n] = this.real[n] / this.spectrum[i];
            int n2 = i;
            this.imag[n2] = this.imag[n2] / this.spectrum[i];
            this.spectrum[i] = a;
            int n3 = i;
            this.real[n3] = this.real[n3] * this.spectrum[i];
            int n4 = i;
            this.imag[n4] = this.imag[n4] * this.spectrum[i];
        }
        if (i != 0 && i != this.timeSize / 2) {
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[i];
        }
    }

    private void fft() {
        for (int halfSize = 1; halfSize < this.real.length; halfSize *= 2) {
            float phaseShiftStepR = this.cos(halfSize);
            float phaseShiftStepI = this.sin(halfSize);
            float currentPhaseShiftR = 1.0f;
            float currentPhaseShiftI = 0.0f;
            for (int fftStep = 0; fftStep < halfSize; ++fftStep) {
                for (int i = fftStep; i < this.real.length; i += 2 * halfSize) {
                    int off = i + halfSize;
                    float tr = currentPhaseShiftR * this.real[off] - currentPhaseShiftI * this.imag[off];
                    float ti = currentPhaseShiftR * this.imag[off] + currentPhaseShiftI * this.real[off];
                    this.real[off] = this.real[i] - tr;
                    this.imag[off] = this.imag[i] - ti;
                    int n = i;
                    this.real[n] = this.real[n] + tr;
                    int n2 = i;
                    this.imag[n2] = this.imag[n2] + ti;
                }
                float tmpR = currentPhaseShiftR;
                currentPhaseShiftR = tmpR * phaseShiftStepR - currentPhaseShiftI * phaseShiftStepI;
                currentPhaseShiftI = tmpR * phaseShiftStepI + currentPhaseShiftI * phaseShiftStepR;
            }
        }
    }

    @Override
    public void forward(float[] buffer) {
        if (buffer.length != this.timeSize) {
            return;
        }
        this.bitReverseSamples(buffer, 0);
        this.fft();
        this.fillSpectrum();
    }

    @Override
    public void forward(float[] buffer, int startAt) {
        if (buffer.length - startAt < this.timeSize) {
            return;
        }
        this.bitReverseSamples(buffer, startAt);
        this.fft();
        this.fillSpectrum();
    }

    public void forward(float[] buffReal, float[] buffImag) {
        if (buffReal.length != this.timeSize || buffImag.length != this.timeSize) {
            return;
        }
        this.setComplex(buffReal, buffImag);
        this.bitReverseComplex();
        this.fft();
        this.fillSpectrum();
    }

    @Override
    public void inverse(float[] buffer) {
        if (buffer.length > this.real.length) {
            return;
        }
        int i = 0;
        while (i < this.timeSize) {
            int n = i++;
            this.imag[n] = this.imag[n] * -1.0f;
        }
        this.bitReverseComplex();
        this.fft();
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = this.real[i] / (float)this.real.length;
        }
    }

    private void buildReverseTable() {
        int N = this.timeSize;
        this.reverse = new int[N];
        this.reverse[0] = 0;
        int limit = 1;
        int bit = N / 2;
        while (limit < N) {
            for (int i = 0; i < limit; ++i) {
                this.reverse[i + limit] = this.reverse[i] + bit;
            }
            limit <<= 1;
            bit >>= 1;
        }
    }

    private void bitReverseSamples(float[] samples, int startAt) {
        for (int i = 0; i < this.timeSize; ++i) {
            this.real[i] = samples[startAt + this.reverse[i]];
            this.imag[i] = 0.0f;
        }
    }

    private void bitReverseComplex() {
        float[] revReal = new float[this.real.length];
        float[] revImag = new float[this.imag.length];
        for (int i = 0; i < this.real.length; ++i) {
            revReal[i] = this.real[this.reverse[i]];
            revImag[i] = this.imag[this.reverse[i]];
        }
        this.real = revReal;
        this.imag = revImag;
    }

    private float sin(int i) {
        return this.sinlookup[i];
    }

    private float cos(int i) {
        return this.coslookup[i];
    }

    private void buildTrigTables() {
        int N = this.timeSize;
        this.sinlookup = new float[N];
        this.coslookup = new float[N];
        for (int i = 0; i < N; ++i) {
            this.sinlookup[i] = (float)Math.sin((float)(-Math.PI) / (float)i);
            this.coslookup[i] = (float)Math.cos((float)(-Math.PI) / (float)i);
        }
    }
}

