/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import android.media.AudioRecord;
import com.cosmos.mdlog.MDLog;

public class AudioRecorder {
    public static final int sampleRate = 44100;
    public static final int channelConfig = 16;
    public static final int audioFormat = 2;
    private AudioRecord audioRecorder;
    private int bufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
    private int accuracy;
    private short[] buffer;
    private int bufferReadResult;

    public AudioRecorder() {
        this.audioRecorder = new AudioRecord(0, 44100, 16, 2, this.bufferSize * 10);
    }

    public void startRecorder() {
        try {
            this.audioRecorder.startRecording();
        }
        catch (Exception e) {
            MDLog.e((String)"Recording failed", (String)e.toString());
        }
    }

    public void stopRecorder() {
        try {
            this.audioRecorder.stop();
            this.audioRecorder.release();
        }
        catch (IllegalStateException e) {
            MDLog.e((String)"Stop failed", (String)e.toString());
        }
    }

    public void setAccuracy(int accu) {
        this.accuracy = accu;
    }

    public short[] getSamples() {
        this.buffer = new short[this.accuracy];
        this.bufferReadResult = this.audioRecorder.read(this.buffer, 0, this.accuracy);
        return this.buffer;
    }

    public int getBufferReadResult() {
        return this.bufferReadResult;
    }
}

