/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import android.content.Context;
import android.os.Handler;
import com.momo.mcamera.mask.SoundInputFilter;
import com.momo.mcamera.util.fft.AudioRecorder;
import com.momo.mcamera.util.fft.FFT;
import com.momo.mcamera.util.fft.Spectrum;

public class AudioRecordThread
extends Thread {
    private Context mContext;
    private Handler mHandler;
    private boolean thread_running = true;
    private AudioRecorder mAudioRecorder = new AudioRecorder();
    private Spectrum mSpectrum = new Spectrum();
    private int mAccuracy;
    private SoundInputFilter mSoundInputFilter;
    private int index = 0;

    public AudioRecordThread(Context context, Handler handler, int accuracy) {
        this.mContext = context;
        this.mHandler = handler;
        this.mAccuracy = accuracy;
    }

    private void getFreqByFFT(FFT fft_samples, short[] buffer_samples) {
        int i;
        float[] fftRealArray = new float[this.mAccuracy];
        for (i = this.index; i < this.mAudioRecorder.getBufferReadResult() + this.index; ++i) {
            fftRealArray[i - this.index] = (float)buffer_samples[i - this.index] / 32767.0f;
        }
        this.index += this.mAudioRecorder.getBufferReadResult();
        if (this.index >= this.mAccuracy) {
            this.index = 0;
            for (i = 0; i < this.mAccuracy / 2; ++i) {
                float winval = (float)(0.5 + 0.5 * Math.cos(Math.PI * (double)i / (double)(this.mAccuracy / 2)));
                if (i > this.mAccuracy / 2) {
                    winval = 0.0f;
                }
                int n = this.mAccuracy / 2 + i;
                fftRealArray[n] = fftRealArray[n] * winval;
                int n2 = this.mAccuracy / 2 - i;
                fftRealArray[n2] = fftRealArray[n2] * winval;
            }
            fftRealArray[0] = 0.0f;
            fft_samples.forward(fftRealArray);
            float[] amplitudes = new float[fft_samples.specSize()];
            int[] frequencies = new int[fft_samples.specSize()];
            float maxVal = 0.0f;
            int maxValIndex = 0;
            for (int i2 = 0; i2 < fft_samples.specSize(); ++i2) {
                float temp = fft_samples.getBand(i2);
                amplitudes[i2] = (float)Math.log10(temp + 1.0f);
                frequencies[i2] = Math.round((float)i2 * (44100.0f / (float)this.mAccuracy));
                if (!(fft_samples.getBand(i2) > maxVal)) continue;
                maxVal = fft_samples.getBand(i2);
                maxValIndex = i2;
            }
            int peakFreq = Math.round((float)maxValIndex * (44100.0f / (float)this.mAccuracy));
            try {
                byte[] bytes = new byte[2048];
                for (int i3 = 0; i3 < 2; ++i3) {
                    for (int j = 0; j < 256; ++j) {
                        float temp = amplitudes[i3 * 256 + j];
                        int value = (temp *= 128.0f) > 255.0f ? 255 : (int)temp;
                        bytes[i3 * 256 * 4 + j * 4 + 0] = (byte)(value & 0xFF);
                        bytes[i3 * 256 * 4 + j * 4 + 1] = (byte)(value >> 8 & 0xFF);
                        bytes[i3 * 256 * 4 + j * 4 + 2] = (byte)(value >> 16 & 0xFF);
                        bytes[i3 * 256 * 4 + j * 4 + 3] = (byte)(value >> 24);
                    }
                }
                if (null != this.mSoundInputFilter) {
                    this.mSoundInputFilter.setSoundBytes(bytes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopThread() {
        this.mAudioRecorder.stopRecorder();
        this.thread_running = false;
        if (this != null && this.isAlive() && !this.isInterrupted()) {
            this.interrupt();
        }
    }

    public void restartThread() {
        this.mAudioRecorder.startRecorder();
        this.thread_running = true;
        if (this != null && !this.isAlive() && this.isInterrupted()) {
            this.start();
        }
    }

    public void setSoundInputFilter(SoundInputFilter mSoundInputFilter) {
        this.mSoundInputFilter = mSoundInputFilter;
    }

    @Override
    public void run() {
        while (this.thread_running) {
            this.mAudioRecorder.setAccuracy(this.mAccuracy);
            this.mAudioRecorder.startRecorder();
            short[] buffer = this.mAudioRecorder.getSamples();
            this.mSpectrum.setSignalSamples(buffer);
            FFT fft = new FFT(this.mAccuracy, 44100.0f);
            this.getFreqByFFT(fft, buffer);
        }
    }
}

