/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util;

import com.google.ar.core.Frame;
import com.google.ar.core.HitResult;
import com.google.ar.core.Plane;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingState;
import com.google.ar.core.exceptions.NotTrackingException;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.ar.ARCore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ArCoreHelper {
    private Session mSession;
    private Frame mFrame;
    private Map<Double, float[]> mPoseList;
    private float[] mAnchorMatrix = new float[17];
    private static volatile ArCoreHelper instance = null;
    private ARCore.IARCoreListener mIARCoreListener = null;
    private boolean isUseARCore = false;

    private ArCoreHelper() {
        this.mPoseList = new HashMap<Double, float[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArCoreHelper getInstance() {
        if (instance != null) return instance;
        Class<ArCoreHelper> clazz = ArCoreHelper.class;
        synchronized (ArCoreHelper.class) {
            if (instance != null) return instance;
            instance = new ArCoreHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<Double, float[]> getHitResultPose(float x, float y) {
        if (this.mFrame == null || this.mSession == null) {
            return null;
        }
        this.mPoseList.clear();
        if (this.mFrame.getCamera().getTrackingState() == TrackingState.TRACKING) {
            for (HitResult hit : this.mFrame.hitTest(x, y)) {
                if (!(hit.getTrackable() instanceof Plane)) continue;
                try {
                    hit.createAnchor().getPose().toMatrix(this.mAnchorMatrix, 0);
                    if (((Plane)hit.getTrackable()).getType() == Plane.Type.HORIZONTAL_UPWARD_FACING) {
                        this.mAnchorMatrix[16] = 0.0f;
                    } else if (((Plane)hit.getTrackable()).getType() == Plane.Type.HORIZONTAL_DOWNWARD_FACING) {
                        this.mAnchorMatrix[16] = 1.0f;
                    } else if (((Plane)hit.getTrackable()).getType() == Plane.Type.VERTICAL) {
                        this.mAnchorMatrix[16] = 2.0f;
                    }
                }
                catch (NotTrackingException notTrackingException) {
                    // empty catch block
                }
                this.mPoseList.put(Double.valueOf(((Plane)hit.getTrackable()).hashCode()), this.mAnchorMatrix);
                break;
            }
        }
        return this.mPoseList;
    }

    public void getPlaneTrackInfo() {
        if (this.mFrame == null || this.mSession == null) {
            return;
        }
        float trackState = -1.0f;
        float planeType = -1.0f;
        Collection planes = this.mSession.getAllTrackables(Plane.class);
        int arrayLength = 24 * planes.size();
        float[] planeTrackInfos = new float[arrayLength];
        double[] planeIds = new double[planes.size()];
        int index = 0;
        for (Plane plane : planes) {
            float[] mCenterPoseMatrix = new float[16];
            float[] mCenterPoseXYZ = new float[3];
            float[] planeTrackInfo = new float[24];
            plane.getCenterPose().toMatrix(planeTrackInfo, 0);
            if (planeTrackInfo != null && planeTrackInfo.length != 0) {
                mCenterPoseXYZ[0] = planeTrackInfo[12];
                mCenterPoseXYZ[1] = planeTrackInfo[13];
                mCenterPoseXYZ[2] = planeTrackInfo[14];
            }
            if (plane.getTrackingState() == TrackingState.TRACKING) {
                trackState = 0.0f;
            } else if (plane.getTrackingState() == TrackingState.PAUSED) {
                trackState = 1.0f;
            } else if (plane.getTrackingState() == TrackingState.STOPPED) {
                trackState = 2.0f;
            }
            planeTrackInfo[16] = trackState;
            if (plane.getType() == Plane.Type.HORIZONTAL_UPWARD_FACING) {
                planeType = 0.0f;
            } else if (plane.getType() == Plane.Type.HORIZONTAL_DOWNWARD_FACING) {
                planeType = 1.0f;
            } else if (plane.getType() == Plane.Type.VERTICAL) {
                planeType = 2.0f;
            }
            planeTrackInfo[17] = planeType;
            planeTrackInfo[18] = mCenterPoseXYZ[0];
            planeTrackInfo[19] = mCenterPoseXYZ[1];
            planeTrackInfo[20] = mCenterPoseXYZ[2];
            planeTrackInfo[21] = plane.getExtentX();
            planeTrackInfo[22] = 0.0f;
            planeTrackInfo[23] = plane.getExtentZ();
            planeIds[index] = plane.hashCode();
            for (int i = 0; i < planeTrackInfo.length; ++i) {
                planeTrackInfos[i + index * planeTrackInfo.length] = planeTrackInfo[i];
            }
            ++index;
        }
        ARCore.updateAnchors((float[])planeTrackInfos, (double[])planeIds);
    }

    public void setArCoreInfo(Frame frame, Session session) {
        this.mSession = session;
        this.mFrame = frame;
    }

    public void updateCameraMatrix() {
        float[] projmtx = new float[16];
        ArCoreHelper.getInstance().getFrame().getCamera().getProjectionMatrix(projmtx, 0, 0.1f, 100.0f);
        float[] viewmtx = new float[16];
        ArCoreHelper.getInstance().getFrame().getCamera().getViewMatrix(viewmtx, 0);
        ARCore.setCameraViewMatrix((float[])viewmtx);
        ARCore.setProjections((float[])projmtx);
    }

    public void registerARCoreListener() {
        this.mIARCoreListener = new ARCore.IARCoreListener(){

            public Map<Double, float[]> onHitPose(float x, float y) {
                return ArCoreHelper.getInstance().getHitResultPose(x, y);
            }
        };
        ARCore.addListener((ARCore.IARCoreListener)this.mIARCoreListener);
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                ARCore.setARHitTestListener();
            }
        });
    }

    public void unRegisterARCoreListener() {
        if (this.mIARCoreListener != null) {
            ARCore.removeListener((ARCore.IARCoreListener)this.mIARCoreListener);
        }
    }

    public Session getSession() {
        return this.mSession;
    }

    public void setSession(Session mSession) {
        this.mSession = mSession;
    }

    public Frame getFrame() {
        return this.mFrame;
    }

    public void setFrame(Frame mFrame) {
        this.mFrame = mFrame;
    }

    public boolean isUseARCore() {
        return this.isUseARCore;
    }

    public void setUseARCore(boolean useARCore) {
        this.isUseARCore = useARCore;
    }
}

