/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.skin;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.skin.AIFaceSkinComposeFilter;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class AISkinChooseFilter
extends GroupFilter
implements FaceDetectInterface {
    private NormalFilter mNormalFilter = null;
    private AIFaceSkinComposeFilter mCXFaceSkinComposeFilter;
    private Float mCurrentLevel;

    public AISkinChooseFilter(Float defaultLevel) {
        this.mCurrentLevel = defaultLevel;
        this.mNormalFilter = new NormalFilter();
        if (defaultLevel.floatValue() == 0.0f) {
            this.registerInitialFilter((BasicFilter)this.mNormalFilter);
            this.registerTerminalFilter((BasicFilter)this.mNormalFilter);
            this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
            return;
        }
        this.mCXFaceSkinComposeFilter = new AIFaceSkinComposeFilter();
        this.mCXFaceSkinComposeFilter.setSmoothLevel(defaultLevel.floatValue());
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this.mCXFaceSkinComposeFilter);
        this.registerInitialFilter((BasicFilter)this.mNormalFilter);
        this.registerTerminalFilter((BasicFilter)this.mCXFaceSkinComposeFilter);
        this.mCXFaceSkinComposeFilter.addTarget((GLTextureInputRenderer)this);
    }

    public void setSkinLevel(Float skinLevel) {
        if (skinLevel.floatValue() == 0.0f) {
            if (this.mCurrentLevel.floatValue() != 0.0f) {
                this.mCXFaceSkinComposeFilter.setSmoothLevel(0.0f);
                this.mCXFaceSkinComposeFilter.removeTarget((GLTextureInputRenderer)this);
                this.mNormalFilter.removeTarget((GLTextureInputRenderer)this.mCXFaceSkinComposeFilter);
                this.removeTerminalFilter((BasicFilter)this.mCXFaceSkinComposeFilter);
                this.registerTerminalFilter((BasicFilter)this.mNormalFilter);
                this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
            }
        } else {
            if (this.mCurrentLevel.floatValue() == 0.0f) {
                if (this.mCXFaceSkinComposeFilter != null) {
                    this.mCXFaceSkinComposeFilter.destroy();
                }
                this.mCXFaceSkinComposeFilter = new AIFaceSkinComposeFilter();
                this.mNormalFilter.removeTarget((GLTextureInputRenderer)this);
                this.mNormalFilter.addTarget((GLTextureInputRenderer)this.mCXFaceSkinComposeFilter);
                this.removeTerminalFilter((BasicFilter)this.mNormalFilter);
                this.registerTerminalFilter((BasicFilter)this.mCXFaceSkinComposeFilter);
                this.mCXFaceSkinComposeFilter.addTarget((GLTextureInputRenderer)this);
            }
            this.mCXFaceSkinComposeFilter.setSmoothLevel(skinLevel.floatValue());
        }
        this.mCurrentLevel = skinLevel;
    }

    public float getSkinLevel() {
        return this.mCurrentLevel.floatValue();
    }

    public synchronized void destroy() {
        super.destroy();
        if (this.mNormalFilter != null) {
            this.mNormalFilter.destroy();
        }
        if (this.mCXFaceSkinComposeFilter != null) {
            this.mCXFaceSkinComposeFilter.destroy();
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.mNormalFilter.releaseFrameBuffer();
        this.mCXFaceSkinComposeFilter.releaseFrameBuffer();
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mCXFaceSkinComposeFilter.setMMCVInfo(mmcvInfo);
    }
}

