/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.skin;

import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class AIFaceSkinSmoothFilter
extends FaceDetectFilter {
    private int mWinSize = 6;
    private int[] mLowSkinThreshold = new int[]{0, 0, 0};
    private int[] mHighSkinThreshold = new int[]{255, 255, 255};
    private int[] mDefaultSkinThreshold = new int[]{160, 120, 110};
    private float mSkinSmoothScale = 0.0f;
    private float mTexelWidth;
    private float mTexelHeight;
    private int mSkinSmoothScaleHandle;
    private int mLowSkinThresholdHandle;
    private int mHighSkinThresholdHandle;
    private int mDefaultSkinThresholdHandle;
    private int mTexelWidthHandle;
    private int mTexelHeightHandle;
    private int mFaceWidthHandle;
    private MMCVInfo mMmcvInfo;
    private ByteBuffer mByteBufVer;
    private FloatBuffer mBufferVer;
    private ByteBuffer mByteBufTex;
    private FloatBuffer mBufferTex;
    private float mMMCVWidth = 0.0f;
    private float mMMCVHeight = 0.0f;

    public AIFaceSkinSmoothFilter() {
        this.init(6);
        this.setBackgroundColour(0.5f, 0.5f, 0.5f, 1.0f);
    }

    private void init(int winSize) {
        this.mWinSize = winSize;
        this.mLowSkinThreshold[0] = 0;
        this.mLowSkinThreshold[1] = 0;
        this.mLowSkinThreshold[2] = 0;
        this.mHighSkinThreshold[0] = 255;
        this.mHighSkinThreshold[1] = 255;
        this.mHighSkinThreshold[2] = 255;
    }

    public void handleSizeChange() {
        super.handleSizeChange();
        this.mTexelWidth = this.getWidth();
        this.mTexelHeight = this.getHeight();
    }

    public String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float amount;\nuniform vec3 lowSkinThreshold;\nuniform vec3 highSkinThreshold;\nuniform float texelWidthOffset; \nuniform float texelHeightOffset; \nfloat minstep = 3.0;\nuniform vec3 skinDefaultRGB;\nuniform float faceWidth;\nvoid main() {\n    float epslone = 0.006 * amount * amount;\n    float faceWidthFactor = min(faceWidth / 360.0, 1.4);\n    float xInc = minstep * 1.0 / 480.0 * faceWidthFactor;\n    float yInc = minstep * 1.0 / (480.0 / texelWidthOffset * texelHeightOffset) * faceWidthFactor;\n    vec4 a = vec4(0., 0., 0., 0.);\n    vec4 b = vec4(0., 0., 0., 0.);\n    vec4 meanI = vec4(0., 0., 0., 0.);\n    vec4 meanII = vec4(0., 0., 0., 0.);\n    vec4 temp = vec4(0., 0., 0., 0.);\n    vec4 sourceColor = texture2D(inputImageTexture0,textureCoordinate);\n    vec3 relation = vec3(1.) + min((sourceColor.xyz - skinDefaultRGB), vec3(0.0));\n    float meanrelation =(relation.x + relation.y + relation.z) / 3.0;\n    float r = 1. / (1. + exp(24. - 30. * meanrelation));\n    float eps = epslone * r;\n    if (eps < 0.000001) {\n         gl_FragColor = vec4(0.5, 0.5, 0.5, 1.0);\n         return;\n    }\n    float x = textureCoordinate.x + (-float(" + this.mWinSize + ") * 0.5 * xInc);\n    float y = " + "textureCoordinate" + ".y + (-float(" + this.mWinSize + ") * 0.5 * yInc);\n    for (int i = 0; i < " + this.mWinSize + "; i++) {\n          for (int j = 0; j < " + this.mWinSize + "; j++) {\n              temp = texture2D(" + "inputImageTexture0" + ", vec2(x + float(i) * xInc, y + float(j) * yInc));\n              meanI += temp;\n              meanII += temp * temp;\n          }\n    }\n    meanI /= float(" + this.mWinSize + "*" + this.mWinSize + ");\n    meanII /= float(" + this.mWinSize + "*" + this.mWinSize + ");\n    temp = meanII - meanI * meanI;\n    a = clamp(temp / (temp + vec4(vec3(eps), 1.0)), 0.0, 1.0);\n    b = meanI - a * meanI;\n    vec4 temp3 = a * sourceColor + b;\n    gl_FragColor = vec4(temp3.xyz - sourceColor.xyz + vec3(0.5, 0.5, 0.5), 1.0);\n    return;\n}\n";
    }

    public void initShaderHandles() {
        super.initShaderHandles();
        this.mSkinSmoothScaleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"amount");
        this.mLowSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"lowSkinThreshold");
        this.mHighSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"highSkinThreshold");
        this.mDefaultSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinDefaultRGB");
        this.mTexelWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelWidthOffset");
        this.mTexelHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelHeightOffset");
        this.mFaceWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"faceWidth");
    }

    private void facePassShaderValues(int position) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1f((int)this.mSkinSmoothScaleHandle, (float)this.mSkinSmoothScale);
        GLES20.glUniform3f((int)this.mLowSkinThresholdHandle, (float)((float)this.mLowSkinThreshold[0] / 255.0f), (float)((float)this.mLowSkinThreshold[1] / 255.0f), (float)((float)this.mLowSkinThreshold[2] / 255.0f));
        GLES20.glUniform3f((int)this.mHighSkinThresholdHandle, (float)((float)this.mHighSkinThreshold[0] / 255.0f), (float)((float)this.mHighSkinThreshold[1] / 255.0f), (float)((float)this.mHighSkinThreshold[2] / 255.0f));
        GLES20.glUniform3f((int)this.mDefaultSkinThresholdHandle, (float)((float)this.mDefaultSkinThreshold[0] / 255.0f), (float)((float)this.mDefaultSkinThreshold[1] / 255.0f), (float)((float)this.mDefaultSkinThreshold[2] / 255.0f));
        GLES20.glUniform1f((int)this.mTexelWidthHandle, (float)this.mTexelWidth);
        GLES20.glUniform1f((int)this.mTexelHeightHandle, (float)this.mTexelHeight);
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            GLES20.glUniform1f((int)this.mFaceWidthHandle, (float)AIFaceTriangulation.getFaceTriangulationWidth(this.mMmcvInfo.getFaceAttributeInfo(position).getOriglandmarks_104(), (float)this.width / this.mMMCVWidth));
        }
    }

    public void setSkinSmoothScale(float scale) {
        this.mSkinSmoothScale = scale;
    }

    public float getSkinSmoothScale() {
        return this.mSkinSmoothScale;
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mMmcvInfo = mmcvInfo;
        this.mLowSkinThreshold[0] = 0;
        this.mLowSkinThreshold[1] = 0;
        this.mLowSkinThreshold[2] = 0;
        this.mHighSkinThreshold[0] = 255;
        this.mHighSkinThreshold[1] = 255;
        this.mHighSkinThreshold[2] = 255;
        this.mDefaultSkinThreshold[0] = 160;
        this.mDefaultSkinThreshold[1] = 120;
        this.mDefaultSkinThreshold[2] = 110;
        if (mmcvInfo.restoreDegree % 90 == 0 && mmcvInfo.restoreDegree % 180 != 0) {
            this.mMMCVWidth = mmcvInfo.height;
            this.mMMCVHeight = mmcvInfo.width;
        } else {
            this.mMMCVWidth = mmcvInfo.width;
            this.mMMCVHeight = mmcvInfo.height;
        }
    }

    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                this.facePassShaderValues(i);
                float[][] array = AIFaceTriangulation.getFaceTriangulation(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight(), null);
                float[] vertexCoord = array[0];
                float[] textureCoord = array[1];
                if (this.mByteBufTex == null) {
                    this.mByteBufVer = ByteBuffer.allocateDirect(vertexCoord.length * 4);
                    this.mByteBufVer.order(ByteOrder.nativeOrder());
                    this.mBufferVer = this.mByteBufVer.asFloatBuffer();
                }
                this.mBufferVer.rewind();
                this.mBufferVer.put(vertexCoord);
                this.mBufferVer.position(0);
                GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferVer);
                GLES20.glEnableVertexAttribArray((int)this.positionHandle);
                if (this.mByteBufTex == null) {
                    this.mByteBufTex = ByteBuffer.allocateDirect(textureCoord.length * 4);
                    this.mByteBufTex.order(ByteOrder.nativeOrder());
                    this.mBufferTex = this.mByteBufTex.asFloatBuffer();
                }
                this.mBufferTex.rewind();
                this.mBufferTex.put(textureCoord);
                this.mBufferTex.position(0);
                GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferTex);
                GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
                GLES20.glDrawArrays((int)4, (int)0, (int)(textureCoord.length / 2));
            }
            this.disableDrawArray();
        }
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }
}

