/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.lightskin;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.BaseSkinComposeFilter;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.lightskin.BoxFilter;
import com.momo.mcamera.mask.lightskin.HighContrastFilter;
import com.momo.mcamera.mask.lightskin.LightSkinSmoothFilter;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class LightSkinSmoothGroupFilter
extends BaseSkinComposeFilter
implements FaceDetectInterface {
    NormalFilter normalFilter = new NormalFilter();
    BoxFilter box1Filter = new BoxFilter();
    BoxFilter box3Filter = new BoxFilter();
    HighContrastFilter highContrastFilter = new HighContrastFilter();
    LightSkinSmoothFilter smoothExtFilter = new LightSkinSmoothFilter();

    public LightSkinSmoothGroupFilter() {
        this.normalFilter.addTarget((GLTextureInputRenderer)this.box1Filter);
        this.normalFilter.addTarget((GLTextureInputRenderer)this.highContrastFilter);
        this.box1Filter.addTarget((GLTextureInputRenderer)this.highContrastFilter);
        this.highContrastFilter.registerFilterLocation((GLTextureOutputRenderer)this.normalFilter);
        this.highContrastFilter.registerFilterLocation((GLTextureOutputRenderer)this.box1Filter);
        this.highContrastFilter.addTarget((GLTextureInputRenderer)this.box3Filter);
        this.normalFilter.addTarget((GLTextureInputRenderer)this.smoothExtFilter);
        this.box1Filter.addTarget((GLTextureInputRenderer)this.smoothExtFilter);
        this.box3Filter.addTarget((GLTextureInputRenderer)this.smoothExtFilter);
        this.smoothExtFilter.addTarget((GLTextureInputRenderer)this);
        this.smoothExtFilter.registerFilterLocation((GLTextureOutputRenderer)this.normalFilter);
        this.smoothExtFilter.registerFilterLocation((GLTextureOutputRenderer)this.box1Filter);
        this.smoothExtFilter.registerFilterLocation((GLTextureOutputRenderer)this.box3Filter);
        this.registerInitialFilter(this.normalFilter);
        this.registerFilter((BasicFilter)this.box1Filter);
        this.registerFilter((BasicFilter)this.box3Filter);
        this.registerFilter((BasicFilter)this.highContrastFilter);
        this.registerTerminalFilter((BasicFilter)this.smoothExtFilter);
    }

    @Override
    public void setSmoothLevel(float level) {
        if (this.smoothExtFilter != null) {
            this.smoothExtFilter.setSmoothLevel(level);
        }
    }

    public float getSmoothLevel() {
        return this.smoothExtFilter != null ? this.smoothExtFilter.getSmoothLevel() : 0.0f;
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.smoothExtFilter != null) {
            this.smoothExtFilter.setMMCVInfo(mmcvInfo);
        }
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (!this.getTerminalFilters().contains(source)) {
            int width = Math.min(source.getWidth() / 2, 360);
            int height = Math.min(source.getHeight() / 2, 480);
            this.box1Filter.setRenderSize(width, height);
            this.box3Filter.setRenderSize(width, height);
            this.highContrastFilter.setRenderSize(width, height);
            this.smoothExtFilter.setRenderSize(source.getWidth(), source.getHeight());
        }
        super.newTextureReady(texture, source, newData);
    }
}

