/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.gesture;

import android.os.SystemClock;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.HandGestureDetector;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momo.xeengine.bean.XEGestureInfo;
import com.momo.xeengine.bean.XEHandInfo;
import com.momo.xeengine.xnative.XEHand;
import com.momocv.MMBox;
import com.momocv.handgesture.HandGestureInfo;
import java.util.ArrayList;

public class NewHandGestureDetector
extends CVDetector {
    private MMFrameInfo mmFrame = new MMFrameInfo();

    private HandGestureDetector getDetector() {
        return HandGestureDetector.getInstance();
    }

    @Override
    public void startDetect() {
        this.getDetector().create();
    }

    @Override
    public void stopDetect() {
        this.cancel();
        this.getDetector().release();
    }

    @Override
    public void setDetectInterval(int interval) {
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        long start = SystemClock.uptimeMillis();
        MMCVBoxes boxes = new MMCVBoxes();
        this.mmFrame.setFormat(17);
        this.mmFrame.setStep_(mmcvInfo.width);
        this.mmFrame.setWidth(mmcvInfo.width);
        this.mmFrame.setHeight(mmcvInfo.height);
        byte[] data = mmcvInfo.frameData;
        this.mmFrame.setDataPtr(data);
        this.mmFrame.setDataLen(data.length);
        this.getDetector().setRestoreRotate(mmcvInfo.restoreDegree);
        this.getDetector().setRotateDegree(mmcvInfo.cameraDegree);
        this.getDetector().setFlip(mmcvInfo.isFrontCamera);
        HandGestureInfo handInfo = (HandGestureInfo)this.getDetector().objectDetect((Object)this.mmFrame.getFrame());
        if (handInfo != null) {
            if (MediaModuleGlobalConfig.hasXE()) {
                this.processNewGestureData(handInfo.hand_gesture_results_);
            }
            boxes.setDetectResult(handInfo.hand_gesture_results_);
            if (null != this.gestureDetectorListener) {
                this.gestureDetectorListener.gestureDetect(boxes);
            }
        }
    }

    public void setHandGestureType(int handGestureType) {
        this.getDetector().setHandGestureType(handGestureType);
    }

    private void processNewGestureData(MMBox[] mmBoxes) {
        ArrayList<XEHandInfo> infos = new ArrayList<XEHandInfo>();
        if (mmBoxes != null && mmBoxes.length > 0) {
            int len = mmBoxes.length;
            ArrayList<XEGestureInfo> gestureInfos = new ArrayList<XEGestureInfo>(len);
            for (MMBox box : mmBoxes) {
                if (box == null) continue;
                XEGestureInfo info = new XEGestureInfo();
                info.type = box.class_name_;
                info.bounds = new float[]{box.x_, box.y_, box.width_, box.height_};
                info.score = box.score_;
                gestureInfos.add(info);
            }
            XEHandInfo handInfo = new XEHandInfo();
            handInfo.gestures = gestureInfos;
            infos.add(handInfo);
        }
        XEHand.setHandInfos(infos);
    }
}

