/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.gesture;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.ObjectDetector;
import com.core.glcore.util.CVObjectHelper;
import com.immomo.baseutil.MediaStatisticModel;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.cv.CVObject;
import com.momocv.MMBox;
import com.momocv.objectdetect.ObjectDetectInfo;
import com.momocv.objectdetect.ObjectDetectParams;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class GestureDetector
extends CVDetector {
    private ByteBuffer curByteBuffer;
    private Object waitSignal;
    private Object startSync;
    private boolean running;
    private AtomicBoolean isDetecting;
    private int width;
    private int height;
    private boolean isFrontCamera;
    private int cameraDegree;
    private int detectInterval = 300;
    private RenderHandler mCallbackRenderHandler;
    GestureDetectThread detectThread;
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private ObjectDetectParams detectParams = new ObjectDetectParams();
    private ObjectDetectInfo objectDetectInfo;

    public GestureDetector(CVDetector.GestureDetectorListener listener) {
        this.waitSignal = new Object();
        this.startSync = new Object();
        this.isDetecting = new AtomicBoolean(false);
        this.gestureDetectorListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDetect() {
        ObjectDetector.getInstance().create();
        Object object = this.startSync;
        synchronized (object) {
            if (this.detectThread == null) {
                this.running = true;
                this.detectThread = new GestureDetectThread();
                this.detectThread.setPriority(1);
                this.detectThread.start();
                if (null == this.mCallbackRenderHandler) {
                    this.mCallbackRenderHandler = new RenderHandler(Looper.myLooper());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.isDetecting.get()) {
            return;
        }
        this.width = mmcvInfo.width;
        this.height = mmcvInfo.height;
        this.isFrontCamera = mmcvInfo.isFrontCamera;
        this.cameraDegree = mmcvInfo.cameraDegree;
        this.curByteBuffer = ByteBuffer.wrap(mmcvInfo.frameData);
        Object object = this.waitSignal;
        synchronized (object) {
            this.waitSignal.notify();
        }
    }

    @Override
    public void setGestureDetectorListener(CVDetector.GestureDetectorListener listener) {
        this.gestureDetectorListener = listener;
    }

    @Override
    public void setDetectInterval(int interval) {
        this.detectInterval = interval;
    }

    private void detectGesture() {
        this.isDetecting.set(true);
        long start = SystemClock.elapsedRealtime();
        MMCVBoxes boxes = new MMCVBoxes();
        this.mmFrame.setFormat(17);
        this.mmFrame.setStep_(this.width);
        this.mmFrame.setWidth(this.width);
        this.mmFrame.setHeight(this.height);
        byte[] data = this.curByteBuffer.array();
        this.mmFrame.setDataPtr(data);
        this.mmFrame.setDataLen(data.length);
        this.detectParams.rotate_degree_ = this.cameraDegree;
        this.detectParams.fliped_show_ = this.isFrontCamera;
        this.objectDetectInfo = new ObjectDetectInfo();
        ObjectDetector.getInstance().objectDetect(this.mmFrame.getFrame(), this.detectParams, this.objectDetectInfo);
        boxes.setDetectResult(this.objectDetectInfo.detect_results_);
        long detectUse = SystemClock.elapsedRealtime() - start;
        MediaStatisticModel.getInstance().setGestureDetect(detectUse);
        if (MediaModuleGlobalConfig.hasXE() && XE3DEngine.getInstance().isRunning()) {
            CVObject.setObjectInfos((List)CVObjectHelper.transObjectInfos((MMBox[])this.objectDetectInfo.detect_results_));
        }
        if (this.detectInterval > 0) {
            SystemClock.sleep((long)this.detectInterval);
        }
        this.isDetecting.set(false);
        this.curByteBuffer.clear();
        Message message = new Message();
        message.obj = boxes;
        if (null != this.mCallbackRenderHandler) {
            this.mCallbackRenderHandler.sendMessage(message);
        }
    }

    @Override
    public void stopDetect() {
        this.cancel();
        this.detectThread = null;
        ObjectDetector.getInstance().release();
    }

    @Override
    public void cancel() {
        this.gestureDetectorListener = null;
        this.running = false;
        if (null != this.curByteBuffer) {
            this.curByteBuffer.clear();
        }
        if (this.detectThread != null) {
            try {
                this.detectThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.detectThread = null;
    }

    class RenderHandler
    extends Handler {
        public RenderHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (null != GestureDetector.this.gestureDetectorListener) {
                GestureDetector.this.gestureDetectorListener.gestureDetect((MMCVBoxes)msg.obj);
            }
        }
    }

    private final class GestureDetectThread
    extends Thread {
        public GestureDetectThread() {
            super("GestureDetect");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GestureDetector.this.running = true;
            try {
                Object object = GestureDetector.this.waitSignal;
                synchronized (object) {
                    while (GestureDetector.this.running) {
                        GestureDetector.this.waitSignal.wait();
                        GestureDetector.this.detectGesture();
                    }
                }
                GestureDetector.this.curByteBuffer.clear();
                GestureDetector.this.curByteBuffer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

