/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.core.glcore.cv.MMFrameInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.MmcvImageLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.EffectTimeBean;

public class StickerItem {
    private final int STICKER_MMTIME_PER_FRAME = 50;
    public Sticker sticker;
    public float stickerScale;
    public FloatBuffer vertexBuffer;
    public float[] texData0;
    public final float[] mViewMatrix = new float[16];
    protected float[] mProjectionMatrix;
    protected boolean needUpdateSticker = false;
    public float imageWidth = 0.0f;
    public float imageHeight = 0.0f;
    public long mStickerDuration = -1L;
    public Object maskLock = new Object();
    protected Context context;
    long mRenderTime = -1L;
    public FloatBuffer fvertexBuffer;
    public FloatBuffer vertexBuffer2;
    public Object maskListLock = new Object();
    public List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    public boolean isDraw = false;
    private boolean lastShouldShow = true;
    private boolean hasShowed = false;
    private boolean isPlaying;
    public boolean isTriggered = false;
    private int hiddenFrameCount;
    private boolean isHiddenFrame;
    long startTime = -1L;
    public StickerBlendFilter.StickerMaskFinishListener finishListener;
    StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener;
    public MMFrameInfo mmcvImage;
    protected MmcvImageLoader mmcvImageLoader;
    public int texture_sticker = 0;
    private boolean hasShowedThisTrigger;
    private boolean needPlayLoop = true;
    private EffectTimeBean mEffectTimeBean = null;
    private long lastRenderTime = 0L;

    public StickerItem(Sticker inSticker, Context context) {
        this.sticker = inSticker;
        this.context = context;
        this.initCoordinate();
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    public void initCoordinate() {
        float realWidth = 0.5f;
        this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        float[] squareCoords = new float[]{-realWidth, realWidth * this.stickerScale, -realWidth, -realWidth * this.stickerScale, realWidth, -realWidth * this.stickerScale, realWidth, realWidth * this.stickerScale};
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb2.order(ByteOrder.nativeOrder());
        this.vertexBuffer2 = bb2.asFloatBuffer();
        this.vertexBuffer2.put(squareCoords);
        this.vertexBuffer2.position(0);
        this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
        this.mmcvImageLoader = this.getMMcvImageLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        boolean isCVTriggered = true;
        if (null != param.filterTrigerManager) {
            isCVTriggered = param.filterTrigerManager.triggerTypeProcess(this.sticker, this.stickerStateChangeListener);
        }
        if (!(!isCVTriggered || TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType()) && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            isCVTriggered = param.filterTrigerManager.objectTriggerTypeProcess(this.sticker, param, this.isTriggered);
        }
        boolean shouldShow = isCVTriggered;
        if (!(this.sticker.getMinHiddenFrameCount() <= 0 || this.sticker.getHiddenTriggerType() <= 0 && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            if (!shouldShow && this.lastShouldShow) {
                this.isHiddenFrame = true;
            }
            if (this.sticker.isNotResetOnHide() && !shouldShow && this.hiddenFrameCount > 0) {
                this.hiddenFrameCount = 0;
            }
            if (this.isHiddenFrame) {
                if (this.sticker.getMinHiddenFrameCount() > 0 && this.hiddenFrameCount >= this.sticker.getMinHiddenFrameCount() + 2) {
                    this.hiddenFrameCount = 0;
                    this.isHiddenFrame = false;
                }
                if (this.isHiddenFrame) {
                    shouldShow = false;
                    if (this.checkUpdateHidenFrameCnt()) {
                        ++this.hiddenFrameCount;
                    }
                }
            }
        }
        if (this.hasShowedThisTrigger && (this.sticker.isNotHiddenAfterTrigger() || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
            shouldShow = true;
        }
        if (this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.getLoopStart() == -1) {
            this.needPlayLoop = false;
        }
        if (shouldShow) {
            if (isCVTriggered && this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1) {
                this.sticker.curIndex = 0;
            }
            if (!this.needPlayLoop) {
                return;
            }
            this.startPlay();
            this.hasShowed = true;
            this.lastShouldShow = true;
            this.isHiddenFrame = false;
        } else {
            if (this.sticker.isNotHiddenAfterTrigger()) {
                this.lastShouldShow = shouldShow;
            }
            if (this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.curIndex > 0) {
                shouldShow = true;
                this.sticker.curIndex = 0;
                this.resumeDisplay();
            } else if (this.sticker.isNoBreakLoop() && this.sticker.curIndex < this.sticker.getFrameNumber() - 1 && this.hasShowed && this.sticker.curIndex > 0 && this.needPlayLoop) {
                shouldShow = true;
                this.resumeDisplay();
            } else {
                if (!(this.sticker.curIndex != this.sticker.getFrameNumber() - 1 || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
                    this.sticker.curIndex = 0;
                }
                this.stopPlay();
            }
        }
        if (shouldShow) {
            this.hasShowedThisTrigger = true;
        }
        if (null != this.stickerStateChangeListener && !TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType())) {
            this.stickerStateChangeListener.stickerGestureTypeChanged(this.sticker.getObjectTriggerType(), shouldShow);
        }
        if (this.mStickerDuration > -1L && this.startTime != -1L && System.currentTimeMillis() - this.startTime > this.mStickerDuration) {
            this.clearPoints();
            if (null != this.finishListener) {
                this.finishListener.stickerRenderFinished();
            }
            return;
        }
        Object object = this.maskLock;
        synchronized (object) {
            this.setParamForMatrix(param.scaleW, param.scaleH, param.centerPoint, param.angle);
            this.isDraw = shouldShow;
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public Object getLockObject() {
        return this.maskLock;
    }

    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle) {
        if (centerPoint == null) {
            return;
        }
        float sX = w;
        float sY = h;
        float tX = -(centerPoint.x * 2.0f - 1.0f);
        float tY = -centerPoint.y * 2.0f + 1.0f;
        float tAngle = angle;
        float[] mvpMatrix = new float[16];
        float[] newResult = new float[16];
        Matrix.setIdentityM((float[])newResult, (int)0);
        Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
        Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
        float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
        this.mvpLists.add(finalResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        Object object = this.maskLock;
        synchronized (object) {
            if (this.mvpLists != null) {
                this.mvpLists.clear();
            }
        }
    }

    public void startPlay() {
        if (this.sticker.isNotResetOnHide() && this.sticker.curIndex == 0 && this.hasShowed) {
            this.sticker.curIndex = this.sticker.getLoopStart();
        }
        if (!this.isPlaying) {
            if (null != this.stickerStateChangeListener && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), true);
            }
            this.isPlaying = true;
        }
        this.isPlaying = true;
    }

    private void resumeDisplay() {
        this.startPlay();
    }

    public void stopPlay() {
        if (this.isPlaying) {
            if (null != this.stickerStateChangeListener && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), false);
            }
            this.isPlaying = false;
        }
    }

    public void setFinishListener(StickerBlendFilter.StickerMaskFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void setProjectionMatrix(float[] matrix) {
        this.mProjectionMatrix = matrix;
    }

    public MMFrameInfo getMmcvImage(Context context) {
        return this.mmcvImageLoader.getMmcvImage(context);
    }

    public void setStickerStateChangeListener(StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        this.stickerStateChangeListener = stickerStateChangeListener;
    }

    public float getStickerAspectRatio() {
        if (this.sticker != null) {
            return (float)this.sticker.getImageHeight() * 1.0f / (float)this.sticker.getImageWidth();
        }
        return 1.0f;
    }

    public Bitmap getBitmap() {
        return this.mmcvImageLoader.getDelegateBitmap();
    }

    public long getEscapedTime() {
        if (System.currentTimeMillis() - this.startTime >= this.mStickerDuration) {
            return this.mStickerDuration;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    private boolean checkUpdateHidenFrameCnt() {
        if (this.mRenderTime - this.lastRenderTime > 50L) {
            this.lastRenderTime = this.mRenderTime;
            return true;
        }
        return false;
    }

    public void setRenderTime(long mRenderTime) {
        this.mRenderTime = mRenderTime;
        if (this.mmcvImageLoader != null) {
            this.mmcvImageLoader.setRenderTime(mRenderTime);
        }
    }

    public void setCurrentTime(long currentTime) {
        if (this.mmcvImageLoader != null) {
            this.mmcvImageLoader.setCurrentTime(currentTime);
        }
    }

    protected MmcvImageLoader getMMcvImageLoader() {
        if (this.sticker.isUseImageCache()) {
            return new MmcvImageCacheLoader(this.sticker, this.context);
        }
        return new MmcvImageLoader(this.sticker);
    }

    public void destroy() {
        if (this.texture_sticker != 0) {
            int[] tex = new int[]{this.texture_sticker};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_sticker = 0;
        }
    }

    public void releaseFrameBuffer() {
        if (this.texture_sticker != 0) {
            int[] tex = new int[]{this.texture_sticker};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_sticker = 0;
        }
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdateSticker = needUpdate;
    }

    public void setEffectTimeInfo(EffectTimeBean time) {
        this.mEffectTimeBean = time;
    }

    public EffectTimeBean getEffectTimeBean() {
        return this.mEffectTimeBean;
    }
}

