/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerItem;

public class StickerHaniItem
extends StickerItem {
    public FaceDetectFilter.FaceDetectParam mFaceParam;
    private int stickerCount = this.sticker.getFrameNumber();
    private int stickerIndex = 0;
    private int frameRate = this.sticker.getFrameRate();
    private long haniStartTime = 0L;

    public StickerHaniItem(Sticker inSticker, Context context) {
        super(inSticker, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        Object object = this.maskLock;
        synchronized (object) {
            this.setParamForMatrix(param.scaleW, param.scaleH, param.centerPoint, param.angle);
            this.isDraw = true;
            if (this.mFaceParam == null) {
                this.mFaceParam = new FaceDetectFilter.FaceDetectParam();
            }
            this.mFaceParam = param;
        }
    }

    @Override
    public void setRenderTime(long ms) {
        if (ms < this.haniStartTime) {
            this.haniStartTime = ms;
        }
        if (this.haniStartTime == 0L) {
            this.haniStartTime = ms;
        }
        int index = (int)((ms - this.haniStartTime) / (long)(1000 / this.frameRate));
        this.stickerIndex = index % this.stickerCount;
        this.clearPoints();
        this.setDetectParam(this.mFaceParam);
    }

    @Override
    public MMFrameInfo getMmcvImage(Context context) {
        String indexPath = this.sticker.getImagePathByIndex(context, this.stickerIndex);
        if (this.mmcvImage == null) {
            this.mmcvImage = new MMFrameInfo();
            Bitmap bmp = BitmapFactory.decodeFile((String)indexPath);
            if (this.mmcvImage.getDataPtr() == null) {
                this.mmcvImage.setDataPtr(new byte[bmp.getHeight() * bmp.getHeight() * 4]);
            }
            bmp.recycle();
            Object var3_3 = null;
        }
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.mmcvImage, (String)indexPath);
        return this.mmcvImage;
    }
}

