/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.Matrix;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerMaskFilter;

public class StickerGestureMaskFilter
extends StickerMaskFilter {
    private static final float DEFAULT_GESTURE_WIDTH = 180.0f;
    private boolean hasGestureRect = false;
    private RectF currentRect = null;
    private PointF currentCenter = null;

    public StickerGestureMaskFilter(Context context, Sticker sticker) {
        super(context, sticker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (this.hasGestureRect) {
            if (detectParam.gestureRect == null) {
                detectParam.gestureRect = this.currentRect;
            }
        } else if (detectParam.gestureRect != null) {
            this.currentRect = detectParam.gestureRect;
            this.hasGestureRect = true;
        }
        if (this.currentRect == null) {
            return;
        }
        Object object = this.maskListLock;
        synchronized (object) {
            float width = this.currentRect.right - this.currentRect.left;
            float height = this.currentRect.bottom - this.currentRect.top;
            float scale = width / 180.0f;
            float defaultDrawWidth = (float)this.getWidth() / 2.0f;
            float imageScale = (float)this.sticker.getImageWidth() * this.getAdjustWidthScale() / defaultDrawWidth;
            scale *= imageScale;
            PointF centerPoint = null;
            detectParam.points8 = new float[8];
            detectParam.points8[0] = this.currentRect.left;
            detectParam.points8[1] = this.currentRect.right;
            detectParam.points8[2] = this.currentRect.left;
            detectParam.points8[3] = this.currentRect.right;
            detectParam.points8[4] = this.currentRect.top;
            detectParam.points8[5] = this.currentRect.top;
            detectParam.points8[6] = this.currentRect.bottom;
            detectParam.points8[7] = this.currentRect.bottom;
            if (null != detectParam.points8 && null != this.sticker.getPointIndexes() && this.sticker.getPointIndexes().length > 1) {
                int pointIndex1 = this.sticker.getPointIndexes()[0];
                int pointIndex2 = this.sticker.getPointIndexes()[1];
                float pX1 = detectParam.points8[pointIndex1];
                float pY1 = detectParam.points8[pointIndex1 + 4];
                float pX2 = detectParam.points8[pointIndex2];
                float pY2 = detectParam.points8[pointIndex2 + 4];
                centerPoint = this.getCenterPoint(new PointF(pX1, pY1), new PointF(pX2, pY2));
                centerPoint = new PointF(centerPoint.x / (float)this.getWidth(), centerPoint.y / (float)this.getHeight());
            } else {
                centerPoint = new PointF((this.currentRect.left + width / 2.0f) / (float)this.getWidth(), (this.currentRect.top + height / 2.0f) / (float)this.getHeight());
            }
            this.setParamForMatrix(scale, scale, centerPoint, 0.0f, detectParam.filterTrigerManager);
        }
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return 1.5f;
    }

    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, FilterTriggerManager filterTrigerManager) {
        float sX = w;
        float sY = h;
        float tX = -(centerPoint.x * 2.0f - 1.0f);
        float tY = -centerPoint.y * 2.0f + 1.0f;
        float tAngle = angle;
        centerPoint.x = tX;
        centerPoint.y = tY;
        float[] mvpMatrix = new float[16];
        float[] newResult = new float[16];
        Matrix.setIdentityM((float[])newResult, (int)0);
        Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
        Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
        float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
        this.mvpLists.add(finalResult);
    }

    public PointF getCenterPoint(PointF pointA, PointF pointB) {
        float deltalx = pointA.x + (pointB.x - pointA.x) / 2.0f;
        float deltaly = pointA.y + (pointB.y - pointA.y) / 2.0f;
        return new PointF(deltalx, deltaly);
    }

    @Override
    public void pauseBitmapCache() {
        super.pauseBitmapCache();
        if (null != this.sticker) {
            this.sticker.curIndex = 0;
            this.hasGestureRect = false;
            this.currentRect = null;
        }
    }
}

