/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import java.util.ArrayList;
import java.util.List;

public class StickerGameEngine {
    public List<StickerGameItem> stickerItemList = new ArrayList<StickerGameItem>();
    public List<Trajectory> trajectoryList = new ArrayList<Trajectory>();
    public int stickerNumbers = 5;
    public int columnNumber = 10;
    private int stickerGroupCount = 0;
    private int mCoreNumber = 0;
    float mousePosLeftTopX = 0.0f;
    float mousePosLeftTopY = 0.0f;
    float mousePosRightBottomY = 0.0f;
    float mousePosRightBottomX = 0.0f;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private float srcImageWidthScaleRatio = 0.0f;
    private float srcImageHeightScaleRatio = 0.0f;
    private float stickWidthScaleRatio = 0.8f;
    private float stickHeightScaleRatio = 0.8f;
    private List<Float> notUsedTrajectory;
    private List<Float> usedTrajectory;

    public StickerGameEngine() {
        for (int i = 0; i < this.stickerNumbers; ++i) {
            this.generateNewTrajectory(i);
        }
    }

    private void generateTrajectoryXPosition() {
        if (this.notUsedTrajectory == null) {
            this.notUsedTrajectory = new ArrayList<Float>();
            this.usedTrajectory = new ArrayList<Float>();
        } else {
            this.notUsedTrajectory.clear();
            this.usedTrajectory.clear();
        }
        if (this.notUsedTrajectory != null && (double)this.srcImageWidthScaleRatio > 0.0) {
            float leftBorder = 0.0f;
            leftBorder = (1.0f - this.srcImageWidthScaleRatio) / 2.0f + 0.15f;
            float steps = (1.0f - leftBorder * 2.0f) / (float)this.columnNumber;
            float startValue = leftBorder;
            for (int i = 0; i < this.columnNumber; ++i) {
                this.notUsedTrajectory.add(new Float(startValue += steps));
            }
        }
    }

    public void addSticker(StickerGameItem item) {
        if (item.sticker.isGameSticker) {
            this.stickerItemList.add(item);
            if (item.isGameLive) {
                ++this.stickerGroupCount;
            }
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.imageHeight == 640.0f) {
            return 1.0f;
        }
        return (float)this.imageHeight * 1.0f / 640.0f;
    }

    public synchronized void setTimeStamp(long ms) {
        if (this.notUsedTrajectory == null || this.imageWidth == 0) {
            return;
        }
        this.updateTrajectory(ms);
        for (Trajectory trajectory : this.trajectoryList) {
            for (StickerGameItem stickerGameItem : this.stickerItemList) {
                if (stickerGameItem.sticker.groupNumber != trajectory.bindStickerGroup || (!trajectory.isFixed || stickerGameItem.isGameLive) && (trajectory.isFixed || !stickerGameItem.isGameLive)) continue;
                if (!trajectory.isTriggered) {
                    this.isTriggerRegionMatches(stickerGameItem, trajectory);
                }
                float scale = this.getAdjustHeightScale() * 2.0f;
                this.stickWidthScaleRatio = 0.1f;
                stickerGameItem.setParamForMatrix(scale * this.stickWidthScaleRatio, scale * this.stickWidthScaleRatio, new PointF(trajectory.xPosition, trajectory.yPosition), 0.0f);
            }
        }
        this.mousePosLeftTopX = 0.0f;
        this.mousePosLeftTopY = 0.0f;
        this.mousePosRightBottomY = 0.0f;
        this.mousePosRightBottomX = 0.0f;
    }

    public void updateTrajectory(long ms) {
        for (Trajectory trajectory : this.trajectoryList) {
            if (trajectory.startTime == 0L) {
                trajectory.startTime = ms;
            }
            if (trajectory.fixedFrames == trajectory.maxFixFrames) {
                if (this.stickerItemList.size() > trajectory.bindStickerGroup * 2) {
                    StickerGameItem item = this.stickerItemList.get(trajectory.bindStickerGroup * 2 + 1);
                    item.sticker.curIndex = 0;
                    trajectory.reset();
                } else {
                    trajectory.needRandomStickerGroup = true;
                    trajectory.reset();
                }
            }
            trajectory.duration = (float)(ms - trajectory.startTime) / 1000.0f;
            if (!trajectory.isFixed) {
                if (trajectory.duration > 0.0f) {
                    trajectory.yPosition = trajectory.yPositionOffset + trajectory.velocity * trajectory.duration;
                }
                if (!((double)trajectory.yPosition > 1.1)) continue;
                for (int i = 0; i < this.usedTrajectory.size(); ++i) {
                    Float t = this.usedTrajectory.get(i);
                    if (t.floatValue() != trajectory.xPosition) continue;
                    this.usedTrajectory.remove(i);
                    this.notUsedTrajectory.add(t);
                    break;
                }
                trajectory.reset();
                continue;
            }
            ++trajectory.fixedFrames;
        }
    }

    public void generateNewTrajectory(int index) {
        Trajectory trajectory = new Trajectory();
        trajectory.bindStickerGroup = index;
        this.trajectoryList.add(trajectory);
    }

    public synchronized void updateTriggerStatus(float mousePosLeftTopX, float mousePosLeftTopY, float mousePosRightBottomX, float mousePosRightBottomY) {
        this.mousePosLeftTopX = mousePosLeftTopX;
        this.mousePosLeftTopY = mousePosLeftTopY;
        this.mousePosRightBottomX = mousePosRightBottomX;
        this.mousePosRightBottomY = mousePosRightBottomY;
    }

    private boolean isTriggerRegionMatches(StickerGameItem stickerItem, Trajectory trajectory) {
        float x = trajectory.xPosition * (float)this.imageWidth;
        float y = trajectory.yPosition * (float)this.imageHeight;
        if (this.mousePosLeftTopX < x && this.mousePosRightBottomX > x && this.mousePosRightBottomY > y && this.mousePosLeftTopY < y) {
            if (!stickerItem.isGameLive) {
                trajectory.isTriggered = true;
                stickerItem.startPlay();
                if (stickerItem.gameScoreListener != null && !stickerItem.isGameLive) {
                    stickerItem.gameScoreListener.onItemTriggered(stickerItem.sticker.getAdditionalInfo().getGameScore());
                }
            }
            trajectory.isFixed = true;
            for (int i = 0; i < this.usedTrajectory.size(); ++i) {
                Float t = this.usedTrajectory.get(i);
                if (t.floatValue() != trajectory.xPosition) continue;
                this.usedTrajectory.remove(i);
                this.notUsedTrajectory.add(t);
                break;
            }
        }
        return true;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setSrcImageWidthScaleRatio(float srcImageWidthScaleRatio) {
        if (this.srcImageWidthScaleRatio != srcImageWidthScaleRatio) {
            this.srcImageWidthScaleRatio = srcImageWidthScaleRatio;
            this.generateTrajectoryXPosition();
        }
    }

    public void setSrcImageHeightScaleRatio(float srcImageHeightScaleRatio) {
        this.srcImageHeightScaleRatio = srcImageHeightScaleRatio;
    }

    public void setGameScoreListener(GameScoreListener listener) {
        for (StickerItem stickerItem : this.stickerItemList) {
            ((StickerGameItem)stickerItem).setGameScoreListener(listener);
        }
    }

    class Trajectory {
        int bindStickerGroup;
        float duration;
        float xPosition;
        float yPositionOffset;
        float yPosition;
        float velocity;
        long startTime;
        boolean isFixed = false;
        int fixedFrames = 0;
        int maxFixFrames = 0;
        int coreNumber;
        boolean needRandomStickerGroup = false;
        boolean isTriggered = false;

        Trajectory() {
            StickerGameEngine.this.mCoreNumber++;
            this.coreNumber = StickerGameEngine.this.mCoreNumber;
            this.yPositionOffset = -0.15f * (float)this.coreNumber;
        }

        void reset() {
            if (this.needRandomStickerGroup) {
                this.bindStickerGroup = (int)(Math.random() * 10.0 % (double)StickerGameEngine.this.stickerGroupCount);
            }
            ++this.coreNumber;
            if (this.coreNumber > 5) {
                this.coreNumber = 1;
            }
            this.maxFixFrames = StickerGameEngine.this.stickerItemList.get((int)(this.bindStickerGroup * 2 + 1)).sticker.getFrameNumber();
            this.fixedFrames = 0;
            this.isFixed = false;
            this.duration = 0.0f;
            this.xPosition = (float)Math.random();
            if (StickerGameEngine.this.notUsedTrajectory.size() > 0) {
                int xIndex = (int)(Math.random() * 10.0) % StickerGameEngine.this.notUsedTrajectory.size();
                Float t = (Float)StickerGameEngine.this.notUsedTrajectory.get(xIndex);
                this.xPosition = t.floatValue();
                StickerGameEngine.this.notUsedTrajectory.remove(t);
                StickerGameEngine.this.usedTrajectory.add(t);
            }
            this.velocity = StickerGameEngine.this.stickerItemList.get((int)(this.bindStickerGroup * 2)).downVelocity;
            if (this.isTriggered) {
                this.yPositionOffset = -0.1f * (float)(this.coreNumber + 1) / 2.0f;
                this.velocity = (float)((double)this.velocity - 0.05 * (double)this.coreNumber);
            }
            this.isTriggered = false;
            this.yPosition = this.yPositionOffset;
            this.startTime = 0L;
        }
    }
}

