/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.Etc1Batch;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.batchbean.BatchFrame;
import com.momo.mcamera.mask.batchbean.BatchSize;
import com.momocv.MMFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class StickerEtc1MaskFilter
extends FaceDetectFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    public static final String ATTRIBUTE_POSITION_3 = "position3";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  vec2 coord1 = position3.xy;  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n  textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0 - (coord1.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   color1.a = texture2D(inputImageTexture,textureCoordinate1).r;\n   gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    int textId;
    float stickerScale;
    MMFrame curMMCVImage;
    float[] mvpMatrix;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private FloatBuffer vertexBuffer;
    private FloatBuffer vertexBufferAlpha;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    protected int positionHandle3;
    private boolean isDraw;
    private boolean lockTexture = false;
    private Etc1Batch etc1Batch;
    private String texturePath;
    private ETC1Util.ETC1Texture texture_Etc1;
    private long lastFrameTime = -1L;
    private int curIndex = 0;

    public StickerEtc1MaskFilter(Context context, Sticker sticker) {
        this.sticker = sticker;
        this.initCoordinate();
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.drawListBuffer = dlb.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
        this.getETC1Texture();
    }

    public void initCoordinate() {
        float realWidth = 0.5f;
        String configJson = null;
        String jsonPath = this.sticker.getETC1JsonPath();
        try {
            configJson = FileUtil.readString((File)new File(jsonPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (configJson == null) {
            return;
        }
        this.etc1Batch = Etc1Batch.getEffectModel(configJson);
        this.updateETC1Coordinate();
        this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
    }

    private void updateETC1Coordinate() {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = System.currentTimeMillis();
            this.curIndex = this.sticker.getETC1ImageIndex();
        }
        if (System.currentTimeMillis() - this.lastFrameTime > 50L) {
            this.curIndex = this.sticker.getETC1ImageIndex();
            this.lastFrameTime = System.currentTimeMillis();
        }
        BatchFrame batchFrame = this.etc1Batch.getBatchStickers().get(this.curIndex).getFrame();
        BatchSize batchSize = this.etc1Batch.getBatchMeta().getSize();
        float topLeftX = (float)batchFrame.getImageX() / (float)batchSize.getImageBatchWidth();
        float topLeftY = (float)batchFrame.getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        float bottomLeftX = (float)batchFrame.getImageX() / (float)batchSize.getImageBatchWidth();
        float bottomLeftY = (float)(batchFrame.getImageY() + batchFrame.getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float bottomRightX = (float)(batchFrame.getImageX() + batchFrame.getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float bottomRightY = (float)(batchFrame.getImageY() + batchFrame.getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float topRightX = (float)(batchFrame.getImageX() + batchFrame.getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float topRightY = (float)batchFrame.getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        this.stickerScale = (float)batchFrame.getImageHeight() / (float)batchFrame.getImageWidth();
        float[] squareCoords = new float[]{-0.5f + topLeftX, 0.5f - topLeftY, -0.5f + bottomLeftX, 0.5f - bottomLeftY, -0.5f + bottomRightX, 0.5f - bottomRightY, -0.5f + topRightX, 0.5f - topRightY};
        float[] squareCoords2 = new float[]{-0.5f + topLeftX, -topLeftY, -0.5f + bottomLeftX, -bottomLeftY, -0.5f + bottomRightX, -bottomRightY, -0.5f + topRightX, -topRightY};
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(squareCoords2.length * 4);
        bb2.order(ByteOrder.nativeOrder());
        this.vertexBufferAlpha = bb2.asFloatBuffer();
        this.vertexBufferAlpha.put(squareCoords2);
        this.vertexBufferAlpha.position(0);
    }

    public void setTextId(int textId) {
        this.textId = textId;
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   color1.a = texture2D(inputImageTexture,textureCoordinate1).r;\n   gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  vec2 coord1 = position3.xy;  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n  textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0 - (coord1.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.positionHandle3 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_3);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void passShaderValues(float[] mvpMatrix) {
        this.renderVertices.position(0);
        ByteBuffer bb = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = bb.asFloatBuffer();
        this.fvertexBuffer.put(mvpMatrix);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufferAlpha);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle3);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] mvpMatrix : this.mvpLists) {
                this.passShaderValues(mvpMatrix);
                this.draw();
            }
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        if (this.lockTexture && this.texture_in > 0 && this.mvpLists != null && this.mvpLists.size() > 0) {
            this.isDraw = true;
        } else if (this.mvpLists != null && this.mvpLists.size() > 0) {
            if (!this.isDraw) {
                this.clearPoints();
            }
            if (this.texture_Etc1 != null) {
                if (this.texture_in == 0) {
                    this.texture_in = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)this.texture_Etc1);
                }
                this.updateETC1Coordinate();
                this.isDraw = true;
            } else {
                this.isDraw = false;
            }
        } else {
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float ratio = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / ratio), (float)(1.0f / ratio), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, float[] points, float[] points96, float[] points104, FilterTriggerManager filterTrigerManager) {
        Object object = this.maskListLock;
        synchronized (object) {
            if (centerPoint == null) {
                return;
            }
            float sX = w;
            float sY = h;
            float tX = -(centerPoint.x * 2.0f - 1.0f);
            float tY = -centerPoint.y * 2.0f + 1.0f;
            float tAngle = angle;
            centerPoint.x = tX;
            centerPoint.y = tY;
            float[] mvpMatrix = new float[16];
            float[] newResult = new float[16];
            Matrix.setIdentityM((float[])newResult, (int)0);
            Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
            Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
            Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
            float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
            this.mvpLists.add(finalResult);
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        this.setParamForMatrix(detectParam.scaleW, detectParam.scaleH, detectParam.centerPoint, detectParam.angle, detectParam.points68, detectParam.points96, detectParam.points104, detectParam.filterTrigerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
        }
    }

    @Override
    public void cancelDraw() {
        this.isDraw = false;
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = false;
        }
    }

    @Override
    public void pauseBitmapCache() {
    }

    @Override
    public void resumeBitmapCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.sticker = sticker;
            if (this.texture_in != 0) {
                int[] tex = new int[]{this.texture_in};
                GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
                this.texture_in = 0;
            }
            if (null != this.vertexBuffer && null != this.vertexBufferAlpha) {
                this.vertexBuffer.clear();
                this.vertexBufferAlpha.clear();
                this.drawListBuffer.clear();
            }
            this.initCoordinate();
            ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
            dlb.order(ByteOrder.nativeOrder());
            this.drawListBuffer = dlb.asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
        }
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
    }

    public void setTimeStamp(long ms) {
    }

    private ETC1Util.ETC1Texture getETC1Texture() {
        if (this.texturePath == null) {
            this.texturePath = this.sticker.getETC1Path();
            this.texture_Etc1 = this.loadPkmFile(this.texturePath);
        }
        return this.texture_Etc1;
    }

    private ETC1Util.ETC1Texture loadPkmFile(String path) {
        ETC1Util.ETC1Texture textureEtc1 = null;
        try {
            File file = new File(path);
            FileInputStream inputStream = new FileInputStream(file);
            textureEtc1 = ETC1Util.createTexture((InputStream)inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textureEtc1;
    }
}

