/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import java.util.LinkedList;

public class StickerBitmapCache {
    private static final int MAX_CACHE = 5;
    public boolean isLoadNew = false;
    protected Object imageQueenLock = new Object();
    private int readIndex;
    private LinkedList<MMFrameInfo> linkedBlockingDeque;
    private boolean running = false;
    private Sticker sticker;
    private int loopCount = 0;
    private Context context;
    private long startTime = -1L;
    private boolean startLoop = false;
    private Object waitSignal;
    private boolean pauseCache;
    private int lastIndex;
    private long renderTime = -1L;
    int i = 0;
    long now;
    long oldnow;
    int count;
    int t;
    int mRenderFRate = 20;
    long mRenderTime = -1L;
    ImageDelegateProvider imageProvider;
    Bitmap realBitmap;
    MMCVImageCacheManager cacheManager;
    MMFrameInfo oneImage;
    private String imagePath;
    private long lastFrameTime;
    private final int STICKER_MMTIME_PER_FRAME = 66;
    private int lastFrameIndex = 0;

    public StickerBitmapCache(Sticker sticker, Context context, ImageDelegateProvider imageProvider) {
        this.sticker = sticker;
        this.context = context;
        this.imageProvider = imageProvider;
        this.waitSignal = new Object();
        this.linkedBlockingDeque = new LinkedList();
        this.cacheManager = new MMCVImageCacheManager();
        int i = 0;
        while (i < this.getMaxIndex()) {
            this.addNewIndex(context, i);
            this.readIndex = i++;
        }
        this.readIndex = 5;
        ReadBitmapThread readBitmapThread = new ReadBitmapThread();
        readBitmapThread.start();
        this.running = true;
        this.startTime = System.currentTimeMillis();
    }

    public int getMaxIndex() {
        return Math.min(5, this.sticker.getFrameNumber());
    }

    public void addNewIndex(Context context, int index) {
        if (null != this.imageProvider) {
            return;
        }
        int curIndex = index;
        MMFrameInfo bitmap = this.cacheManager.getOneImageBuffer();
        if (bitmap != null) {
            ImageUtils.decodeMMCVImage((MMFrameInfo)bitmap, (String)this.imagePath);
        } else {
            bitmap = new MMFrameInfo();
            bitmap.setDataPtr(null);
        }
        this.linkedBlockingDeque.add(bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNewBitMaps(Context context) {
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.isLoadNew = true;
            int newReadIndex = 0;
            if (this.readIndex + 2 < this.sticker.getFrameNumber() - 1) {
                int i = this.readIndex;
                while (i <= this.readIndex + this.getMaxIndex() / 2) {
                    this.addNewIndex(context, i);
                    newReadIndex = i++;
                }
                this.readIndex = newReadIndex + 1;
            } else {
                int i;
                for (i = this.readIndex; i < this.sticker.getFrameNumber(); ++i) {
                    this.addNewIndex(context, i);
                }
                i = 0;
                while (i < 5) {
                    this.addNewIndex(context, i);
                    newReadIndex = i++;
                }
                this.readIndex = newReadIndex + 1;
            }
            this.isLoadNew = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.startTime = -1L;
            this.startLoop = false;
            this.sticker.curIndex = 0;
            this.linkedBlockingDeque.clear();
            this.realBitmap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseCache() {
        if (this.pauseCache) {
            return;
        }
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.pauseCache = true;
            this.linkedBlockingDeque.clear();
            this.realBitmap = null;
        }
    }

    public void resumeCache() {
        this.pauseCache = false;
    }

    public Bitmap getRealBitmap() {
        if (this.imageProvider != null) {
            if (this.realBitmap == null) {
                this.realBitmap = this.imageProvider.getRealBitmap();
            }
            return this.realBitmap;
        }
        return null;
    }

    public MMFrameInfo getBitmap() {
        if (this.imageProvider != null) {
            return null;
        }
        long curTime = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = curTime;
        }
        if (this.pauseCache) {
            return null;
        }
        MMFrameInfo bitmap = null;
        if (this.oneImage == null) {
            this.imagePath = this.sticker.getImagePath(this.context);
            ImageUtils.decodeMMCVImage(bitmap, (String)this.imagePath);
            this.lastFrameTime = this.mRenderTime == -1L ? curTime : this.mRenderTime;
        } else {
            long duration;
            long l = duration = this.mRenderTime == -1L ? curTime - this.lastFrameTime : this.mRenderTime - this.lastFrameTime;
            if (duration > 66L) {
                this.imagePath = this.sticker.getImagePath(this.context);
                this.lastFrameTime = this.mRenderTime == -1L ? curTime : this.mRenderTime;
            }
            ImageUtils.decodeMMCVImage(bitmap, (String)this.imagePath);
        }
        bitmap = this.oneImage;
        if (null != bitmap) {
            // empty if block
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.waitSignal;
        synchronized (object) {
            this.running = false;
            this.waitSignal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStickers(Sticker sticker) {
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.startLoop = false;
            this.startTime = System.currentTimeMillis();
            this.linkedBlockingDeque.clear();
            this.sticker = sticker;
        }
    }

    public void release() {
        if (this.cacheManager != null) {
            this.cacheManager.clear();
        }
        if (this.oneImage != null) {
            this.oneImage = null;
        }
    }

    public void setRenderTime(long mRenderTime) {
        this.mRenderTime = mRenderTime;
    }

    private final class ReadBitmapThread
    extends Thread {
        private boolean reading = true;

        private ReadBitmapThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StickerBitmapCache.this.running = true;
            try {
                Object object = StickerBitmapCache.this.waitSignal;
                synchronized (object) {
                    while (this.reading && StickerBitmapCache.this.running) {
                        StickerBitmapCache.this.waitSignal.wait();
                        if (!StickerBitmapCache.this.running) continue;
                        StickerBitmapCache.this.readNewBitMaps(StickerBitmapCache.this.context);
                    }
                }
                StickerBitmapCache.this.linkedBlockingDeque.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.reading = false;
            }
            finally {
                StickerBitmapCache.this.linkedBlockingDeque.clear();
                StickerBitmapCache.this.linkedBlockingDeque = null;
            }
        }
    }

    class MMCVImageCacheManager {
        MMFrameInfo[] cacheArray = new MMFrameInfo[5];
        int mmcvImageDataSize = 0;
        int curIndex = 0;
        int totalSize = 5;

        MMCVImageCacheManager() {
            this.updateImageArray();
        }

        private void updateImageArray() {
            for (int i = 0; i < this.totalSize; ++i) {
                this.cacheArray[i] = new MMFrameInfo();
                MMFrameInfo image = this.cacheArray[i];
            }
        }

        public void setMmcvImageDataSize(int mmcvImageDataSize) {
            this.mmcvImageDataSize = mmcvImageDataSize;
            this.updateImageArray();
        }

        public MMFrameInfo getOneImageBuffer() {
            MMFrameInfo img = this.cacheArray[this.curIndex];
            this.curIndex = (this.curIndex + 1) % this.totalSize;
            return img;
        }

        public void clear() {
            if (this.cacheArray != null) {
                for (int i = 0; i < this.totalSize; ++i) {
                    MMFrameInfo image = this.cacheArray[i];
                    if (image == null) continue;
                    image = null;
                }
                this.mmcvImageDataSize = 0;
            }
        }
    }
}

