/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.core.glcore.util.FileUtil;
import com.google.gson.annotations.SerializedName;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.bean.StickerAdditionalInfo;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import com.momo.xeengine.XE3DEngine;
import java.io.File;

public class Sticker {
    public static final String LAYER_TYPE_DEFAULT = "default";
    public static final String LAYER_TYPE_FACE = "face";
    public static final String LAYER_TYPE_GESTURE = "object_follower";
    public static final String LAYER_TYPE_NATIVE = "native";
    public static final String GESTURE_TYPE_HEART = "heart";
    public static final String GESTURE_TYPE_YEARH = "yearh";
    public static final String GESTURE_TYPE_ONE = "one";
    public static final String FACE_3D_MASK_TYPE = "3d";
    public static final int TYPE_FACE = 0;
    public static final int TYPE_FIXED = 1;
    public static final int TYPE_FULL_SCREEN_FIXED = 2;
    public static final int TYPE_SCALE_TO_FILL = 3;
    public static final int TYPE_ABSOLUTION_POSITION = 5;
    public static final int TYPE_ABS_POSITION_USE_STICKER_DIM = 6;
    public static final int TYPE_ABS_POSITION_ADJUST_RESOLUTION = 7;
    public static final int TYPE_SCALE_CENTER_CROP = 99;
    public static final String STICKER_TYPE_WATERMARK = "STICKER_TYPE_WATERMARK";
    public static final String FACE_MASK_TYPE = "FACE_MASK_TYPE";
    public static final String FACE_LOOK_UP_TYPE = "FACE_LOOK_UP_TYPE";
    public static final String STICKER_TYPE_VOICE = "STICKER_TYPE_VOICE";
    public static final String STICKER_TYPE_GAME_FIX_TYPE = "STICKER_TYPE_GAME_FIX_TYPE";
    public static final String STICKER_TYPE_DELEGATE_STICKER = "weex";
    public static final String RESOURCE_TYPE_AUDIO_VISUALIZER = "audio_visualizer";
    public static final float FACE_DEFAULT_WIDTH = 180.0f;
    public static final int TRIGGER_TYPE_MOUSE = 1;
    public static final int TRIGGER_FACE = 1;
    public static final int TRIGGER_EYE_CLASSIFY = 2;
    public static final int TRIGGER_ACTIVE_FACE_EXPRESSION = 4;
    public static final int TRIGGER_OBJECT_GESTURE = 8;
    public static final int TRIGGER_OBJECT_GESTURE_TRACKING = 16;
    public static final int TRIGGER_EXPRESSION = 32;
    public int curIndex = 0;
    private int modelType;
    private String name;
    private String stickerType;
    private long duration;
    private int loopCount = 0;
    private Mask mask;
    private LookUpModel lookUpModel;
    private int triggerState;
    public boolean isHaniSticker;
    public boolean isGameSticker;
    public boolean isCutFaceSticker;
    public int groupNumber;
    private int soundId = -1;
    private int playingSoundId = -1;
    private int[] triggerRegion;
    private ImageDelegateProvider imageProvider;
    private boolean isPreMultiAlpha;
    private boolean useImageCache = true;
    private int baseDemensionWidth = 360;
    private int baseDemensionHeight = 640;
    private boolean comic = false;
    @SerializedName(value="loopSound")
    private boolean loopSound;
    @SerializedName(value="pointIndexes")
    private int[] pointIndexes;
    @SerializedName(value="layerType")
    private String layerType;
    @SerializedName(value="enable3DAntialiasing")
    private boolean enable3DAntialiasing;
    @SerializedName(value="objectTriggerType")
    private String objectTriggerType;
    @SerializedName(value="type")
    private int type;
    @SerializedName(value="alwaysShow")
    private boolean isAlwaysShow;
    @SerializedName(value="offsetX")
    private int offsetX;
    @SerializedName(value="offsetY")
    private int offsetY;
    @SerializedName(value="looping")
    private int loop;
    @SerializedName(value="loopingIndex")
    private int loopStart;
    @SerializedName(value="frameRate")
    private int frameRate;
    @SerializedName(value="frames")
    private int frameNumber;
    @SerializedName(value="fromTop")
    private boolean showTop;
    @SerializedName(value="clearsBodyArea")
    private boolean clearsBodyArea;
    @SerializedName(value="strokeColor")
    private float[] strokeColor;
    @SerializedName(value="strokeRadius")
    private int strokeRadius;
    @SerializedName(value="noninterruptible")
    private boolean noBreakLoop;
    @SerializedName(value="pointIndex")
    private int facePositionCenter;
    @SerializedName(value="zoomScale")
    private float zoomScale;
    @SerializedName(value="width")
    private int imageWidth;
    @SerializedName(value="height")
    private int imageHeight;
    private String imageFolderPath;
    private String xengineEsPath;
    @SerializedName(value="folder")
    private String imagePreName;
    @SerializedName(value="topAlignIndex")
    private int topAlignIndex;
    @SerializedName(value="bottomAlignIndex")
    private int bottomAlignIndex;
    @SerializedName(value="triggerType")
    private int triggerType;
    @SerializedName(value="hidingTriggerType")
    private int hiddenTriggerType;
    @SerializedName(value="sound")
    private String sound;
    @SerializedName(value="doNotHideAfterTrigger")
    private boolean notHiddenAfterTrigger;
    @SerializedName(value="resourceType")
    private String resourceType;
    @SerializedName(value="donotTrack")
    private boolean donotTrack;
    @SerializedName(value="objectTrackingRegion")
    private ObjectRegion trackingRegion;
    @SerializedName(value="position")
    private AbsolutePosition absolutePos;
    @SerializedName(value="imageType")
    private String extString;
    @SerializedName(value="blendMode")
    private BlendMode blendMode;
    @SerializedName(value="additionalInfo")
    private StickerAdditionalInfo additionalInfo;
    @SerializedName(value="hidingObjectTriggerType")
    private String hiddenObjectTriggerType;
    @SerializedName(value="minimumHiddenFrameCount")
    private int minHiddenFrameCount;
    @SerializedName(value="etcTextureBatch")
    private String etcTextureBatch;
    @SerializedName(value="donotResetOnHide")
    private boolean donotResetOnHide;
    @SerializedName(value="useHandGesture")
    private boolean useHandGestureDetectNewVersion;
    @SerializedName(value="handGestureType")
    private int handGestureType;
    @SerializedName(value="pollTrigger")
    private boolean pollTrigger = false;
    @SerializedName(value="groupNum")
    private int groupNum;
    private int triggerFlag;
    private String imageMaskPath;

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public void updateTriggerFlag(int triggerFlag) {
        this.triggerFlag |= triggerFlag;
    }

    public String getEtcTextureBatch() {
        return this.etcTextureBatch;
    }

    public void setEtcTextureBatch(String etcTextureBatch) {
        this.etcTextureBatch = etcTextureBatch;
    }

    public boolean isNotResetOnHide() {
        return this.donotResetOnHide;
    }

    public void setNotResetOnHide(boolean donotResetOnHide) {
        this.donotResetOnHide = donotResetOnHide;
    }

    public boolean isDonotTrack() {
        return this.donotTrack;
    }

    public void setDonotTrack(boolean donotTrack) {
        this.donotTrack = donotTrack;
    }

    public ObjectRegion getTrackingRegion() {
        return this.trackingRegion;
    }

    public void setTrackingRegion(ObjectRegion trackingRegion) {
        this.trackingRegion = trackingRegion;
    }

    public AbsolutePosition getAbsolutePos() {
        return this.absolutePos;
    }

    public void setAbsolutePos(AbsolutePosition absolutePos) {
        this.absolutePos = absolutePos;
    }

    public StickerAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(StickerAdditionalInfo additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public boolean isNotHiddenAfterTrigger() {
        return this.notHiddenAfterTrigger;
    }

    public void setNotHiddenAfterTrigger(boolean notHiddenAfterTrigger) {
        this.notHiddenAfterTrigger = notHiddenAfterTrigger;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getLayerType() {
        return this.layerType;
    }

    public void setLayerType(String layerType) {
        this.layerType = layerType;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public int getTopAlignIndex() {
        return this.topAlignIndex;
    }

    public void setTopAlignIndex(int topAlignIndex) {
        this.topAlignIndex = topAlignIndex;
    }

    public int getBottomAlignIndex() {
        return this.bottomAlignIndex;
    }

    public void setBottomAlignIndex(int bottomAlignIndex) {
        this.bottomAlignIndex = bottomAlignIndex;
    }

    public int getHiddenTriggerType() {
        return this.hiddenTriggerType;
    }

    public void setHiddenTriggerType(int hiddenTriggerType) {
        this.hiddenTriggerType = hiddenTriggerType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(int frameNumber) {
        this.frameNumber = frameNumber;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getImagePreName() {
        return this.imagePreName;
    }

    public void setImagePreName(String imagePreName) {
        this.imagePreName = imagePreName;
    }

    public int getFacePositionLeft() {
        return 0;
    }

    public int getFacePositionRight() {
        return 16;
    }

    public int getFacePositionCenter() {
        return this.facePositionCenter;
    }

    public void setFacePositionCenter(int facePositionCenter) {
        this.facePositionCenter = facePositionCenter;
    }

    public float getZoomScale() {
        return this.zoomScale;
    }

    public void setZoomScale(int zoomScale) {
        this.zoomScale = zoomScale;
    }

    public float getImageWidthScale() {
        return (float)this.getImageWidth() * this.zoomScale / 180.0f;
    }

    public String getImageFolderPath() {
        return this.imageFolderPath;
    }

    public void setImageFolderPath(String imageFolderPath) {
        this.imageFolderPath = imageFolderPath;
    }

    public String getObjectTriggerType() {
        return this.objectTriggerType;
    }

    public void setObjectTriggerType(String objectTriggerType) {
        this.objectTriggerType = objectTriggerType;
    }

    public String getImagePath(Context context) {
        String indexPath = this.getImagePathByIndex(context, this.curIndex);
        ++this.curIndex;
        if (this.curIndex == this.getFrameNumber()) {
            this.curIndex = this.loopStart;
        }
        return indexPath;
    }

    public int getETC1ImageIndex() {
        ++this.curIndex;
        if (this.curIndex == this.getFrameNumber()) {
            this.curIndex = this.loopStart;
        }
        return this.curIndex;
    }

    public String getETC1Path() {
        String indexPath = this.imageFolderPath + "/" + this.imagePreName + "/" + this.imagePreName + ".pkm";
        return indexPath;
    }

    public String getETC1JsonPath() {
        String jsonPath = this.imageFolderPath + "/" + this.imagePreName + "/" + this.imagePreName + ".json";
        return jsonPath;
    }

    public boolean hasETC1Resource() {
        return FileUtil.exist((String)this.getETC1Path());
    }

    public String getSoundPath() {
        if (!TextUtils.isEmpty((CharSequence)this.sound)) {
            return this.imageFolderPath + "/" + this.imagePreName + "/" + this.sound;
        }
        return null;
    }

    public void setXengineEsPath(String xengineEsPath) {
        this.xengineEsPath = xengineEsPath;
    }

    public String getXengineEsPath() {
        return this.xengineEsPath;
    }

    public String getXengineResRelativePath() {
        return this.imageFolderPath.substring(XE3DEngine.getInstance().getLibraryPath().length() + 1) + File.separator + this.imagePreName;
    }

    public String getFace3DResPath() {
        return this.imageFolderPath + File.separator + this.imagePreName;
    }

    public boolean isLoopSound() {
        return this.loopSound;
    }

    public void setLoopSound(boolean loopSound) {
        this.loopSound = loopSound;
    }

    public String getImagePathByIndex(Context context, int index) {
        String indexStr = "_000";
        indexStr = index < 10 ? "_00" + index : (index < 100 ? "_0" + index : "_" + index);
        if (this.imageFolderPath == null || this.imagePreName == null) {
            return null;
        }
        String imagePath = this.imageFolderPath + "/" + this.imagePreName + "/" + this.imagePreName + indexStr + "." + this.getExtString();
        return imagePath;
    }

    public Bitmap getBitmapWithIndex(Context context, int index) {
        if (index >= this.frameNumber) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        return BitmapFactory.decodeFile((String)this.getImagePathByIndex(context, index), (BitmapFactory.Options)options);
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    public boolean isShowTop() {
        return this.showTop;
    }

    public void setShowTop(boolean showTop) {
        this.showTop = showTop;
    }

    public boolean isClearsBodyArea() {
        return this.clearsBodyArea;
    }

    public void setClearsBodyArea(boolean clearsBodyArea) {
        this.clearsBodyArea = clearsBodyArea;
    }

    public float[] getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(float[] strokeColor) {
        this.strokeColor = strokeColor;
    }

    public int getStrokeRadius() {
        return this.strokeRadius;
    }

    public void setStrokeRadius(int strokeRadius) {
        this.strokeRadius = strokeRadius;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getCenterIndex() {
        return this.facePositionCenter;
    }

    public boolean hasCenterPoint() {
        return null == this.pointIndexes || this.pointIndexes.length < 2;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isAlwaysShow() {
        return this.isAlwaysShow;
    }

    public void setAlwaysShow(boolean alwaysShow) {
        this.isAlwaysShow = alwaysShow;
    }

    public int getLoopStart() {
        return this.loopStart;
    }

    public void setLoopStart(int loopStart) {
        this.loopStart = loopStart;
    }

    public String getStickerType() {
        return this.stickerType;
    }

    public void setStickerType(String stickerType) {
        this.stickerType = stickerType;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(int triggerType) {
        this.triggerType = triggerType;
    }

    public String getImageMaskPath() {
        return this.imageMaskPath;
    }

    public void setImageMaskPath(String imageMaskPath) {
        this.imageMaskPath = imageMaskPath;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public int[] getPointIndexes() {
        return this.pointIndexes;
    }

    public void setPointIndexes(int[] pointIndexes) {
        this.pointIndexes = pointIndexes;
    }

    public boolean isNoBreakLoop() {
        return this.noBreakLoop;
    }

    public void setNoBreakLoop(boolean noBreakLoop) {
        this.noBreakLoop = noBreakLoop;
    }

    public LookUpModel getLookUpModel() {
        return this.lookUpModel;
    }

    public void setLookUpModel(LookUpModel lookUpModel) {
        this.lookUpModel = lookUpModel;
    }

    public int[] getTriggerRegion() {
        return this.triggerRegion;
    }

    public void setTriggerRegion(int[] triggerRegion) {
        this.triggerRegion = triggerRegion;
    }

    public int getPlayingSoundId() {
        return this.playingSoundId;
    }

    public void setPlayingSoundId(int playingSoundId) {
        this.playingSoundId = playingSoundId;
    }

    public int getSoundId() {
        return this.soundId;
    }

    public void setSoundId(int soundId) {
        this.soundId = soundId;
    }

    public int getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(int triggerState) {
        this.triggerState = triggerState;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public int getCurFrameRate() {
        if (this.frameRate > 0) {
            return this.frameRate;
        }
        return 15;
    }

    public String getExtString() {
        return "png";
    }

    public void setExtString(String extString) {
        this.extString = extString;
    }

    public ImageDelegateProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageProvider(ImageDelegateProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    public void setGroupNumber(int groupNumber) {
        this.groupNumber = groupNumber;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public String getHiddenObjectTriggerType() {
        return this.hiddenObjectTriggerType;
    }

    public void setHiddenObjectTriggerType(String hiddenObjectTriggerType) {
        this.hiddenObjectTriggerType = hiddenObjectTriggerType;
    }

    public int getMinHiddenFrameCount() {
        return this.minHiddenFrameCount;
    }

    public void setMinHiddenFrameCount(int minHiddenFrameCount) {
        this.minHiddenFrameCount = minHiddenFrameCount;
    }

    public boolean isEnable3DAntialiasing() {
        return this.enable3DAntialiasing;
    }

    public void setEnable3DAntialiasing(boolean enable3DAntialiasing) {
        this.enable3DAntialiasing = enable3DAntialiasing;
    }

    public boolean isUseImageCache() {
        return this.useImageCache;
    }

    public void setUseImageCache(boolean useImageCache) {
        this.useImageCache = useImageCache;
    }

    public void setBaseDemensionWidth(int width) {
        this.baseDemensionWidth = width;
    }

    public void setBaseDemensionHeight(int height) {
        this.baseDemensionHeight = height;
    }

    public int getBaseDemensionWidth() {
        return this.baseDemensionWidth;
    }

    public int getBaseDemensionHeight() {
        return this.baseDemensionHeight;
    }

    public boolean isPreMultiAlpha() {
        return this.isPreMultiAlpha;
    }

    public void setPreMultiAlpha(boolean preMultiAlpha) {
        this.isPreMultiAlpha = preMultiAlpha;
    }

    public int getTriggerPlayStatus() {
        if (this.getAdditionalInfo() != null) {
            return this.getAdditionalInfo().getTriggerPlayStatus();
        }
        return -1;
    }

    public boolean isUseHandGestureDetectNewVersion() {
        return this.useHandGestureDetectNewVersion;
    }

    public void setUseHandGestureDetectNewVersion(boolean useHandGestureDetectNewVersion) {
        this.useHandGestureDetectNewVersion = useHandGestureDetectNewVersion;
    }

    public int getHandGestureType() {
        return this.handGestureType;
    }

    public void setHandGestureType(int handGestureType) {
        this.handGestureType = handGestureType;
    }

    public int getTriggerFlag() {
        return this.triggerFlag;
    }

    public void setTriggerFlag(int triggerFlag) {
        this.triggerFlag = triggerFlag;
    }

    public boolean isComic() {
        return this.comic;
    }

    public void setComic(boolean comic) {
        this.comic = comic;
    }

    public boolean getPollTrigger() {
        return this.pollTrigger;
    }

    public void setPollTrigger(boolean pollTrigger) {
        this.pollTrigger = pollTrigger;
    }

    public int getGroupNum() {
        return this.groupNum;
    }

    public void setGroupNum(int groupNum) {
        this.groupNum = groupNum;
    }

    public class BlendMode {
        @SerializedName(value="name")
        String name;
    }
}

