/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerCutFaceItem;
import com.momo.mcamera.mask.StickerETC1Item;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerHaniItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.util.PointHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class MultiStickerCutFaceMaskFilter
extends MultiStickerMaskFilter {
    public static final String UNIFORM_BACKGROUND = "bgFlag";
    private float mRadius = 100.0f;
    private PointF mPointF;
    private int mBackGroundHandler;
    private StickerCutFaceItem mCutFaceItem = null;
    private boolean lastHasFace = false;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nuniform mediump float bgFlag;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  if(bgFlag > 0.5){\n     textureCoordinate = position2.xy;\n     return;\n  }\n  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";

    public MultiStickerCutFaceMaskFilter(Context context) {
        super(context);
    }

    @Override
    public void addSticker(Sticker sticker, StickerBlendFilter.StickerStateChangeListener listener) {
        StickerItem item = null;
        if (sticker != null) {
            if (sticker.getEtcTextureBatch() != null) {
                item = new StickerETC1Item(sticker, this.context);
            } else if (sticker.isGameSticker) {
                item = new StickerGameItem(sticker, this.context);
            } else if (sticker.isCutFaceSticker) {
                this.mCutFaceItem = new StickerCutFaceItem(sticker, this.context);
                item = this.mCutFaceItem;
            } else {
                item = sticker.getStickerType() == "STICKER_TYPE_GAME_FIX_TYPE" ? new StickerFixItem(sticker, this.context) : (sticker.isHaniSticker ? new StickerHaniItem(sticker, this.context) : new StickerItem(sticker, this.context));
            }
            item.setStickerStateChangeListener(listener);
            item.mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
            this.addSticker(item);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        for (StickerItem item : this.stickerItemList) {
            if (!(item instanceof StickerHaniItem)) continue;
            item.setRenderTime(ms);
        }
    }

    @Override
    public void drawBackgroundImage() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)1.0f);
        super.setUseETC1(false);
        if (this.textureCoord == null) {
            this.textureCoord = new float[8];
        }
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(this.textureCoord);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(this.textureCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1f((int)this.mBackGroundHandler, (float)1.0f);
        if (this.mCutFaceItem != null) {
            this.drawCutBgBackGround();
        } else {
            this.vertexBufer.position(0);
            this.vertexBufer.put(this.textureCoord);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        GLES20.glUniform1f((int)this.mBackGroundHandler, (float)0.0f);
    }

    private void drawCutBgBackGround() {
        if (this.mCutFaceItem.mCutFaceList != null && this.mCutFaceItem.mCutFaceList.size() > 0) {
            for (float[] mcutFaceList : this.mCutFaceItem.mCutFaceList) {
                this.setRenderVertices(mcutFaceList);
                this.renderVertices.position(0);
                GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
                GLES20.glEnableVertexAttribArray((int)this.positionHandle);
                PointF pointF1 = new PointF(this.mPointF.x - this.mRadius, (float)this.getHeight() - (this.mPointF.y + this.mRadius));
                PointF pointF2 = new PointF(this.mPointF.x + this.mRadius, (float)this.getHeight() - (this.mPointF.y - this.mRadius));
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.textureCoord[0] = pointF1.x / (float)this.getWidth();
                    this.textureCoord[1] = pointF1.y / (float)this.getHeight();
                    this.textureCoord[2] = pointF2.x / (float)this.getWidth();
                    this.textureCoord[3] = pointF1.y / (float)this.getHeight();
                    this.textureCoord[4] = pointF1.x / (float)this.getWidth();
                    this.textureCoord[5] = pointF2.y / (float)this.getHeight();
                    this.textureCoord[6] = pointF2.x / (float)this.getWidth();
                    this.textureCoord[7] = pointF2.y / (float)this.getHeight();
                }
                this.vertexBufer.position(0);
                this.vertexBufer.put(this.textureCoord);
                this.vertexBufer.position(0);
                GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
                GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
                this.lastHasFace = true;
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
            }
            this.mCutFaceItem.clearCutFacePoints();
        } else {
            this.resetBackgroundCanvas();
            this.vertexBufer.position(0);
            this.vertexBufer.put(this.textureCoord);
            if (this.lastHasFace) {
                this.lastHasFace = false;
                return;
            }
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mBackGroundHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BACKGROUND);
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        this.lastStickerTime = System.currentTimeMillis();
        if (mmcvInfo.getMaxFaceCnt() <= 0) {
            this.updateFaceInfo(mmcvInfo, 0.0f, null, false);
        } else {
            if (this.mCutFaceItem != null && mmcvInfo.getMaxFaceCnt() > 0) {
                FaceAttributeInfo info = mmcvInfo.getFaceAttributeInfo(0);
                float[] landmarks68 = info.getLandmarks68();
                PointF pointX = new PointF(landmarks68[18], landmarks68[86]);
                PointF pointY = new PointF(landmarks68[10], landmarks68[78]);
                this.mRadius = (float)PointHelper.getmDistancePoint(pointX, pointY);
                this.mRadius = this.mRadius * 1.1f / 2.0f;
                this.mPointF = new PointF(landmarks68[29], landmarks68[97]);
            }
            for (int j = mmcvInfo.getMaxFaceCnt() - 1; j >= 0; --j) {
                float degree = mmcvInfo.getFaceAttributeInfo(j).getFaceRotateDegree_2d();
                if (this.mCutFaceItem != null) {
                    this.mCutFaceItem.setRenderSize(this.getWidth(), this.getHeight());
                }
                this.updateFaceInfo(mmcvInfo, degree, mmcvInfo.getFaceAttributeInfo(j).getLandmarks68(), true);
            }
        }
    }

    @Override
    public void removeSticker(String stickerType) {
        for (StickerItem item : this.stickerItemList) {
            if (item == this.mCutFaceItem) {
                this.mCutFaceItem = null;
                this.resetBackgroundCanvas();
            }
            if (!item.sticker.getStickerType().equals(stickerType)) continue;
            this.stickerItemDestroyList.add(item);
        }
    }

    @Override
    protected String getVertexShader() {
        return this.vertexShaderCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.drawBackgroundImage();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (this.stickerItemDestroyList.size() > 0) {
            ArrayList destroyList = new ArrayList(this.stickerItemDestroyList);
            for (StickerItem stickerItem : destroyList) {
                stickerItem.destroy();
                this.stickerItemDestroyList.remove(stickerItem);
                this.stickerItemList.remove(stickerItem);
            }
            destroyList.clear();
        }
        for (StickerItem stickerItem : this.stickerItemList) {
            MMFrameInfo bitmap;
            if (!(stickerItem instanceof StickerCutFaceItem) || (bitmap = stickerItem.getMmcvImage(this.context)) != null) continue;
            return;
        }
        for (StickerItem stickerItem : this.stickerItemList) {
            Object object = stickerItem.getLockObject();
            synchronized (object) {
                boolean isETC1Sticker = false;
                stickerItem.imageWidth = this.getWidth();
                stickerItem.imageHeight = this.getHeight();
                if (stickerItem.mvpLists != null && stickerItem.mvpLists.size() > 0 && stickerItem.isDraw) {
                    if (stickerItem instanceof StickerETC1Item) {
                        StickerETC1Item item = (StickerETC1Item)stickerItem;
                        isETC1Sticker = true;
                        if (item.etc1_texture_sticker == 0) {
                            item.etc1_texture_sticker = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)item.texture);
                        }
                        item.updateETC1Coordinate();
                    } else {
                        MMFrameInfo bitmap = stickerItem.getMmcvImage(this.context);
                        if (null != bitmap && bitmap.getDataPtr() != null) {
                            stickerItem.texture_sticker = stickerItem.texture_sticker == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)bitmap) : TextureHelper.loadDataToTexture((int)stickerItem.texture_sticker, (MMFrameInfo)bitmap);
                        } else {
                            Bitmap curBitmap = stickerItem.getBitmap();
                            if (curBitmap != null && !curBitmap.isRecycled()) {
                                if (stickerItem.texture_sticker > 0) {
                                    TextureHelper.updateBitmap((Bitmap)curBitmap, (int)stickerItem.texture_sticker);
                                } else {
                                    stickerItem.texture_sticker = TextureHelper.bitmapToTexture((Bitmap)curBitmap);
                                }
                            }
                        }
                    }
                } else {
                    stickerItem.sticker.curIndex = 0;
                }
                if (stickerItem.isDraw && (stickerItem.texture_sticker != 0 || isETC1Sticker)) {
                    for (float[] mvpMatrix : stickerItem.mvpLists) {
                        this.passStickerShaderValues(stickerItem, mvpMatrix);
                        this.drawStick(stickerItem.getStickerAspectRatio());
                    }
                    stickerItem.clearPoints();
                }
            }
        }
        GLES20.glDisable((int)3042);
    }

    private void resetBackgroundCanvas() {
        this.setRenderVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    }
}

