/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.JsonUtil;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MaskStore {
    private static MaskStore ourInstance = new MaskStore();
    private final String PATH_FOLDER = "stickers";
    private String folderPath;

    private MaskStore() {
    }

    public static MaskStore getInstance() {
        return ourInstance;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    private String getMaskFolder(Context context, String folderName) {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + folderName;
    }

    public List<MaskModel> getGestureMasks(Context context) {
        return this.getMasksByFolderName(context, "MaskG");
    }

    public List<MaskModel> getMasks(Context context) {
        return this.getMasksByFolderName(context, "Mask");
    }

    private List<MaskModel> getMasksByFolderName(Context context, String name) {
        ArrayList<MaskModel> maskModels = new ArrayList<MaskModel>();
        FileUtil.checkFile((String)this.getMaskFolder(context, name));
        Object[] folders = new File(this.getMaskFolder(context, name)).listFiles();
        if (folders == null) {
            return maskModels;
        }
        Arrays.sort(folders);
        for (Object folder : folders) {
            MaskModel maskModel = this.getMask(context, ((File)folder).getPath());
            if (null == maskModel) continue;
            maskModels.add(maskModel);
            for (Sticker sticker : maskModel.getStickers()) {
                sticker.setFrameRate(maskModel.frameRate);
                sticker.setImageFolderPath(((File)folder).getPath());
            }
        }
        return maskModels;
    }

    public MaskModel getMask(Context context, String folderPath) {
        String jsonStr;
        File folder = new File(folderPath);
        MaskModel maskModel = null;
        String jsonPath = folder.getPath() + "/params.txt";
        if (!FileUtil.exist((String)jsonPath)) {
            jsonPath = folder.getPath() + "/params.json";
        }
        if (!TextUtils.isEmpty((CharSequence)(jsonStr = JsonUtil.getInstance().jsonStringFromFile(context, jsonPath)))) {
            try {
                maskModel = (MaskModel)JsonUtil.getInstance().fromJson(jsonStr, MaskModel.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (maskModel.getStickers() == null) {
                maskModel.setStickers(new ArrayList<Sticker>());
            }
            if (FileUtil.exist((String)(folder.getPath() + "/preview.png"))) {
                maskModel.setPreviewPath(folder.getPath() + "/preview.png");
            } else {
                Iterator<Object> iterator = maskModel.getStickers().iterator();
                if (iterator.hasNext()) {
                    Sticker sticker = iterator.next();
                    sticker.setImageFolderPath(folderPath);
                    maskModel.setPreviewPath(sticker.getImagePathByIndex(context, 0));
                }
            }
            if (null != maskModel && !TextUtils.isEmpty((CharSequence)maskModel.getSound())) {
                maskModel.setSoundPath(folder.getPath() + "/" + maskModel.getSound());
            }
            maskModel.setFolderPath(folderPath);
            if (null != maskModel.getLookUpFilters()) {
                for (LookUpModel lookupFilter : maskModel.getLookUpFilters()) {
                    lookupFilter.setPresetFilter(MMPresetFilterStore.getPresetFilterByFolder(context, folder.getPath() + "/" + lookupFilter.getFolder()));
                    Sticker sticker = new Sticker();
                    sticker.setStickerType("FACE_LOOK_UP_TYPE");
                    sticker.setTriggerType(lookupFilter.getTriggerType());
                    sticker.setLookUpModel(lookupFilter);
                    sticker.setHiddenTriggerType(lookupFilter.getHiddenTriggerType());
                    maskModel.getStickers().add(0, sticker);
                }
            }
            if (null != maskModel.getMasks()) {
                for (Mask mask : maskModel.getMasks()) {
                    String pointsPath = folder.getPath() + "/" + mask.getFolder() + "/metadata.json";
                    String jsonPointsStr = JsonUtil.getInstance().jsonStringFromFile(context, pointsPath);
                    Mask mask1 = (Mask)JsonUtil.getInstance().fromJson(jsonPointsStr, Mask.class);
                    if (mask1 == null || mask1.landmarks == null) continue;
                    mask.landmarks = mask1.landmarks;
                    mask.setTexturePath(folder.getPath() + "/" + mask.getFolder() + "/texture.png");
                    Sticker sticker = new Sticker();
                    sticker.setStickerType("FACE_MASK_TYPE");
                    sticker.setTriggerType(mask.getTriggerType());
                    sticker.setHiddenTriggerType(mask.getHiddenTriggerType());
                    sticker.setMask(mask);
                    maskModel.getStickers().add(0, sticker);
                }
            }
            if (null != maskModel.getDistortionList()) {
                for (Mask mask : maskModel.getDistortionList()) {
                    maskModel.setFaceScale(mask.getStrength());
                    maskModel.setFaceFacialFeatureScale(mask.getStrengthB());
                    maskModel.setWrapType(mask.getType());
                    int distortionTriggerType = mask.getTriggerType();
                    int distortionHiddenTriggerType = mask.getHiddenTriggerType();
                    Sticker sticker = new Sticker();
                    sticker.setTriggerType(distortionTriggerType);
                    sticker.setHiddenTriggerType(distortionHiddenTriggerType);
                    sticker.setMask(mask);
                    maskModel.getStickers().add(0, sticker);
                }
            }
            if (null != maskModel.spectrumSticker) {
                maskModel.spectrumSticker.setStickerType("STICKER_TYPE_VOICE");
                maskModel.getStickers().add(maskModel.spectrumSticker);
            }
            for (Sticker sticker : maskModel.getStickers()) {
                sticker.setFrameRate(maskModel.frameRate);
                sticker.setImageFolderPath(folder.getPath());
                if ("3d".equals(sticker.getLayerType())) {
                    String esPath = folderPath.substring(0, folderPath.lastIndexOf("/"));
                    maskModel.setXengineEsPath(esPath);
                    sticker.setXengineEsPath(esPath);
                }
                if (maskModel.getAdditionalInfo() == null) continue;
                sticker.setComic(maskModel.getAdditionalInfo().isComic());
            }
            if (null != maskModel.getEffectList()) {
                for (EffectFilterItem processModel : maskModel.getEffectList()) {
                    processModel.setImageFolderPath(folderPath);
                }
            }
        }
        return maskModel;
    }
}

