/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.Sticker;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ImageMoveStickerMaskFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}    gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    float stickerScale;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private MmcvImageCacheLoader mmcvImageLoader;
    private Context context;
    private FloatBuffer vertexBuffer;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    protected int positionHandle2;
    private boolean isDraw;
    private boolean lockTexture = false;
    private int stickerWidth = 0;
    private int stickerHeight = 0;
    private String imagePath;
    private boolean isPost = false;
    private float PositionX = 0.5f;

    public ImageMoveStickerMaskFilter(Context context, Sticker sticker) {
        this.sticker = sticker;
        this.context = context;
        this.initCoordinate();
    }

    private void initCoordinate() {
        this.updateSticker(this.sticker);
    }

    public void updateSticker(Sticker sticker) {
        if (sticker == null) {
            return;
        }
        this.sticker = sticker;
        this.mmcvImageLoader = new MmcvImageCacheLoader(sticker, this.context);
        if (this.stickerWidth != sticker.getImageWidth() || this.stickerHeight != sticker.getImageHeight()) {
            float realWidth = 0.5f;
            this.stickerWidth = sticker.getImageWidth();
            this.stickerHeight = sticker.getImageHeight();
            this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
            float[] squareCoords = new float[]{-realWidth, realWidth * this.stickerScale, -realWidth, -realWidth * this.stickerScale, realWidth, -realWidth * this.stickerScale, realWidth, realWidth * this.stickerScale};
            ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
            bb.order(ByteOrder.nativeOrder());
            this.vertexBuffer = bb.asFloatBuffer();
            this.vertexBuffer.put(squareCoords);
            this.vertexBuffer.position(0);
            this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
            ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
            dlb.order(ByteOrder.nativeOrder());
            this.drawListBuffer = dlb.asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
            this.mViewMatrix[0] = -1.0f;
        }
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}    gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void passShaderValues(float[] mvpMatrix) {
        this.renderVertices.position(0);
        ByteBuffer bb = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = bb.asFloatBuffer();
        this.fvertexBuffer.put(mvpMatrix);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        if (this.mvpLists == null || this.mvpLists.size() <= 0) {
            if (this.isPost) {
                this.drawPositionSetScaleSize();
            } else {
                this.drawPositionSetFixed();
            }
        }
        if (this.texture_in == 0) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] mvpMatrix : this.mvpLists) {
                this.passShaderValues(mvpMatrix);
                this.draw();
            }
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        if (this.lockTexture && this.texture_in > 0 && this.mvpLists != null && this.mvpLists.size() > 0) {
            this.isDraw = true;
        } else if (this.mvpLists != null && this.mvpLists.size() > 0) {
            if (!this.isDraw) {
                this.clearPoints();
            } else {
                MMFrameInfo mmcvImage = this.mmcvImageLoader.getMmcvImage(this.context);
                this.imagePath = this.mmcvImageLoader.imagePath;
                if (mmcvImage != null && mmcvImage.getDataPtr() != null) {
                    this.texture_in = this.texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mmcvImage) : TextureHelper.loadDataToTexture((int)this.texture_in, (MMFrameInfo)mmcvImage);
                } else {
                    Bitmap bitmap = this.mmcvImageLoader.getDelegateBitmap();
                    if (bitmap != null) {
                        this.deleteTexture();
                        this.texture_in = TextureHelper.bitmapToTexture((Bitmap)bitmap);
                    } else {
                        this.clearPoints();
                    }
                }
            }
            if (this.texture_in == 0) {
                this.clearPoints();
            }
            this.isDraw = true;
        } else {
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float ratio = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / ratio), (float)(1.0f / ratio), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    protected void deleteTexture() {
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle) {
        Object object = this.maskListLock;
        synchronized (object) {
            if (centerPoint == null) {
                return;
            }
            float sX = w;
            float sY = h;
            float tX = -(centerPoint.x * 2.0f - 1.0f);
            float tY = -centerPoint.y * 2.0f + 1.0f;
            float tAngle = angle;
            centerPoint.x = tX;
            centerPoint.y = tY;
            float[] mvpMatrix = new float[16];
            float[] newResult = new float[16];
            Matrix.setIdentityM((float[])newResult, (int)0);
            Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
            Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
            Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
            float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
            this.mvpLists.add(finalResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDraw() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isDraw = false;
        }
    }

    public void destroy() {
        super.destroy();
        this.deleteTexture();
        this.clearPoints();
    }

    private void drawPositionSetFixed() {
        float x = (float)this.getWidth() / 2.0f;
        float y = ((float)this.getHeight() - (float)this.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)this.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF point1 = new PointF(x / (float)this.getWidth(), y / (float)this.getHeight());
        float scaleWidth = 1.5f;
        float scaleHeight = 1.5f;
        if (this.sticker.getImageWidth() > 360) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else if (this.getWidth() == 720) {
            scaleWidth = 2.0f;
            scaleHeight = 2.0f;
        } else {
            scaleWidth = 1.5f;
            scaleHeight = 1.5f;
        }
        float scaleW = scaleWidth;
        float scaleH = scaleHeight;
        PointF centerPoint = point1;
        float angle = 0.0f;
        this.setParamForMatrix(scaleH, scaleW, centerPoint, angle);
    }

    private void drawPositionSetScaleSize() {
        float scaleW = 1.0f;
        float scaleH = 1.0f;
        PointF centerPoint = new PointF(this.PositionX, 0.5f);
        float angle = 0.0f;
        this.setParamForMatrix(scaleH, scaleW, centerPoint, angle);
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() * 1.0f / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    public void setPostWatermark(boolean isPost) {
        this.isPost = isPost;
    }

    public void setPosition(float position) {
        this.PositionX = position;
    }

    public void setTimeStamp(long ms) {
        if (this.mmcvImageLoader != null) {
            this.mmcvImageLoader.setRenderTime(ms);
        }
    }
}

