/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class GLProgram {
    public static final String ATTRIBUTE_POSITION = "position";
    public static final String ATTRIBUTE_TEXCOORD = "inputTextureCoordinate";
    public static final String VARYING_TEXCOORD = "textureCoordinate";
    public static final String UNIFORM_TEXTUREBASE = "inputImageTexture";
    protected boolean initialized = false;
    protected int vertexShaderHandle = 0;
    protected int fragmentShaderHandle = 0;
    protected int programHandle = 0;
    protected int[] textureHandles = null;
    protected int positionHandle = 0;
    protected int[] texCoordHandles = null;
    protected int width = 0;
    protected int height = 0;
    protected int mNumTexture = 0;
    protected int mNumCoord = 0;
    private int type = 4;
    private ByteBuffer mByteBufferVex = null;
    private FloatBuffer mBufferVex = null;
    private ByteBuffer[] mByteBufferTex = null;
    private FloatBuffer[] mBufferTex = null;

    public GLProgram(int numTexture, int numCoord) {
        this.mNumTexture = numTexture;
        this.mNumCoord = numCoord;
        this.textureHandles = new int[numTexture];
        this.texCoordHandles = new int[numCoord];
        this.mByteBufferTex = new ByteBuffer[numCoord];
        this.mBufferTex = new FloatBuffer[numCoord];
    }

    public void setDrawType(int type) {
        this.type = type;
    }

    public void setRenderSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void drawFrame(float[][] triArray, int[] textures) {
        if (!this.initialized) {
            this.initWithGLContext();
            this.initialized = true;
        }
        this.subDrawSub(triArray, textures);
    }

    public void destroy() {
        if (this.programHandle != 0) {
            GLES20.glDeleteProgram((int)this.programHandle);
            this.programHandle = 0;
        }
        if (this.vertexShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.vertexShaderHandle);
            this.vertexShaderHandle = 0;
        }
        if (this.fragmentShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.fragmentShaderHandle);
            this.fragmentShaderHandle = 0;
        }
        this.initialized = false;
    }

    private String attributeCoord() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            sb.append("attribute vec2 inputTextureCoordinate" + i + ";\n");
            sb.append("varying vec2 textureCoordinate" + i + ";\n");
        }
        return sb.toString();
    }

    private String setVaryCoord() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            sb.append(" textureCoordinate" + i + " =  " + ATTRIBUTE_TEXCOORD + i + ";\n");
        }
        return sb.toString();
    }

    protected String getSubVertexShader() {
        String subVertexShader = "attribute vec4 position;\n" + this.attributeCoord() + "void main() {\n" + this.setVaryCoord() + "   gl_Position = " + ATTRIBUTE_POSITION + ";\n}\n";
        return subVertexShader;
    }

    protected abstract String getSubFrameShader();

    protected void bindShaderAttributes() {
        GLES20.glBindAttribLocation((int)this.programHandle, (int)0, (String)ATTRIBUTE_POSITION);
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            GLES20.glBindAttribLocation((int)this.programHandle, (int)(i + 1), (String)(ATTRIBUTE_TEXCOORD + i));
        }
    }

    protected void initShaderHandles() {
        int i;
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION);
        for (i = 0; i < this.textureHandles.length; ++i) {
            this.textureHandles[i] = GLES20.glGetUniformLocation((int)this.programHandle, (String)(UNIFORM_TEXTUREBASE + i));
        }
        for (i = 0; i < this.textureHandles.length; ++i) {
            this.texCoordHandles[i] = GLES20.glGetAttribLocation((int)this.programHandle, (String)(ATTRIBUTE_TEXCOORD + i));
        }
    }

    protected void initWithGLContext() {
        int[] compileStatus;
        String vertexShader = this.getSubVertexShader();
        String fragmentShader = this.getSubFrameShader();
        this.vertexShaderHandle = GLES20.glCreateShader((int)35633);
        String errorInfo = "none";
        if (this.vertexShaderHandle != 0) {
            GLES20.glShaderSource((int)this.vertexShaderHandle, (String)vertexShader);
            GLES20.glCompileShader((int)this.vertexShaderHandle);
            compileStatus = new int[1];
            GLES20.glGetShaderiv((int)this.vertexShaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                errorInfo = GLES20.glGetShaderInfoLog((int)this.vertexShaderHandle);
                GLES20.glDeleteShader((int)this.vertexShaderHandle);
                this.vertexShaderHandle = 0;
            }
        }
        if (this.vertexShaderHandle == 0) {
            throw new RuntimeException(this.toString() + ": Could not create vertex shader. Reason: " + errorInfo);
        }
        this.fragmentShaderHandle = GLES20.glCreateShader((int)35632);
        if (this.fragmentShaderHandle != 0) {
            GLES20.glShaderSource((int)this.fragmentShaderHandle, (String)fragmentShader);
            GLES20.glCompileShader((int)this.fragmentShaderHandle);
            compileStatus = new int[1];
            GLES20.glGetShaderiv((int)this.fragmentShaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                errorInfo = GLES20.glGetShaderInfoLog((int)this.fragmentShaderHandle);
                GLES20.glDeleteShader((int)this.fragmentShaderHandle);
                this.fragmentShaderHandle = 0;
            }
        }
        if (this.fragmentShaderHandle == 0) {
            throw new RuntimeException(this.toString() + ": Could not create fragment shader. Reason: " + errorInfo);
        }
        this.programHandle = GLES20.glCreateProgram();
        if (this.programHandle != 0) {
            GLES20.glAttachShader((int)this.programHandle, (int)this.vertexShaderHandle);
            GLES20.glAttachShader((int)this.programHandle, (int)this.fragmentShaderHandle);
            this.bindShaderAttributes();
            GLES20.glLinkProgram((int)this.programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)this.programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                GLES20.glDeleteProgram((int)this.programHandle);
                this.programHandle = 0;
            }
        }
        if (this.programHandle == 0) {
            throw new RuntimeException("Could not create program.");
        }
        GLES20.glDeleteShader((int)this.vertexShaderHandle);
        GLES20.glDeleteShader((int)this.fragmentShaderHandle);
        this.vertexShaderHandle = 0;
        this.fragmentShaderHandle = 0;
        this.initShaderHandles();
    }

    protected void subDrawSub(float[][] triArray, int[] textures) {
        GLES20.glUseProgram((int)this.programHandle);
        int triangle_size = 0;
        if (triArray != null && triArray.length > 0) {
            triangle_size = triArray[0].length / 6;
        }
        this.passShaderValues(triArray, textures);
        GLES20.glDrawArrays((int)this.type, (int)0, (int)(triangle_size * 3));
        this.disableDrawArray();
    }

    protected void initCoord(float[][] triArray) {
        float[] vertexCoord = triArray[0];
        if (this.mByteBufferVex == null || this.mByteBufferVex.capacity() != vertexCoord.length * 4) {
            this.mByteBufferVex = ByteBuffer.allocateDirect(vertexCoord.length * 4);
            this.mByteBufferVex.order(ByteOrder.nativeOrder());
        }
        if (this.mBufferVex == null) {
            this.mBufferVex = this.mByteBufferVex.asFloatBuffer();
        }
        this.mBufferVex.clear();
        this.mBufferVex.put(vertexCoord);
        this.mBufferVex.flip();
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferVex);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        for (int i = 0; i < this.mByteBufferTex.length; ++i) {
            float[] textCoord = triArray[i + 1];
            if (this.mByteBufferTex[i] == null) {
                this.mByteBufferTex[i] = ByteBuffer.allocateDirect(textCoord.length * 4);
                this.mByteBufferTex[i].order(ByteOrder.nativeOrder());
            }
            if (this.mBufferTex[i] == null) {
                this.mBufferTex[i] = this.mByteBufferTex[i].asFloatBuffer();
            }
            this.mBufferTex[i].clear();
            this.mBufferTex[i].put(textCoord);
            this.mBufferTex[i].flip();
            GLES20.glVertexAttribPointer((int)this.texCoordHandles[i], (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferTex[i]);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandles[i]);
        }
    }

    protected void passShaderValues(float[][] triArray, int[] textures) {
        if (triArray != null && triArray.length > 0) {
            this.initCoord(triArray);
        }
        int tex = 0;
        for (int i = 0; i < textures.length; ++i) {
            switch (i) {
                case 0: {
                    tex = 33985;
                    break;
                }
                case 1: {
                    tex = 33986;
                    break;
                }
                case 2: {
                    tex = 33987;
                    break;
                }
                case 3: {
                    tex = 33988;
                    break;
                }
                case 4: {
                    tex = 33989;
                    break;
                }
                case 5: {
                    tex = 33990;
                    break;
                }
                case 6: {
                    tex = 33991;
                    break;
                }
                case 7: {
                    tex = 33992;
                    break;
                }
                case 8: {
                    tex = 33993;
                }
            }
            GLES20.glActiveTexture((int)tex);
            GLES20.glBindTexture((int)3553, (int)textures[i]);
            GLES20.glUniform1i((int)this.textureHandles[i], (int)(i + 1));
        }
    }

    protected void disableDrawArray() {
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            GLES20.glDisableVertexAttribArray((int)this.texCoordHandles[i]);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }
}

