/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;

public class FaceLightingFilter
extends FaceDetectFilter {
    private int skinLightingScaleHandle;
    private int skinDefaultRGBHandle;
    public float skinLightingScale = 0.0f;
    private int[] skinDefaultRGB = new int[]{0, 0, 0};
    private WhiteningVersionEnum version;

    public FaceLightingFilter(WhiteningVersionEnum version) {
        this.version = version;
    }

    public FaceLightingFilter() {
        this.version = WhiteningVersionEnum.originWhiten;
    }

    protected String getFragmentShader() {
        String fragmentShader = "";
        switch (this.version) {
            case originWhiten: {
                fragmentShader = fragmentShader + "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float skinLightingScale;\nvoid main() {\n    vec4 source = texture2D( inputImageTexture0, textureCoordinate);\n    gl_FragColor = source;\n    if(abs(skinLightingScale - 1.) < 0.01)\n    {\n        return;\n    }\n    vec3 a = log(gl_FragColor.rgb * (skinLightingScale - 1.) + vec3(1., 1., 1.));\n    float b = log(skinLightingScale);\n    gl_FragColor.rgb = a / b;\n}\n";
                break;
            }
            case _8version: {
                fragmentShader = fragmentShader + "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float skinLightingScale;\nuniform vec3 skinDefaultRGB;\nvec3 rgb2yuv(vec3 c)\n{\n    return clamp(vec3(0.299 * c.r + 0.587 * c.g + 0.114 * c.b, -0.169 * c.r - 0.331 * c.g + 0.499 * c.b + 0.5, 0.499 * c.r - 0.418 * c.g - 0.0813* c.b + 0.5), 0., 1.);\n}\nvec3 yuv2rgb(vec3 c)\n{\n    return clamp(vec3(c.r + 1.402 * (c.b - 0.5), c.r - 0.344 * (c.g - 0.5) - 0.714 * (c.b - 0.5), c.r + 1.772 * (c.g - 0.5)), 0., 1.);\n}\nvec3 adjustYUV(vec3 c, float highThreshold)\n{\n    if(c.x < 0.1){\n        c.x = 0.;\n    }else if (c.x > highThreshold){\n        c.x = 1.;\n    }else{\n        c.x = (c.x - 0.1)/(highThreshold - 0.1);\n    }\n    return c;\n}\nvoid main() {\n    vec4 source = texture2D(inputImageTexture0, textureCoordinate);\n    gl_FragColor = source;\n    if(abs(skinLightingScale - 0.1) < 0.05)\n    {\n        return;\n    }\n    vec3 faceYUV = rgb2yuv(skinDefaultRGB);\n    float lightScale = clamp((faceYUV.r - 0.32) * 2.55, 0.6, 1.);\n    vec3 relation = vec3(1.0) - max(skinDefaultRGB - source.xyz, vec3(0.));\n    relation = 1./(1. + exp(24. - 30. * relation));\n    vec3 relation2 = vec3(1.0) - abs(skinDefaultRGB - source.xyz);\n    relation2 = 1./(1. + exp(24. - 30. * relation2));\nfloat minColor = min(min(source.x, source.y), source.z);\ngl_FragColor.xyz = gl_FragColor.xyz - minColor;\nif(gl_FragColor.r > 0. && gl_FragColor.g > 0.){\n    minColor = min(gl_FragColor.g, gl_FragColor.r);\n    gl_FragColor.r = gl_FragColor.r - minColor;\n    gl_FragColor.g = gl_FragColor.g - minColor;\n}\nif(gl_FragColor.b > 0. && gl_FragColor.g > 0.){\n    minColor = min(gl_FragColor.g, gl_FragColor.b);\n    gl_FragColor.b = gl_FragColor.b - minColor;\n    gl_FragColor.g = gl_FragColor.g - minColor;\n}\nif(gl_FragColor.b > 0. && gl_FragColor.r > 0.){\n    minColor = min(gl_FragColor.r, gl_FragColor.b);\n    gl_FragColor.b = gl_FragColor.b - minColor;\n    gl_FragColor.r = gl_FragColor.r - minColor;\n}\nvec3 parameters = lightScale * vec3(1., 0.5, 0.4);\nvec3 delta = gl_FragColor.r * vec3((1.-source.x) * parameters.x, source.y * parameters.y, (1.-source.z) * parameters.z);\ndelta = 0.8 * delta * relation * relation;\ngl_FragColor.xyz = vec3(source.x + delta.x, source.y - delta.y, source.z + delta.z);\n    float param = relation2.x * relation2.y * relation2.z * skinLightingScale;\n    vec3 paramVec = vec3(param*1.4 + 1.05, param*1.2 + 1.05, param + 1.05);\n    vec3 a = log(gl_FragColor.rgb  * (paramVec - vec3(1.)) + vec3(1., 1., 1.));\n    gl_FragColor.rgb = a / log(paramVec);\n}\n";
                break;
            }
        }
        return fragmentShader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkinLightingScale(float skinLightingScale) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.skinLightingScale = skinLightingScale;
        }
    }

    public float getSkinLightLevel() {
        return this.skinLightingScale;
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.skinLightingScaleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinLightingScale");
        this.skinDefaultRGBHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinDefaultRGB");
    }

    protected void passShaderValues() {
        super.passShaderValues();
        if (this.skinLightingScale < 0.0f) {
            this.skinLightingScale = 0.0f;
        }
        switch (this.version) {
            case originWhiten: {
                GLES20.glUniform1f((int)this.skinLightingScaleHandle, (float)(this.skinLightingScale * 5.0f + 1.0f));
                break;
            }
            case _8version: {
                GLES20.glUniform1f((int)this.skinLightingScaleHandle, (float)(this.skinLightingScale + 0.1f));
                GLES20.glUniform3f((int)this.skinDefaultRGBHandle, (float)((float)this.skinDefaultRGB[0] / 255.0f), (float)((float)this.skinDefaultRGB[1] / 255.0f), (float)((float)(this.skinDefaultRGB[2] - 10) / 255.0f));
                break;
            }
        }
    }

    public void drawSub() {
        super.drawSub();
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        int[] skin_thresholds;
        FaceAttributeInfo info = mmcvInfo.getFaceAttributeInfo(0);
        int[] nArray = skin_thresholds = info == null ? null : info.getSkinThreshold();
        if (skin_thresholds == null || skin_thresholds.length < 6) {
            this.skinDefaultRGB[0] = 128;
            this.skinDefaultRGB[1] = 128;
            this.skinDefaultRGB[2] = 128;
        } else {
            this.skinDefaultRGB[0] = skin_thresholds[6];
            this.skinDefaultRGB[1] = skin_thresholds[7];
            this.skinDefaultRGB[2] = skin_thresholds[8];
        }
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    public static enum WhiteningVersionEnum {
        originWhiten,
        _8version;

    }
}

