/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectGroupFilter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class FaceFilterPipeline
extends FaceDetectGroupFilter {
    private List<BasicFilter> mFilters = new CopyOnWriteArrayList<BasicFilter>();

    protected List<BasicFilter> getFilters() {
        return this.mFilters;
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    protected void insertFilter(BasicFilter dstFilter, BasicFilter filter) {
        int size = this.mFilters.size();
        int dstIndex = -1;
        for (int i = 0; i < size; ++i) {
            if (this.mFilters.get(i) != dstFilter) continue;
            BasicFilter nextFilter = null;
            if (i < size - 1) {
                nextFilter = this.mFilters.get(i + 1);
            }
            if (nextFilter != null) {
                dstFilter.removeTarget(nextFilter);
                dstFilter.addTarget((GLTextureInputRenderer)filter);
                filter.addTarget((GLTextureInputRenderer)nextFilter);
                this.registerFilter(filter);
            } else {
                dstFilter.removeTarget((GLTextureInputRenderer)this);
                this.removeTerminalFilter(dstFilter);
                dstFilter.addTarget((GLTextureInputRenderer)filter);
                filter.addTarget((GLTextureInputRenderer)this);
                this.registerFilter(dstFilter);
                this.registerTerminalFilter(filter);
            }
            dstIndex = i;
            break;
        }
        if (dstIndex > 0) {
            this.mFilters.add(dstIndex + 1, filter);
        }
    }

    protected boolean removeDstFilter(BasicFilter dstFilter) {
        int size = this.mFilters.size();
        int dstIndex = -1;
        for (int i = 0; i < size; ++i) {
            BasicFilter filter = this.mFilters.get(i);
            if (dstFilter != filter) continue;
            BasicFilter preFilter = null;
            BasicFilter nextFilter = null;
            if (i > 0) {
                preFilter = this.mFilters.get(i - 1);
            }
            if (i < size - 1) {
                nextFilter = this.mFilters.get(i + 1);
            }
            if (preFilter != null && nextFilter == null) {
                preFilter.removeTarget((GLTextureInputRenderer)dstFilter);
                this.removeTerminalFilter(dstFilter);
                this.registerTerminalFilter(preFilter);
            }
            dstIndex = i;
            break;
        }
        if (dstIndex < 0) {
            return false;
        }
        this.mFilters.remove(dstFilter);
        return true;
    }

    protected void addTerminalFilter(BasicFilter filter) {
        if (this.mFilters.size() == 0 && this.getTerminalFilters().size() == 0) {
            filter.addTarget((GLTextureInputRenderer)this);
            this.registerInitialFilter(filter);
            this.registerTerminalFilter(filter);
            this.mFilters.add(filter);
            return;
        }
        BasicFilter terminalFilter = (BasicFilter)this.getTerminalFilters().get(0);
        if (this.mFilters.get(this.mFilters.size() - 1) == terminalFilter) {
            terminalFilter.removeTarget((GLTextureInputRenderer)this);
            this.removeTerminalFilter(terminalFilter);
            terminalFilter.addTarget((GLTextureInputRenderer)filter);
            filter.addTarget((GLTextureInputRenderer)this);
            this.registerFilter(terminalFilter);
            this.registerTerminalFilter(filter);
            this.mFilters.add(filter);
        }
    }

    protected boolean resetFilter(BasicFilter oldFilter, BasicFilter newFilter) {
        if (oldFilter == newFilter) {
            return false;
        }
        int relinkIndex = -1;
        int size = this.mFilters.size();
        for (int i = 0; i < size; ++i) {
            BasicFilter filter = this.mFilters.get(i);
            if (filter != oldFilter) continue;
            BasicFilter preFilter = null;
            BasicFilter nextFilter = null;
            if (i > 0) {
                preFilter = this.mFilters.get(i - 1);
            }
            if (i < size - 1) {
                nextFilter = this.mFilters.get(i + 1);
            }
            if (preFilter == null && nextFilter == null) {
                oldFilter.removeTarget((GLTextureInputRenderer)this);
                this.removeInitialFilter(oldFilter);
                this.removeTerminalFilter(oldFilter);
                newFilter.addTarget((GLTextureInputRenderer)this);
                this.registerInitialFilter(newFilter);
                this.registerTerminalFilter(newFilter);
            } else if (preFilter == null) {
                oldFilter.removeTarget(nextFilter);
                this.removeInitialFilter(oldFilter);
                newFilter.addTarget((GLTextureInputRenderer)nextFilter);
                this.registerInitialFilter(newFilter);
            } else if (nextFilter == null) {
                preFilter.removeTarget((GLTextureInputRenderer)oldFilter);
                oldFilter.removeTarget((GLTextureInputRenderer)this);
                this.removeTerminalFilter(oldFilter);
                preFilter.addTarget((GLTextureInputRenderer)newFilter);
                newFilter.addTarget((GLTextureInputRenderer)this);
                this.registerTerminalFilter(newFilter);
            } else {
                preFilter.removeTarget((GLTextureInputRenderer)oldFilter);
                oldFilter.removeTarget((GLTextureInputRenderer)nextFilter);
                this.removeFilter(oldFilter);
                preFilter.addTarget((GLTextureInputRenderer)newFilter);
                newFilter.addTarget((GLTextureInputRenderer)nextFilter);
                this.registerFilter(newFilter);
            }
            relinkIndex = i;
            break;
        }
        if (relinkIndex < 0) {
            return false;
        }
        this.mFilters.remove(oldFilter);
        this.mFilters.add(relinkIndex, newFilter);
        return true;
    }

    protected void constructGroupFilter(List<BasicFilter> inputFilters) {
        int size = inputFilters.size();
        if (size > 0) {
            BasicFilter filterBegin = inputFilters.get(0);
            BasicFilter filterEnd = inputFilters.get(size - 1);
            this.registerInitialFilter(filterBegin);
            BasicFilter curFilter = null;
            for (int i = 0; i < size; ++i) {
                BasicFilter basicFilter = inputFilters.get(i);
                basicFilter.clearTarget();
                if (curFilter != null) {
                    curFilter.addTarget((GLTextureInputRenderer)basicFilter);
                }
                if (i > 0 && i < size - 1) {
                    this.registerFilter(basicFilter);
                }
                curFilter = basicFilter;
            }
            filterEnd.addTarget((GLTextureInputRenderer)this);
            this.registerTerminalFilter(filterEnd);
            this.mFilters.addAll(inputFilters);
        }
    }

    protected void destructGroupFilter() {
        int size = this.mFilters.size();
        if (size > 0) {
            BasicFilter filterBegin = this.mFilters.get(0);
            BasicFilter filterEnd = this.mFilters.get(size - 1);
            for (int i = size - 1; i >= 0; --i) {
                BasicFilter basicFilter = this.mFilters.get(i);
                basicFilter.clearTarget();
                this.removeFilter(basicFilter);
            }
            filterEnd.clearTarget();
            this.removeInitialFilter(filterBegin);
            this.removeTerminalFilter(filterEnd);
            this.mFilters.clear();
        }
    }
}

