/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.filtermanager.EffectFilterCreator;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IEffectOptionsFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.model.FilterOptions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class EffectGroupFilter
extends GroupFilter
implements FaceDetectInterface,
IVideoTrackTime {
    private final int INVALID_MODEL_TYPE = -1;
    private NormalFilter mNormalFilter = new NormalFilter();
    private BasicFilter mTerminalFilter;
    private ConcurrentHashMap<String, AbsEffectOptionFilter> mEffectFilterMap;
    private CopyOnWriteArrayList<GLRenderer> mFiltersToDestroy;
    private EffectRenderFinishListener mRenderFinishListener;

    public EffectGroupFilter() {
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
        this.registerInitialFilter(this.mNormalFilter);
        this.registerTerminalFilter(this.mNormalFilter);
        this.mTerminalFilter = this.mNormalFilter;
        this.mFiltersToDestroy = new CopyOnWriteArrayList();
        this.mEffectFilterMap = new ConcurrentHashMap();
    }

    public void addEffectFilterItem(EffectFilterItem effectItem) {
        AbsEffectOptionFilter filter = this.mEffectFilterMap.get(effectItem.getName());
        if (filter != null) {
            if (effectItem.getImageFolderPath() != null && effectItem.getImageFolderPath().equals(filter.getFilterOptions().getImageFolderPath())) {
                filter.setDuration(filter.getDuration() - filter.getEscapedTime() + effectItem.getDuration());
            } else {
                FilterOptions options = EffectFilterCreator.getFilterOptions(effectItem);
                if (options != null) {
                    filter.resetFilterOptions(options);
                    filter.setDuration(effectItem.getDuration() > 0L ? effectItem.getDuration() : 99999999999L);
                }
            }
            return;
        }
        filter = EffectFilterCreator.getProcessFilter(effectItem);
        if (filter == null) {
            return;
        }
        filter.setDuration(effectItem.getDuration() > 0L ? effectItem.getDuration() : 99999999999L);
        filter.getFilterOptions().setModelType(effectItem.getModelType());
        this.addTerminalFilter(filter);
        this.mEffectFilterMap.put(filter.getFilterOptions().getName(), filter);
        final AbsEffectOptionFilter finalFilter = filter;
        filter.setRenderFinishListener(new IEffectOptionsFilter.RenderFinishListener(){

            public void onRenderFinish() {
                EffectGroupFilter.this.removeEffectFilter(finalFilter);
            }
        });
    }

    private void removeEffectFilter(AbsEffectOptionFilter filter) {
        BasicFilter parentFilter = filter.parentFilter;
        parentFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter((BasicFilter)filter);
            this.registerTerminalFilter(parentFilter);
            parentFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = parentFilter;
        } else {
            this.removeFilter((BasicFilter)filter);
            BasicFilter basicFilter = (BasicFilter)filter.getTargets().get(0);
            filter.removeTarget((GLTextureInputRenderer)basicFilter);
            basicFilter.parentFilter = parentFilter;
            parentFilter.addTarget((GLTextureInputRenderer)basicFilter);
        }
        this.mFiltersToDestroy.add((GLRenderer)filter);
        this.mEffectFilterMap.remove(filter.getFilterOptions().getName());
        if (this.mEffectFilterMap.size() == 0 && this.mRenderFinishListener != null) {
            this.mRenderFinishListener.onRenderFinish();
        }
    }

    private void addTerminalFilter(AbsEffectOptionFilter filter) {
        this.mTerminalFilter.removeTarget((GLTextureInputRenderer)this);
        this.mTerminalFilter.addTarget((GLTextureInputRenderer)filter);
        filter.parentFilter = this.mTerminalFilter;
        this.removeTerminalFilter(this.mTerminalFilter);
        this.registerFilter(this.mTerminalFilter);
        this.mTerminalFilter = filter;
        filter.addTarget((GLTextureInputRenderer)this);
        this.registerTerminalFilter(this.mTerminalFilter);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.mFiltersToDestroy.size() > 0) {
            for (GLRenderer renderer : this.mFiltersToDestroy) {
                renderer.destroy();
            }
            this.mFiltersToDestroy.clear();
        }
        super.newTextureReady(texture, source, newData);
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.mEffectFilterMap.size() == 0) {
            return;
        }
        for (AbsEffectOptionFilter filter : this.mEffectFilterMap.values()) {
            if (!(filter instanceof FaceDetectInterface)) continue;
            ((FaceDetectInterface)filter).setMMCVInfo(mmcvInfo);
        }
    }

    public void clearWithModelType(int modelType) {
        if (this.mEffectFilterMap.size() == 0) {
            return;
        }
        for (AbsEffectOptionFilter filter : this.mEffectFilterMap.values()) {
            if (modelType != -1 && filter.getFilterOptions().getModelType() != modelType) continue;
            this.removeEffectFilter(filter);
        }
    }

    public void clearAll() {
        this.clearWithModelType(-1);
    }

    public synchronized void destroy() {
        super.destroy();
        this.mEffectFilterMap.clear();
        if (this.mFiltersToDestroy.size() > 0) {
            for (GLRenderer renderer : this.mFiltersToDestroy) {
                renderer.destroy();
            }
            this.mFiltersToDestroy.clear();
        }
    }

    public void setRenderFinishListener(EffectRenderFinishListener listener) {
        this.mRenderFinishListener = listener;
    }

    public void setTimeStamp(long ms) {
        if (this.mEffectFilterMap != null && this.mEffectFilterMap.size() > 0) {
            for (AbsEffectOptionFilter absEffectOptionFilter : this.mEffectFilterMap.values()) {
                absEffectOptionFilter.setTimeStamp(ms);
            }
        }
    }

    public static interface EffectRenderFinishListener {
        public void onRenderFinish();
    }
}

