/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.GLProgram;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class BigEyeFilter
extends BasicFilter
implements FaceDetectInterface {
    public static final String UNIFORM_TEXTURE_SIZE = "textureSize";
    public static final String UNIFORM_CENTER_LEFT = "centerLeft";
    public static final String UNIFORM_CENTER_RIGHT = "centerRight";
    public static final String UNIFORM_RADIUS_LEFT = "radiusLeft";
    public static final String UNIFORM_RADIUS_RIGHT = "radiusRight";
    public static final String UNIFORM_SCALE = "scale";
    public int handleTextureSize = 0;
    public int handleCenterLeft = 0;
    public int handleCenterRight = 0;
    public int handleRadiusLeft = 0;
    public int handleRadiuRight = 0;
    public int handleScale = 0;
    public float[] textureSize = new float[2];
    public float[] centerLeft = new float[2];
    public float[] centerRight = new float[2];
    public float radiusLeft = 0.0f;
    public float radiusRight = 0.0f;
    private float scale = 0.0f;
    private float mEyeScale = 0.0f;
    private EyesProgram eyesProgram = new EyesProgram(1, 1);
    private MMCVInfo mMmcvInfo = null;

    public BigEyeFilter() {
        if (this.eyesProgram != null) {
            this.eyesProgram.setDrawType(4);
        }
    }

    public void drawSub() {
        super.drawSub();
        this.drawEyes();
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.eyesProgram != null) {
            this.eyesProgram.setRenderSize(source.getWidth(), source.getHeight());
        }
        super.newTextureReady(texture, source, newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = mmcvInfo;
        }
    }

    private void drawEyes() {
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                if (this.mMmcvInfo.getFaceAttributeInfo(i) == null || this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                PointF leftLandmarkA = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[39], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[143]);
                PointF rightLandmarkA = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[45], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[149]);
                this.centerLeft[0] = (leftLandmarkA.x + rightLandmarkA.x) / 2.0f;
                this.centerLeft[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (leftLandmarkA.y + rightLandmarkA.y) / 2.0f;
                PointF leftLandmarkB = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[51], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[155]);
                PointF rightLandmarkB = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[57], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[161]);
                this.centerRight[0] = (leftLandmarkB.x + rightLandmarkB.x) / 2.0f;
                this.centerRight[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (leftLandmarkB.y + rightLandmarkB.y) / 2.0f;
                double eyeWidthLeft = Math.sqrt((leftLandmarkA.x - rightLandmarkA.x) * (leftLandmarkA.x - rightLandmarkA.x) + (leftLandmarkA.y - rightLandmarkA.y) * (leftLandmarkA.y - rightLandmarkA.y));
                double eyeWidthRight = Math.sqrt((leftLandmarkB.x - rightLandmarkB.x) * (leftLandmarkB.x - rightLandmarkB.x) + (leftLandmarkB.y - rightLandmarkB.y) * (leftLandmarkB.y - rightLandmarkB.y));
                double radius = (eyeWidthRight + eyeWidthLeft) / 2.0;
                float yawFactor = 1.0f - Math.min(Math.abs(this.mMmcvInfo.getFaceAttributeInfo(i).getEulerAngles()[1]) / 60.0f, 1.0f);
                this.scale = (float)((double)this.mEyeScale * 0.2 * Math.exp((double)yawFactor - 1.0));
                this.radiusLeft = (float)(radius * 0.8);
                this.radiusRight = (float)(radius * 0.8);
                int[] texture = new int[]{this.texture_in};
                float[][] array = AIFaceTriangulation.getFaceTriangulation(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight(), null);
                this.eyesProgram.drawFrame(array, texture);
            }
        }
    }

    public void setEyeScale(float scale) {
        this.mEyeScale = scale;
    }

    class EyesProgram
    extends GLProgram {
        public EyesProgram(int numTexture, int numCoord) {
            super(numTexture, numCoord);
        }

        @Override
        protected String getSubFrameShader() {
            String shader = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate0;\nuniform vec2 textureSize;\nuniform vec2 centerLeft;\nuniform vec2 centerRight;\nuniform float radiusLeft;\nuniform float radiusRight; \nuniform float scale;\nvoid main() {\n    vec2 textureCoordinate = textureCoordinate0  * textureSize;\n    float distanceLeft = distance(centerLeft, textureCoordinate);\n    if (distanceLeft < radiusLeft) {\n        vec2 offset = textureCoordinate - centerLeft;\n        float percent = 1.0 - ((radiusLeft - distanceLeft) / radiusLeft) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerLeft + offset)/textureSize);\n        return;\n    }\n    float distanceRight = distance(centerRight, textureCoordinate);\n    if (distanceRight < radiusRight) {\n        vec2 offset = textureCoordinate - centerRight;\n        float percent = 1.0 - ((radiusRight - distanceRight) / radiusRight) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerRight + offset)/textureSize);\n        return;\n    }\n    gl_FragColor = texture2D(inputImageTexture0, textureCoordinate0);\n}";
            return shader;
        }

        @Override
        protected void initShaderHandles() {
            super.initShaderHandles();
            BigEyeFilter.this.handleTextureSize = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_TEXTURE_SIZE);
            BigEyeFilter.this.handleCenterLeft = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_CENTER_LEFT);
            BigEyeFilter.this.handleCenterRight = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_CENTER_RIGHT);
            BigEyeFilter.this.handleRadiusLeft = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_RADIUS_LEFT);
            BigEyeFilter.this.handleRadiuRight = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_RADIUS_RIGHT);
            BigEyeFilter.this.handleScale = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_SCALE);
        }

        @Override
        protected void passShaderValues(float[][] triArray, int[] textures) {
            super.passShaderValues(triArray, textures);
            BigEyeFilter.this.textureSize[0] = this.width;
            BigEyeFilter.this.textureSize[1] = this.height;
            GLES20.glUniform2f((int)BigEyeFilter.this.handleTextureSize, (float)BigEyeFilter.this.textureSize[0], (float)BigEyeFilter.this.textureSize[1]);
            GLES20.glUniform2f((int)BigEyeFilter.this.handleCenterLeft, (float)BigEyeFilter.this.centerLeft[0], (float)BigEyeFilter.this.centerLeft[1]);
            GLES20.glUniform2f((int)BigEyeFilter.this.handleCenterRight, (float)BigEyeFilter.this.centerRight[0], (float)BigEyeFilter.this.centerRight[1]);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleRadiusLeft, (float)BigEyeFilter.this.radiusLeft);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleRadiuRight, (float)BigEyeFilter.this.radiusRight);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleScale, (float)BigEyeFilter.this.scale);
        }
    }
}

