/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager.filterext;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.LookupFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class DetectSingleLineGroupFilter
extends GroupFilter
implements FaceDetectInterface,
IVideoTrackTime {
    private List<BasicFilter> mFilters;
    private List<LookupFilter> mLookUpFilters = new ArrayList<LookupFilter>();

    public DetectSingleLineGroupFilter(List<BasicFilter> filters) {
        this.mFilters = filters;
        if (filters.size() > 0) {
            BasicFilter filterBegin = filters.get(0);
            BasicFilter filterEnd = filters.get(filters.size() - 1);
            this.registerInitialFilter(filterBegin);
            BasicFilter curFilter = null;
            for (int i = 0; i <= filters.size() - 1; ++i) {
                BasicFilter basicFilter = filters.get(i);
                basicFilter.clearTarget();
                if (curFilter == null) {
                    curFilter = basicFilter;
                } else {
                    curFilter.addTarget((GLTextureInputRenderer)filters.get(i));
                }
                if (i > 0 && i < filters.size() - 1) {
                    this.registerFilter(basicFilter);
                }
                curFilter = filters.get(i);
                if (!(basicFilter instanceof LookupFilter)) continue;
                this.mLookUpFilters.add((LookupFilter)basicFilter);
            }
            filterEnd.addTarget((GLTextureInputRenderer)this);
            this.registerTerminalFilter(filterEnd);
        }
    }

    public List<BasicFilter> getFilters() {
        return this.mFilters;
    }

    public void setTimeStamp(long ms) {
        for (BasicFilter filter : this.mFilters) {
            if (!(filter instanceof IVideoTrackTime)) continue;
            ((IVideoTrackTime)filter).setTimeStamp(ms);
        }
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        for (BasicFilter filter : this.mFilters) {
            if (!(filter instanceof FaceDetectInterface)) continue;
            ((FaceDetectInterface)filter).setMMCVInfo(mmcvInfo);
        }
    }

    public synchronized void setIntensity(float intensity) {
        if (this.mLookUpFilters != null && this.mLookUpFilters.size() > 0) {
            for (int i = 0; i < this.mLookUpFilters.size(); ++i) {
                this.mLookUpFilters.get(i).setIntensity(intensity);
            }
        }
    }
}

