/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.momo.mcamera.filtermanager.ClassUtil;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.filtermanager.MMProcessUnit;
import com.momo.mcamera.filtermanager.filterext.BitmapBlendFilter;
import com.momo.mcamera.mask.MaskStore;
import com.momo.mcamera.mask.StickerAdjustFilter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.filter.colour.LookupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;

public class MMFilter
implements Serializable {
    public static final long serialVersionUID = 8953832831202944607L;
    public String mImageUri;
    public String mFilterName;
    private List<MMProcessUnit> mProcessUnits;
    private transient Context context;

    public MMFilter(Context context) {
        this.mProcessUnits = new ArrayList<MMProcessUnit>();
        this.context = context;
    }

    public MMFilter() {
    }

    public static List<BasicFilter> getFilterGroupByUnits(Collection<MMProcessUnit> processUnits, Context context) {
        ArrayList<BasicFilter> filters = new ArrayList<BasicFilter>();
        for (MMProcessUnit unit : processUnits) {
            if (unit.isDecoration()) {
                StickerAdjustFilter stickerAdjustFilter = new StickerAdjustFilter(context);
                stickerAdjustFilter.enableSelfRender = true;
                stickerAdjustFilter.addMaskModel(MaskStore.getInstance().getMask(context, unit.getResourceName()));
                filters.add((BasicFilter)stickerAdjustFilter);
                continue;
            }
            try {
                Class<?> clazz = Class.forName(unit.getFilterName());
                BasicFilter filter = (BasicFilter)clazz.newInstance();
                HashMap<String, Object> map = unit.getFilterMap();
                if (map != null) {
                    for (String key : map.keySet()) {
                        Method m1 = clazz.getDeclaredMethod(key, ClassUtil.getUsefulClass(map.get(key)));
                        m1.invoke((Object)filter, map.get(key));
                    }
                }
                if (unit.getTexturePath1() != null) {
                    if (filter instanceof LookupFilter) {
                        if (unit.getTexturePath1().startsWith("light_room_filters")) {
                            ((LookupFilter)filter).setAssetResourcesId(context, unit.getTexturePath1());
                        } else {
                            ((LookupFilter)filter).setLookUpPath(unit.getTexturePath1());
                        }
                    } else if (filter instanceof BitmapBlendFilter) {
                        Bitmap texture1 = MMFilter.getBitmapByPath(unit.getTexturePath1(), context);
                        ((BitmapBlendFilter)filter).setBlendBitmap(texture1);
                    }
                }
                filters.add(filter);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (filters.size() == 0) {
            NormalFilter normalFilter = new NormalFilter();
            filters.add((BasicFilter)normalFilter);
        }
        return filters;
    }

    public static BasicFilter getFilterByUnit(MMProcessUnit unit, Context context) {
        Class<?> clazz = null;
        BasicFilter filter = null;
        try {
            clazz = Class.forName(unit.getFilterName());
            filter = (BasicFilter)clazz.newInstance();
            HashMap<String, Object> map = unit.getFilterMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    Method m1 = clazz.getDeclaredMethod(key, ClassUtil.getUsefulClass(map.get(key)));
                    m1.invoke((Object)filter, map.get(key));
                }
            }
            if (unit.getTexturePath1() != null && filter instanceof LookupFilter) {
                Bitmap texture1 = MMFilter.getBitmapByPath(unit.getTexturePath1(), context);
                ((LookupFilter)filter).setLookupBitmap(texture1);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return filter;
    }

    public SingleLineGroupFilter getFilterGroup() {
        return new SingleLineGroupFilter(MMFilter.getFilterGroupByUnits(this.getProcessUnits(), this.context));
    }

    public static Bitmap getBitmapByPath(String path, Context context) {
        if (path.startsWith("light_room_filters")) {
            return MMPresetFilterStore.getBitmapWithPath(path, context);
        }
        return BitmapFactory.decodeFile((String)path);
    }

    public void setProcessUnits(List<MMProcessUnit> mProcessUnits) {
        this.mProcessUnits = mProcessUnits;
    }

    public List<MMProcessUnit> getProcessUnits() {
        return this.mProcessUnits;
    }

    public String getKey() {
        return ".....";
    }

    public String getFilterName() {
        if (!TextUtils.isEmpty((CharSequence)this.mFilterName)) {
            this.mFilterName.replace(".", "_");
            String[] filters = this.mFilterName.split("_");
            if (filters.length > 1) {
                return filters[1];
            }
        }
        return this.mFilterName;
    }
}

