/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager;

import android.text.TextUtils;
import com.momo.mcamera.filtermanager.EffectFilterKey;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import java.io.File;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.model.FilterOptions;

public class EffectFilterCreator {
    public static AbsEffectOptionFilter getProcessFilter(EffectFilterItem model) {
        String name = model.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        FilterOptions options = EffectFilterCreator.getFilterOptions(model);
        AbsEffectOptionFilter filter = null;
        try {
            String filtername = EffectFilterKey.getInstance().effectFilterMap.get(name);
            Class<?> clazz = Class.forName(filtername);
            filter = (AbsEffectOptionFilter)clazz.newInstance();
            if (filter != null) {
                filter.setFilterOptions(options);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    public static FilterOptions getFilterOptions(EffectFilterItem filterItem) {
        FilterOptions options = filterItem.getOptions();
        if (options == null) {
            options = new FilterOptions();
            filterItem.setOptions(options);
        }
        options.setName(filterItem.getName());
        options.setImageFolderPath(filterItem.getImageFolderPath());
        options.setFolder(filterItem.getImageFolderPath() + File.separator + filterItem.getFolder());
        return options;
    }
}

