/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.dokibeauty;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import com.immomo.doki.filter.basic.MultipleFaceParameterInterface;
import com.immomo.doki.media.FilterConfigHelper;
import com.momo.mcamera.mask.FaceDetectGroupFilter;
import com.momo.mcamera.mask.StickerAdjustFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.MStickerActions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class DokiSingleLineGroupFilter
extends FaceDetectGroupFilter
implements IVideoTrackTime {
    private CopyOnWriteArrayList<BasicFilter> filters = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<BasicFilter> destroyList = new CopyOnWriteArrayList();

    public DokiSingleLineGroupFilter(List<BasicFilter> filters) {
        this.constructGroupFilter(filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            FilterConfigHelper.getInstance().setMMCVInfo(mmcvInfo);
            Collection faceParameters = FilterConfigHelper.getInstance().getFaceParameters();
            for (int i = 0; i < this.filters.size(); ++i) {
                BasicFilter filter = this.filters.get(i);
                if (filter instanceof FaceDetectInterface) {
                    ((FaceDetectInterface)filter).setMMCVInfo(mmcvInfo);
                }
                if (!(filter instanceof MultipleFaceParameterInterface)) continue;
                ((MultipleFaceParameterInterface)filter).setFaceParameters(faceParameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.newTextureReady(texture, source, newData);
            if (this.destroyList.size() > 0) {
                this.doDestroyFilters();
            }
        }
    }

    private void doDestroyFilters() {
        for (BasicFilter filter : this.destroyList) {
            filter.destroy();
        }
        this.destroyList.clear();
    }

    public synchronized void destroy() {
        super.destroy();
        if (this.destroyList.size() > 0) {
            this.doDestroyFilters();
        }
        this.filters.clear();
        MDLog.e((String)"MMEdiaSDK", (String)"sigline group filter sdstrroy !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11");
    }

    private void constructGroupFilter(List<BasicFilter> inputFilters) {
        int size = inputFilters.size();
        if (size > 0) {
            BasicFilter filterBegin = inputFilters.get(0);
            BasicFilter filterEnd = inputFilters.get(size - 1);
            this.registerInitialFilter(filterBegin);
            BasicFilter curFilter = null;
            for (int i = 0; i < size; ++i) {
                BasicFilter basicFilter = inputFilters.get(i);
                basicFilter.clearTarget();
                if (curFilter == null) {
                    curFilter = basicFilter;
                } else {
                    curFilter.addTarget((GLTextureInputRenderer)inputFilters.get(i));
                }
                if (i > 0 && i < size - 1) {
                    this.registerFilter(basicFilter);
                }
                curFilter = basicFilter;
            }
            filterEnd.addTarget((GLTextureInputRenderer)this);
            this.registerTerminalFilter(filterEnd);
            this.filters.addAll(inputFilters);
        }
    }

    private void destructGroupFilter() {
        int size = this.filters.size();
        if (size > 0) {
            BasicFilter filterBegin = this.filters.get(0);
            BasicFilter filterEnd = this.filters.get(size - 1);
            for (int i = size - 1; i >= 0; --i) {
                BasicFilter basicFilter = this.filters.get(i);
                basicFilter.clearTarget();
                this.removeFilter(basicFilter);
            }
            filterEnd.clearTarget();
            this.removeInitialFilter(filterBegin);
            this.removeTerminalFilter(filterEnd);
            this.destroyList.addAll(this.filters);
            this.filters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFilterFromLine(BasicFilter removeFilter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (removeFilter == null) {
                return;
            }
            for (int i = 0; i < this.filters.size(); ++i) {
                BasicFilter filter = this.filters.get(i);
                BasicFilter preFilter = null;
                BasicFilter afterFilter = null;
                if (filter != removeFilter) continue;
                if (i > 0) {
                    preFilter = this.filters.get(i - 1);
                }
                if (i + 1 < this.filters.size()) {
                    afterFilter = this.filters.get(i + 1);
                }
                if (preFilter == null && afterFilter != null) {
                    filter.clearTarget();
                    this.removeInitialFilter(filter);
                    this.registerInitialFilter(afterFilter);
                } else if (afterFilter == null && preFilter != null) {
                    preFilter.clearTarget();
                    filter.clearTarget();
                    this.removeTerminalFilter(filter);
                    this.registerTerminalFilter(preFilter);
                    preFilter.addTarget((GLTextureInputRenderer)this);
                } else if (preFilter != null && afterFilter != null) {
                    preFilter.removeTarget((GLTextureInputRenderer)filter);
                    filter.removeTarget((GLTextureInputRenderer)afterFilter);
                    this.removeFilter(filter);
                    preFilter.addTarget((GLTextureInputRenderer)afterFilter);
                }
                this.filters.remove(filter);
                if (this.destroyList == null) continue;
                this.destroyList.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<BasicFilter> resetFilters(List<BasicFilter> filters) {
        Object object = this.getLockObject();
        synchronized (object) {
            ArrayList<BasicFilter> arrayList = new ArrayList<BasicFilter>(filters);
            this.destructGroupFilter();
            this.constructGroupFilter(filters);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean resetFilter(BasicFilter oldFilter, BasicFilter newFilter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (newFilter == null || oldFilter == null || oldFilter == newFilter) {
                return false;
            }
            boolean inFiltersList = false;
            for (int i = 0; i < this.filters.size(); ++i) {
                BasicFilter filter = this.filters.get(i);
                BasicFilter preFilter = null;
                BasicFilter afterFilter = null;
                if (filter != oldFilter) continue;
                inFiltersList = true;
                if (i > 0) {
                    preFilter = this.filters.get(i - 1);
                }
                if (i + 1 < this.filters.size()) {
                    afterFilter = this.filters.get(i + 1);
                }
                if (preFilter != null && afterFilter != null) continue;
                if (preFilter == null && afterFilter != null) {
                    oldFilter.clearTarget();
                    this.removeInitialFilter(oldFilter);
                    this.registerTerminalFilter(newFilter);
                    newFilter.addTarget((GLTextureInputRenderer)afterFilter);
                    continue;
                }
                if (afterFilter == null && preFilter != null) {
                    preFilter.clearTarget();
                    oldFilter.clearTarget();
                    this.removeTerminalFilter(oldFilter);
                    this.registerTerminalFilter(newFilter);
                    preFilter.addTarget((GLTextureInputRenderer)newFilter);
                    newFilter.addTarget((GLTextureInputRenderer)this);
                    continue;
                }
                if (preFilter == null || afterFilter == null) continue;
                preFilter.removeTarget((GLTextureInputRenderer)oldFilter);
                oldFilter.removeTarget((GLTextureInputRenderer)afterFilter);
                this.removeFilter(oldFilter);
                this.registerFilter(newFilter);
                preFilter.addTarget((GLTextureInputRenderer)newFilter);
                newFilter.addTarget((GLTextureInputRenderer)afterFilter);
            }
            if (!inFiltersList) {
                return false;
            }
            this.filters.remove(oldFilter);
            this.filters.add(newFilter);
            if (this.destroyList != null) {
                this.destroyList.add(oldFilter);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEndFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (filter == null) {
                return;
            }
            if (this.filters.size() > 0 && filter != null) {
                List terminalFilters = this.getTerminalFilters();
                if (terminalFilters.size() == 1) {
                    BasicFilter oldEndFilter = (BasicFilter)terminalFilters.get(0);
                    oldEndFilter.clearTarget();
                    filter.clearTarget();
                    this.removeTerminalFilter(oldEndFilter);
                    this.registerFilter(oldEndFilter);
                    oldEndFilter.addTarget((GLTextureInputRenderer)filter);
                    this.registerTerminalFilter(filter);
                    filter.addTarget((GLTextureInputRenderer)this);
                    this.filters.add(filter);
                }
            } else {
                this.registerInitialFilter(filter);
                filter.addTarget((GLTextureInputRenderer)this);
                this.registerTerminalFilter(filter);
                this.filters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.filters.size() > 0 && filter != null) {
                List initFilters = this.getInitialFilters();
                if (initFilters.size() == 1) {
                    BasicFilter oldHeadFilter = (BasicFilter)initFilters.get(0);
                    this.removeInitialFilter(oldHeadFilter);
                    this.registerInitialFilter(filter);
                    filter.clearTarget();
                    filter.addTarget((GLTextureInputRenderer)oldHeadFilter);
                    this.registerFilter(oldHeadFilter);
                    this.filters.add(0, filter);
                }
            } else {
                this.registerInitialFilter(filter);
                filter.addTarget((GLTextureInputRenderer)this);
                this.registerTerminalFilter(filter);
                this.filters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimeStamp(long ms) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (BasicFilter filter : this.filters) {
                if (!(filter instanceof IVideoTrackTime)) continue;
                ((IVideoTrackTime)filter).setTimeStamp(ms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPlayStatusChangeListener(MStickerActions.onPlayStatusListener listener) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (BasicFilter filter : this.filters) {
                if (!(filter instanceof StickerAdjustFilter)) continue;
                ((StickerAdjustFilter)filter).setplayStatusListener(listener);
            }
        }
    }

    public synchronized void addFilterToDestroy(BasicFilter removeFilter) {
        if (this.filters.contains(removeFilter)) {
            this.filters.remove(removeFilter);
        }
        if (this.destroyList != null) {
            this.destroyList.add(removeFilter);
        }
    }
}

