/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.AnimojiUtils;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.core.glcore.camera.ICamera;
import com.core.glcore.camera.MCamera;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.datadot.DataDotUtils;
import com.cosmos.mdlog.MDLog;
import com.immomo.moment.render.BasicRender;
import com.momo.mcamera.AnimojiUtils.OnFaceDetectListener;
import com.momo.xeengine.bean.XEFaceInfo;
import com.momo.xeengine.xnative.XEFace;
import com.momocv.MMFrame;
import com.momocv.SingleFaceInfo;
import com.momocv.facerigv3.FaceRigV3;
import com.momocv.facerigv3.FacerigV3Info;
import com.momocv.facerigv3.FacerigV3Params;
import com.momocv.videoprocessor.VideoInfo;
import com.momocv.videoprocessor.VideoParams;
import com.momocv.videoprocessor.VideoProcessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AnimojiUtil
implements ICamera.ICameraDataCallback {
    private MRCoreParameters mrCoreParameters;
    private ICamera mCamera;
    private BasicRender mBasicRender;
    private SurfaceTexture mCameraTexture;
    private FacerigV3Info mFaceRigInfo;
    private FaceRigV3 mFaceRig;
    private FacerigV3Params mFacerigV3Params;
    private MMFrame mMFrame;
    private VideoProcessor mVideoProcessor;
    private VideoParams mVideoParams;
    private VideoInfo mVideoInfo;
    private OnFaceDetectListener mOnFaceDetectListener;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    final Object syncObj = new Object();
    boolean isPreviewing = false;
    LinkedList<byte[]> dataList;
    LinkedList<byte[]> emptyList;
    Object syncLock = new Object();
    long lastCameraTime = 0L;
    long lastSendTime = 0L;
    long processIntevla = 0L;
    int mFrameIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initAnimoji(int degrees, MRConfig mrConfig) {
        Object object = this.syncObj;
        synchronized (object) {
            this.mrCoreParameters = new MRCoreParameters();
            if (this.mrCoreParameters == null) {
                MDLog.e((String)"AnimojiUtil", (String)"Camera prepare Failed, Parameter is NULL!");
                return false;
            }
            this.initCoreParams(mrConfig);
            this.initInternalParamter(this.mrCoreParameters);
            if (!this.mCamera.prepare(degrees, mrConfig)) {
                MDLog.e((String)"AnimojiUtil", (String)"Camera prepare Failed!");
                return false;
            }
            this.mCamera.setCameraDataCallback((ICamera.ICameraDataCallback)this);
            DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraDetectAnimoji(true);
        }
        return true;
    }

    private void initCoreParams(MRConfig mrConfig) {
        this.mrCoreParameters.visualWidth = mrConfig.getVisualSize().getWidth();
        this.mrCoreParameters.visualHeight = mrConfig.getVisualSize().getHeight();
        this.mrCoreParameters.videoBitrate = mrConfig.getVideoBitRate();
        this.mrCoreParameters.videoFPS = mrConfig.getVideoFPS();
        this.mrCoreParameters.videoRotation = mrConfig.getVideoRotation();
        this.mrCoreParameters.previewBufferCount = 1;
    }

    public void initInternalParamter(MRCoreParameters coreParameters) {
        this.mCamera = new MCamera(coreParameters);
        this.mBasicRender = new BasicRender(coreParameters);
    }

    public void setOnFaceDetectListener(OnFaceDetectListener listener) {
        this.mOnFaceDetectListener = listener;
    }

    public boolean loadFaceRigMode(String FaceRigMode) {
        this.mFaceRig = new FaceRigV3();
        if (!this.mFaceRig.LoadModel(FaceRigMode)) {
            MDLog.e((String)"AnimojiUtil", (String)"initData: faceRig loadModel failed");
            return false;
        }
        return true;
    }

    public boolean loadFaceDetectMode(String fdModel, String faModel) {
        this.mVideoProcessor = new VideoProcessor();
        if (!this.mVideoProcessor.LoadModel(fdModel, faModel)) {
            MDLog.e((String)"AnimojiUtil", (String)"initData: videoProcessor load model failed");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onData(byte[] data) {
        if (this.mFaceRig == null || this.mVideoProcessor == null) {
            return;
        }
        this.lastCameraTime = System.currentTimeMillis();
        if (this.mHandler == null) {
            this.mHandlerThread = new HandlerThread("AniUtilProc");
            this.mHandlerThread.start();
            this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    byte[] data = null;
                    Object object = AnimojiUtil.this.syncLock;
                    synchronized (object) {
                        data = AnimojiUtil.this.dataList.pollFirst();
                    }
                    AnimojiUtil.this.process(data);
                    object = AnimojiUtil.this.syncLock;
                    synchronized (object) {
                        AnimojiUtil.this.emptyList.addLast(data);
                    }
                }
            };
        }
        if (this.dataList == null || this.emptyList == null) {
            this.dataList = new LinkedList();
            this.emptyList = new LinkedList();
            for (int i = 0; i < 3; ++i) {
                byte[] bytes = new byte[data.length];
                this.emptyList.addLast(bytes);
            }
        }
        long start3 = System.currentTimeMillis();
        Object object = this.syncLock;
        synchronized (object) {
            if (this.emptyList.size() > 0) {
                long start = System.currentTimeMillis();
                byte[] tmp = this.emptyList.pollFirst();
                System.arraycopy(data, 0, tmp, 0, data.length);
                this.dataList.addLast(tmp);
                Message msg = Message.obtain();
                msg.what = 0;
                this.mHandler.sendMessage(msg);
                this.lastSendTime = System.currentTimeMillis();
            }
        }
    }

    private void process(byte[] data) {
        ++this.mFrameIndex;
        if (this.mrCoreParameters.previewVideoWidth == 0 || this.mrCoreParameters.previewVideoHeight == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        this.mFaceRigInfo = new FacerigV3Info();
        this.setParams();
        this.mMFrame.data_ptr_ = data;
        this.mMFrame.data_len_ = data.length;
        if (!this.mVideoProcessor.ProcessFrame(this.mMFrame, this.mVideoParams, this.mVideoInfo)) {
            return;
        }
        List<XEFaceInfo> info = null;
        if (this.mVideoInfo.facesinfo_ != null && this.mVideoInfo.facesinfo_.length > 0) {
            float[] euler_angles_;
            SingleFaceInfo singleFaceInfo = this.mVideoInfo.facesinfo_[0];
            this.mFacerigV3Params.orig_landmarks_96_ = singleFaceInfo.orig_landmarks_96_;
            MMFrame frame = new MMFrame();
            frame.width_ = this.mrCoreParameters.previewVideoWidth;
            frame.height_ = this.mrCoreParameters.previewVideoHeight;
            frame.step_ = frame.width_;
            frame.data_len_ = this.mrCoreParameters.previewVideoWidth * this.mrCoreParameters.previewVideoHeight * 3 / 2;
            frame.format_ = 17;
            frame.data_ptr_ = data;
            if (this.mFacerigV3Params.orig_landmarks_96_ != null && (euler_angles_ = singleFaceInfo.euler_angles_) != null && euler_angles_.length > 2) {
                this.mFacerigV3Params.face_processor_eulers_ = euler_angles_;
                this.mFacerigV3Params.fliped_show_ = this.mVideoParams.fliped_show_;
            }
            this.mFaceRig.ProcessFrame(frame, this.mFacerigV3Params, this.mFaceRigInfo);
            info = this.makeInfo(this.mVideoInfo, this.mFaceRigInfo);
        }
        if (this.mOnFaceDetectListener != null) {
            if (info == null || info.size() <= 0) {
                this.mOnFaceDetectListener.hasFaceDetectInfo(false);
            } else {
                this.mOnFaceDetectListener.hasFaceDetectInfo(true);
            }
        }
        XEFace.setFaceInfo(info);
        this.processIntevla = System.currentTimeMillis();
    }

    private List<XEFaceInfo> makeInfo(VideoInfo videoInfo, FacerigV3Info faceRigInfo) {
        SingleFaceInfo[] facesinfo = videoInfo.facesinfo_;
        if (facesinfo == null || facesinfo.length == 0) {
            return null;
        }
        SingleFaceInfo face = facesinfo[0];
        ArrayList<XEFaceInfo> xeFaceInfos = new ArrayList<XEFaceInfo>();
        XEFaceInfo rep = new XEFaceInfo();
        xeFaceInfos.add(rep);
        rep.landmarks68 = face.landmarks_68_;
        rep.landmarks96 = face.landmarks_96_;
        rep.faceBounds = face.face_rect_;
        float[] euler_angles_ = face.euler_angles_;
        rep.pitch = euler_angles_[0];
        rep.yaw = euler_angles_[1];
        rep.roll = euler_angles_[2];
        rep.trackId = face.tracking_id_;
        rep.cameraMatrix = face.camera_matrix_;
        rep.rotationMatrix = face.rotation_matrix_;
        rep.rotationVector = face.rotation_vector_;
        rep.translationVector = face.translation_vector_;
        rep.projectionMatrix = face.projection_matrix_;
        rep.modelViewMatrix = face.modelview_matrix_;
        if (faceRigInfo != null && faceRigInfo.facerigV3_eulers_ != null) {
            rep.facerigStates = faceRigInfo.facerigV3_scores_;
            float[] floats = new float[54];
            System.arraycopy(faceRigInfo.facerigV3_eulers_, 0, floats, 0, 3);
            System.arraycopy(faceRigInfo.facerigV3_scores_, 0, floats, 3, 51);
            rep.facerigStates = floats;
        }
        rep.meType = 1;
        return xeFaceInfos;
    }

    private void setParams() {
        this.mMFrame = new MMFrame();
        this.mMFrame.width_ = this.mrCoreParameters.previewVideoWidth;
        this.mMFrame.height_ = this.mrCoreParameters.previewVideoHeight;
        this.mMFrame.format_ = 17;
        this.mMFrame.step_ = this.mrCoreParameters.previewVideoWidth;
        this.mVideoParams = new VideoParams();
        this.mVideoParams.max_faces_ = 1;
        this.mVideoParams.rotate_degree_ = this.mrCoreParameters.videoRotation == 0 ? this.mCamera.getCameraRotation() : 270 - this.mrCoreParameters.videoRotation;
        this.mVideoParams.restore_degree_ = this.mCamera.getCameraRotation();
        this.mVideoParams.fliped_show_ = this.mCamera.isFront();
        this.mVideoParams.detect_single_frame_ = false;
        this.mVideoParams.save_features_ = false;
        this.mVideoParams.use_npd_ = true;
        this.mVideoParams.use_mix_ = false;
        this.mVideoParams.asynchronous_save_features_ = true;
        this.mVideoParams.feature_strict_ = false;
        this.mVideoParams.pose_estimation_type_ = 1;
        this.mVideoParams.save_features_version_ = 1597463022;
        this.mVideoParams.track_switch_ = false;
        this.mVideoParams.beauty_switch_ = false;
        this.mVideoParams.skin_switch_ = false;
        this.mVideoParams.multifaces_switch_ = false;
        this.mVideoParams.warp_type_ = 0;
        this.mVideoParams.warp_level1_ = 0.0f;
        this.mVideoParams.warp_level2_ = 0.0f;
        this.mVideoParams.expression_switch_ = false;
        this.mVideoParams.eye_classify_switch_ = false;
        this.mVideoParams.face_alignment_version_ = 0;
        this.mVideoParams.focal_length_multiply_ = 10.0f;
        this.mVideoParams.do_facedect_corp_center_ = true;
        this.mVideoParams.asynchronous_face_detect_ = true;
        this.mVideoParams.debug_on_ = false;
        this.mVideoInfo = new VideoInfo();
        this.mFacerigV3Params = new FacerigV3Params();
        this.mFacerigV3Params.rotate_degree_ = this.mrCoreParameters.videoRotation == 0 ? this.mCamera.getCameraRotation() : 270 - this.mrCoreParameters.videoRotation;
        this.mFacerigV3Params.restore_degree_ = this.mCamera.getCameraRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreview() {
        MDLog.i((String)"AnimojiUtil", (String)"AnimojiUtil startPreview");
        Object object = this.syncObj;
        synchronized (object) {
            if (this.isPreviewing) {
                return;
            }
            if (this.mCamera != null && this.mBasicRender != null) {
                this.mCameraTexture = this.mBasicRender.createTexture();
                this.mCamera.setCameraDataCallback(null);
                this.mCamera.setCameraDataCallback((ICamera.ICameraDataCallback)this);
                this.mCamera.startPreview(this.mCameraTexture);
            }
            this.isPreviewing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPreview() {
        MDLog.i((String)"AnimojiUtil", (String)"AnimojiUtil stopPreview");
        Object object = this.syncObj;
        synchronized (object) {
            if (this.mCamera != null) {
                this.mCamera.setCameraDataCallback(null);
                this.mCamera.stopPreview();
            }
            this.mCameraTexture = null;
            this.isPreviewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        MDLog.i((String)"AnimojiUtil", (String)"AnimojiUtil release");
        Object object = this.syncObj;
        synchronized (object) {
            if (this.mVideoProcessor != null) {
                this.mVideoProcessor.Release();
            }
            if (this.mFaceRig != null) {
                this.mFaceRig.Release();
            }
            if (this.mCamera != null) {
                this.mCamera.setCameraDataCallback(null);
                this.mCamera.release();
                this.mCameraTexture = null;
                this.isPreviewing = false;
            }
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quit();
            }
        }
    }
}

